/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.WizardWithLicenses;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.wizard.IWizardPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallWizard
extends WizardWithLicenses {
    SelectableIUsPage errorReportingPage;

    public InstallWizard(ProvisioningUI ui, InstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob preloadJob) {
        super(ui, (ProfileChangeOperation)operation, initialSelections == null ? null : initialSelections.toArray(), preloadJob);
        this.setWindowTitle(ProvUIMessages.InstallIUOperationLabel);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/install_wiz.gif"));
    }

    @Override
    protected ResolutionResultsWizardPage createResolutionPage() {
        return new InstallWizardPage(this.ui, (ProvisioningOperationWizard)this, this.root, (InstallOperation)this.operation);
    }

    @Override
    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new AvailableIUsPage(this.ui, this);
        if (selections != null && selections.length > 0) {
            this.mainPage.setCheckedElements(selections);
        }
        return this.mainPage;
    }

    @Override
    protected void initializeResolutionModelElements(Object[] selectedElements) {
        if (selectedElements == null) {
            return;
        }
        this.root = new IUElementListRoot();
        ArrayList<AvailableIUElement> list = new ArrayList<AvailableIUElement>(selectedElements.length);
        ArrayList<AvailableIUElement> selections = new ArrayList<AvailableIUElement>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            IInstallableUnit iu = ElementUtils.getIU(selectedElements[i]);
            if (iu != null) {
                AvailableIUElement element = new AvailableIUElement(this.root, iu, this.getProfileId(), this.shouldShowProvisioningPlanChildren());
                list.add(element);
                selections.add(element);
            }
            ++i;
        }
        this.root.setChildren(list.toArray());
        this.planSelections = selections.toArray();
    }

    @Override
    protected ProvisioningContext getProvisioningContext() {
        return ((AvailableIUsPage)this.mainPage).getProvisioningContext();
    }

    @Override
    protected IResolutionErrorReportingPage createErrorReportingPage() {
        this.errorReportingPage = this.root == null ? new SelectableIUsPage(this.ui, this, null, null) : new SelectableIUsPage(this.ui, this, this.root, this.root.getChildren(this.root));
        this.errorReportingPage.setTitle(ProvUIMessages.InstallWizardPage_Title);
        this.errorReportingPage.setDescription(ProvUIMessages.PreselectedIUInstallWizard_Description);
        this.errorReportingPage.updateStatus(this.root, this.operation);
        return this.errorReportingPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.errorReportingPage) {
            this.mainPage.setCheckedElements(this.errorReportingPage.getCheckedIUElements());
            return this.mainPage;
        }
        return super.getPreviousPage(page);
    }

    @Override
    protected ProfileChangeOperation getProfileChangeOperation(Object[] elements) {
        InstallOperation op = new InstallOperation(this.ui.getSession(), ElementUtils.elementsToIUs(elements));
        op.setProfileId(this.getProfileId());
        return op;
    }

    @Override
    protected boolean shouldUpdateErrorPageModelOnPlanChange() {
        return this.getContainer().getCurrentPage() == this.mainPage && super.shouldUpdateErrorPageModelOnPlanChange();
    }
}

