/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.PathVariableEditDialog;
import org.eclipse.ui.internal.ide.misc.OverlayIcon;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportTypeDialog
extends TrayDialog {
    public static final int IMPORT_COPY = 1;
    public static final int IMPORT_FILES_ONLY = 16;
    public static final int IMPORT_LINK = 4;
    public static final int IMPORT_MOVE = 8;
    public static final int IMPORT_NONE = 0;
    public static final int IMPORT_VIRTUAL_FOLDERS_AND_LINKS = 2;
    private Button alwaysPerformThisOperation = null;
    private Button copyButton = null;
    private int currentSelection;
    private Image fileImage;
    private Image folderAndFileImage;
    private Button linkButton = null;
    private Image linkedFileImage;
    private Image linkedFolderAndFileImage;
    private Button moveButton = null;
    private int operationMask;
    private String preferredVariable;
    private IResource receivingResource = null;
    private Button shadowCopyButton = null;
    private boolean targetIsVirtual;
    private String variable = null;
    private Button variableCheckbox = null;
    private Combo variableCombo = null;
    private Image virtualFolderAndFileImage;

    public ImportTypeDialog(Shell shell, int dropOperation, IResource[] sources, IContainer target) {
        this(shell, ImportTypeDialog.selectAppropriateMask(dropOperation, sources, target), ImportTypeDialog.getPreferredVariable(sources, target), target.isVirtual());
    }

    public ImportTypeDialog(Shell shell, int dropOperation, String[] names, IContainer target) {
        this(shell, ImportTypeDialog.selectAppropriateMask(dropOperation, names, target), ImportTypeDialog.getPreferredVariable(names, target), target.isVirtual());
    }

    private ImportTypeDialog(Shell parentShell, int operationMask, String preferredVariable, boolean targetIsVirtual) {
        super(parentShell);
        this.preferredVariable = preferredVariable;
        this.operationMask = operationMask;
        this.targetIsVirtual = targetIsVirtual;
        this.currentSelection = 0;
        String tmp = this.readContextPreference("IMPORT_FILES_AND_FOLDERS_TYPE");
        if (tmp.length() > 0) {
            this.currentSelection = Integer.parseInt(tmp);
        }
        this.currentSelection &= operationMask;
        if (this.currentSelection == 0) {
            this.currentSelection = this.hasFlag(1) ? 1 : 8;
        }
        ImageDescriptor fileDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        ImageDescriptor folderDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        ImageDescriptor[][] linkedResourceOverlayMap = new ImageDescriptor[4][1];
        linkedResourceOverlayMap[1] = new ImageDescriptor[]{AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/ovr16/link_ovr.gif")};
        OverlayIcon linkedFileDescriptor = new OverlayIcon(fileDescriptor, linkedResourceOverlayMap, new Point(16, 16));
        OverlayIcon linkedFolderDescriptor = new OverlayIcon(folderDescriptor, linkedResourceOverlayMap, new Point(16, 16));
        ImageDescriptor[][] virtualFolderOverlayMap = new ImageDescriptor[4][1];
        virtualFolderOverlayMap[1] = new ImageDescriptor[]{AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/ovr16/virt_ovr.gif")};
        OverlayIcon virtualFolderDescriptor = new OverlayIcon(folderDescriptor, virtualFolderOverlayMap, new Point(16, 16));
        this.fileImage = fileDescriptor.createImage();
        this.linkedFileImage = linkedFileDescriptor.createImage();
        AlignedCompositeImageDescriptor desc = new AlignedCompositeImageDescriptor(fileDescriptor, folderDescriptor);
        this.folderAndFileImage = desc.createImage();
        desc = new AlignedCompositeImageDescriptor((ImageDescriptor)linkedFileDescriptor, (ImageDescriptor)virtualFolderDescriptor);
        this.virtualFolderAndFileImage = desc.createImage();
        desc = new AlignedCompositeImageDescriptor((ImageDescriptor)linkedFileDescriptor, (ImageDescriptor)linkedFolderDescriptor);
        this.linkedFolderAndFileImage = desc.createImage();
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("IMPORT_FILES_AND_FOLDERS_RELATIVE")) {
            this.variable = preferredVariable;
        }
    }

    public boolean close() {
        this.fileImage.dispose();
        this.linkedFileImage.dispose();
        this.folderAndFileImage.dispose();
        this.virtualFolderAndFileImage.dispose();
        this.linkedFolderAndFileImage.dispose();
        return super.close();
    }

    public int getSelection() {
        return this.currentSelection;
    }

    public String getVariable() {
        return this.variable;
    }

    public int open() {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String mode = store.getString(this.targetIsVirtual ? "IMPORT_FILES_AND_FOLDERS_VIRTUAL_FOLDER_MODE" : "IMPORT_FILES_AND_FOLDERS_MODE");
        if (mode.equals("prompt")) {
            return super.open();
        }
        if (mode.equals("MOVE_COPY") && this.hasFlag(1)) {
            this.currentSelection = 1;
            return 0;
        }
        if (mode.equals("MOVE_COPY") && this.hasFlag(8)) {
            this.currentSelection = 8;
            return 0;
        }
        if (mode.equals("LINK") && this.hasFlag(4)) {
            this.currentSelection = 4;
            return 0;
        }
        if (mode.equals("LINK_AND_VIRTUAL_FOLDER") && this.hasFlag(2)) {
            this.currentSelection = 2;
            return 0;
        }
        return super.open();
    }

    public void setResource(IResource resource) {
        this.receivingResource = resource;
    }

    private void editVariables() {
        String[] variableNames;
        String selectedItem = this.variable;
        PathVariableEditDialog dialog = new PathVariableEditDialog(this.getShell());
        dialog.setResource(this.receivingResource);
        if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length >= 1) {
            selectedItem = variableNames[0];
        }
        this.setupVariableContent();
        if (selectedItem != null) {
            this.selectVariable(selectedItem);
        }
    }

    private boolean hasFlag(int flag) {
        return (this.operationMask & flag) != 0;
    }

    private String readContextPreference(String key) {
        String value = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(key);
        String[] keyPairs = value.split(":");
        int i = 0;
        while (i < keyPairs.length) {
            String[] element = keyPairs[i].split(",");
            if (element.length == 2 && element[0].equals(Integer.toString(this.operationMask))) {
                return element[1];
            }
            ++i;
        }
        return "";
    }

    private void refreshSelection() {
        if (this.copyButton != null) {
            this.copyButton.setSelection(this.currentSelection == 1);
        }
        if (this.shadowCopyButton != null) {
            this.shadowCopyButton.setSelection(this.currentSelection == 2);
        }
        if (this.linkButton != null) {
            this.linkButton.setSelection(this.currentSelection == 4);
        }
        if (this.moveButton != null) {
            this.moveButton.setSelection(this.currentSelection == 8);
        }
        if (this.variableCheckbox != null) {
            this.variableCheckbox.setEnabled((this.currentSelection & 6) != 0);
        }
        if (this.variableCombo != null) {
            this.variableCombo.setEnabled(this.variableCheckbox.getSelection() && this.variableCheckbox.isEnabled());
        }
        this.setupVariableCheckboxToolTip();
    }

    private void selectVariable(String var) {
        String[] items = this.variableCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (var.equals(items[i])) {
                this.variableCombo.select(i);
                this.variable = items[i];
                return;
            }
            ++i;
        }
        this.variableCombo.select(0);
        this.variable = items[0];
    }

    private void setupVariableCheckboxToolTip() {
        if (this.variableCheckbox != null) {
            if (this.variableCheckbox.getSelection()) {
                this.variableCheckbox.setToolTipText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAsTooltipSet);
            } else {
                this.variableCheckbox.setToolTipText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAsTooltip);
            }
        }
    }

    private void setupVariableContent() {
        IPathVariableManager pathVariableManager = this.receivingResource != null ? this.receivingResource.getPathVariableManager() : ResourcesPlugin.getWorkspace().getPathVariableManager();
        String[] variables = pathVariableManager.getPathVariableNames();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < variables.length) {
            if (!variables[i].equals("PARENT")) {
                items.add(variables[i]);
            }
            ++i;
        }
        items.add(IDEWorkbenchMessages.ImportTypeDialog_editVariables);
        this.variableCombo.setItems(items.toArray(new String[0]));
        super.getShell().layout(true);
    }

    private void writeContextPreference(String key, String value) {
        String oldValue = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(key);
        StringBuffer buffer = new StringBuffer();
        String[] keyPairs = oldValue.split(":");
        boolean found = false;
        int i = 0;
        while (i < keyPairs.length) {
            String[] element;
            if (i > 0) {
                buffer.append(":");
            }
            if ((element = keyPairs[i].split(",")).length == 2) {
                if (element[0].equals(Integer.toString(this.operationMask))) {
                    buffer.append(String.valueOf(element[0]) + "," + value);
                    found = true;
                } else {
                    buffer.append(keyPairs[i]);
                }
            }
            ++i;
        }
        if (!found) {
            if (buffer.length() > 0) {
                buffer.append(":");
            }
            buffer.append(String.valueOf(Integer.toString(this.operationMask)) + "," + value);
        }
        String newValue = buffer.toString();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(key, newValue);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.writeContextPreference("IMPORT_FILES_AND_FOLDERS_TYPE", Integer.toString(this.currentSelection));
            IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
            store.putValue("IMPORT_FILES_AND_FOLDERS_RELATIVE", Boolean.toString(this.variable != null));
            if (this.alwaysPerformThisOperation.getSelection()) {
                String mode = "prompt";
                switch (this.currentSelection) {
                    case 1: 
                    case 8: {
                        mode = "MOVE_COPY";
                        break;
                    }
                    case 4: {
                        mode = "LINK";
                        break;
                    }
                    case 2: {
                        mode = "LINK_AND_VIRTUAL_FOLDER";
                    }
                }
                store.putValue(this.targetIsVirtual ? "IMPORT_FILES_AND_FOLDERS_VIRTUAL_FOLDER_MODE" : "IMPORT_FILES_AND_FOLDERS_MODE", mode);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = (this.operationMask & 0x10) != 0 ? IDEWorkbenchMessages.ImportTypeDialog_titleFilesOnly : IDEWorkbenchMessages.ImportTypeDialog_title;
        shell.setText(title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.import_type_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        boolean linkIsOnlyChoice;
        boolean bl = linkIsOnlyChoice = this.hasFlag(4) && !this.hasFlag(9) && (!this.hasFlag(2) || this.hasFlag(16));
        if (!linkIsOnlyChoice) {
            this.createMessageArea(parent);
        }
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        int indent = linkIsOnlyChoice ? 0 : this.convertWidthInCharsToPixels(3);
        layout.marginWidth += indent;
        composite.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportTypeDialog.this.currentSelection = (Integer)e.widget.getData();
                ImportTypeDialog.this.refreshSelection();
            }

            public void widgetSelected(SelectionEvent e) {
                ImportTypeDialog.this.currentSelection = (Integer)e.widget.getData();
                ImportTypeDialog.this.refreshSelection();
            }
        };
        if (this.hasFlag(1)) {
            this.copyButton = new Button(composite, 16);
            this.copyButton.setText(this.hasFlag(16) ? IDEWorkbenchMessages.ImportTypeDialog_copyFiles : IDEWorkbenchMessages.ImportTypeDialog_copyFilesAndDirectories);
            gridData = new GridData(768);
            this.copyButton.setLayoutData((Object)gridData);
            this.copyButton.setData((Object)new Integer(1));
            this.copyButton.addSelectionListener(listener);
            if (this.hasFlag(6)) {
                this.copyButton.setImage(this.hasFlag(16) ? this.fileImage : this.folderAndFileImage);
            }
        }
        if (this.hasFlag(8)) {
            this.moveButton = new Button(composite, 16);
            this.moveButton.setText(this.hasFlag(16) ? IDEWorkbenchMessages.ImportTypeDialog_moveFiles : IDEWorkbenchMessages.ImportTypeDialog_moveFilesAndDirectories);
            gridData = new GridData(768);
            this.moveButton.setLayoutData((Object)gridData);
            this.moveButton.setData((Object)new Integer(8));
            this.moveButton.addSelectionListener(listener);
        }
        if (this.hasFlag(4) && !linkIsOnlyChoice) {
            this.linkButton = new Button(composite, 16);
            this.linkButton.setText(this.hasFlag(16) ? IDEWorkbenchMessages.ImportTypeDialog_linkFiles : IDEWorkbenchMessages.ImportTypeDialog_createLinks);
            gridData = new GridData(768);
            this.linkButton.setLayoutData((Object)gridData);
            this.linkButton.setData((Object)new Integer(4));
            this.linkButton.addSelectionListener(listener);
            this.linkButton.setImage(this.hasFlag(16) ? this.linkedFileImage : this.linkedFolderAndFileImage);
        }
        if (this.hasFlag(2) && !this.hasFlag(16)) {
            this.shadowCopyButton = new Button(composite, 16);
            this.shadowCopyButton.setText(IDEWorkbenchMessages.ImportTypeDialog_recreateFilesAndDirectories);
            gridData = new GridData(768);
            this.shadowCopyButton.setLayoutData((Object)gridData);
            this.shadowCopyButton.setData((Object)new Integer(2));
            this.shadowCopyButton.addSelectionListener(listener);
            this.shadowCopyButton.setImage(this.virtualFolderAndFileImage);
        }
        if (this.hasFlag(6)) {
            Composite variableGroup = new Composite(composite, 0);
            gridData = new GridData(4, 4, true, true);
            variableGroup.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            variableGroup.setLayout((Layout)layout);
            this.variableCheckbox = new Button(variableGroup, 32);
            this.variableCheckbox.setText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAs);
            gridData = new GridData(32);
            this.variableCheckbox.setLayoutData((Object)gridData);
            this.variableCheckbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.selectRelativeCombo();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.selectRelativeCombo();
                }

                private void selectRelativeCombo() {
                    if (ImportTypeDialog.this.variableCheckbox.getSelection()) {
                        ImportTypeDialog.this.variableCombo.setEnabled(true);
                        ImportTypeDialog.this.selectVariable(ImportTypeDialog.this.variableCombo.getItem(ImportTypeDialog.this.variableCombo.getSelectionIndex()));
                        ImportTypeDialog.this.variableCheckbox.setToolTipText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAsTooltipSet);
                    } else {
                        ImportTypeDialog.this.variableCombo.setEnabled(false);
                        ImportTypeDialog.this.variable = null;
                        ImportTypeDialog.this.variableCheckbox.setToolTipText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAsTooltip);
                    }
                    ImportTypeDialog.this.setupVariableCheckboxToolTip();
                }
            });
            this.variableCombo = new Combo(variableGroup, 12);
            gridData = new GridData(32);
            this.variableCombo.setLayoutData((Object)gridData);
            this.variableCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (ImportTypeDialog.this.variableCombo.getSelectionIndex() == ImportTypeDialog.this.variableCombo.getItemCount() - 1) {
                        ImportTypeDialog.this.editVariables();
                    } else {
                        ImportTypeDialog.this.selectVariable(ImportTypeDialog.this.variableCombo.getItem(ImportTypeDialog.this.variableCombo.getSelectionIndex()));
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    if (ImportTypeDialog.this.variableCombo.getSelectionIndex() == ImportTypeDialog.this.variableCombo.getItemCount() - 1) {
                        ImportTypeDialog.this.editVariables();
                    } else {
                        ImportTypeDialog.this.selectVariable(ImportTypeDialog.this.variableCombo.getItem(ImportTypeDialog.this.variableCombo.getSelectionIndex()));
                    }
                }
            });
            this.setupVariableContent();
            this.variableCheckbox.setSelection(this.variable != null);
            if (this.variable != null) {
                this.selectVariable(this.variable);
            } else {
                this.selectVariable(this.preferredVariable);
            }
        }
        if (linkIsOnlyChoice) {
            this.currentSelection = 4;
            parent.getShell().setText(IDEWorkbenchMessages.ImportTypeDialog_titleFilesLinking);
        }
        this.alwaysPerformThisOperation = new Button(parent, 32);
        this.alwaysPerformThisOperation.setText(linkIsOnlyChoice ? IDEWorkbenchMessages.ImportTypeDialog_alwaysUseLocationWhenLinkingFiles : IDEWorkbenchMessages.ImportTypeDialog_alwaysPerformThisOperation);
        gridData = new GridData(32);
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        this.alwaysPerformThisOperation.setLayoutData((Object)gridData);
        this.refreshSelection();
        return composite;
    }

    protected Control createMessageArea(Composite parent) {
        String message;
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        String string = message = (this.operationMask & 0x10) != 0 ? IDEWorkbenchMessages.ImportTypeDialog_questionFilesOnly : IDEWorkbenchMessages.ImportTypeDialog_question;
        if (message != null) {
            Label messageLabel = new Label(composite, 64);
            messageLabel.setText(message);
            gridData = new GridData(4, 1, true, false);
            messageLabel.setLayoutData((Object)gridData);
        }
        return composite;
    }

    private static boolean areOnlyFiles(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean areOnlyFiles(String[] names) {
        int i = 0;
        while (i < names.length) {
            File file = new File(names[i]);
            if (file.exists() && !file.isFile()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getPreferredVariable(IPath[] paths, IContainer target) {
        IPath commonRoot = null;
        int i = 0;
        while (i < paths.length) {
            if (paths[i] != null) {
                if (commonRoot == null) {
                    commonRoot = paths[i];
                } else {
                    int count = commonRoot.matchingFirstSegments(paths[i]);
                    int remainingSegments = commonRoot.segmentCount() - count;
                    if (remainingSegments <= 0) {
                        return null;
                    }
                    commonRoot = commonRoot.removeLastSegments(remainingSegments);
                }
            }
            ++i;
        }
        String mostAppropriate = null;
        String mostAppropriateToParent = null;
        int mostAppropriateCount = Integer.MAX_VALUE;
        int mostAppropriateCountToParent = Integer.MAX_VALUE;
        IPathVariableManager pathVariableManager = target.getPathVariableManager();
        String[] variables = pathVariableManager.getPathVariableNames();
        int i2 = 0;
        while (i2 < variables.length) {
            IPath path;
            URI rawValue;
            URI value;
            if (ImportTypeDialog.isPreferred(variables[i2]) && (value = pathVariableManager.resolveURI(rawValue = pathVariableManager.getURIValue(variables[i2]))) != null && (path = URIUtil.toPath((URI)value)) != null) {
                int difference = path.matchingFirstSegments(commonRoot);
                if (difference > 0) {
                    if (difference < mostAppropriateCount) {
                        mostAppropriateCount = difference;
                        mostAppropriate = variables[i2];
                    }
                } else {
                    difference = commonRoot.matchingFirstSegments(path);
                    if (difference > 0 && difference < mostAppropriateCountToParent) {
                        mostAppropriateCountToParent = difference;
                        mostAppropriateToParent = variables[i2];
                    }
                }
            }
            ++i2;
        }
        if (mostAppropriate == null) {
            if (mostAppropriateToParent == null) {
                return "PROJECT_LOC";
            }
            return mostAppropriateToParent;
        }
        return mostAppropriate;
    }

    private static boolean isPreferred(String variableName) {
        return !variableName.equals("WORKSPACE_LOC") && !variableName.equals("PARENT_LOC") && !variableName.equals("PARENT");
    }

    private static String getPreferredVariable(IResource[] sources, IContainer target) {
        IPath[] paths = new IPath[sources.length];
        int i = 0;
        while (i < sources.length) {
            paths[i] = sources[i].getLocation();
            ++i;
        }
        return ImportTypeDialog.getPreferredVariable(paths, target);
    }

    private static String getPreferredVariable(String[] names, IContainer target) {
        IPath[] paths = new IPath[names.length];
        int i = 0;
        while (i < names.length) {
            paths[i] = Path.fromOSString((String)names[i]);
            ++i;
        }
        return ImportTypeDialog.getPreferredVariable(paths, target);
    }

    private static int selectAppropriateMask(int dropOperation, IResource[] resources, IContainer target) {
        int mask = 6;
        if (!target.isVirtual() && dropOperation != 4) {
            mask |= 1;
        }
        if (ImportTypeDialog.areOnlyFiles(resources)) {
            mask |= 0x10;
        }
        return mask;
    }

    private static int selectAppropriateMask(int dropOperation, String[] names, IContainer target) {
        int mask = 6;
        if (!target.isVirtual() && dropOperation != 4) {
            mask |= 1;
        }
        if (ImportTypeDialog.areOnlyFiles(names)) {
            mask |= 0x10;
        }
        return mask;
    }

    private class AlignedCompositeImageDescriptor
    extends CompositeImageDescriptor {
        private int SPACE = 4;
        ImageDescriptor first;
        ImageDescriptor second;

        AlignedCompositeImageDescriptor(ImageDescriptor first, ImageDescriptor second) {
            this.first = first;
            this.second = second;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.first.getImageData(), 0, 0);
            this.drawImage(this.second.getImageData(), this.first.getImageData().width + this.SPACE, 0);
        }

        protected Point getSize() {
            return new Point(this.first.getImageData().width + this.second.getImageData().width + this.SPACE, Math.max(this.first.getImageData().height, this.second.getImageData().height));
        }
    }
}

