/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathChange;
import org.eclipse.wst.jsdt.internal.core.ClasspathValidation;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessingState;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessor;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.ProjectReferenceChange;

public abstract class ChangeClasspathOperation
extends JavaModelOperation {
    protected boolean canChangeResources;

    public ChangeClasspathOperation(IJavaScriptElement[] elements, boolean canChangeResources) {
        super(elements);
        this.canChangeResources = canChangeResources;
    }

    protected boolean canModifyRoots() {
        return true;
    }

    protected void classpathChanged(JavaProject project) throws JavaScriptModelException {
        DeltaProcessingState state = JavaModelManager.getJavaModelManager().deltaState;
        DeltaProcessor deltaProcessor = state.getDeltaProcessor();
        ClasspathChange change = (ClasspathChange)deltaProcessor.classpathChanges.get(project.getProject());
        if (this.canChangeResources) {
            if (this.isTopLevelOperation() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                new ClasspathValidation(project).validate();
            }
            new ProjectReferenceChange(project, change.oldResolvedClasspath).updateProjectReferencesIfNecessary();
        } else {
            JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
            int result = change.generateDelta(delta);
            if ((result & ClasspathChange.HAS_DELTA) != 0) {
                this.addDelta(delta);
                change.requestIndexing();
                state.addClasspathValidation(project);
            }
            if ((result & ClasspathChange.HAS_PROJECT_CHANGE) != 0) {
                state.addProjectReferenceChange(project, change.oldResolvedClasspath);
            }
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    public boolean isReadOnly() {
        return !this.canChangeResources;
    }
}

