/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.launching;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;

public class JavaScriptSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    static final Object[] NO_SOURCE = new Object[0];
    static final Object[] FILE = new Object[1];
    private static int source_counter = 1;

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof IJavaScriptStackFrame) {
            return ((IJavaScriptStackFrame)object).getSourceName();
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        IJavaScriptStackFrame jframe;
        String path;
        if (object instanceof IJavaScriptStackFrame && (path = (jframe = (IJavaScriptStackFrame)object).getSourcePath()) != null) {
            IFile file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path), false);
            if (file != null) {
                return new IFile[]{file};
            }
            Object[] sources = super.findSourceElements(object);
            if (sources != null && sources.length > 0) {
                return sources;
            }
            return this.showExternalSource(jframe.getSource(), path);
        }
        return NO_SOURCE;
    }

    Object[] showExternalSource(String source, String path) {
        try {
            File tempdir = new File(System.getProperty("java.io.tmpdir"));
            File file = new File(tempdir, this.formatExternalName(path));
            file.deleteOnExit();
            FileWriter writer = new FileWriter(file);
            writer.write(source);
            writer.close();
            JavaScriptSourceLookupParticipant.FILE[0] = file;
            return FILE;
        }
        catch (IOException e) {
            JavaScriptDebugPlugin.log(e);
            return NO_SOURCE;
        }
    }

    String formatExternalName(String basename) {
        Path path = null;
        path = basename == null ? new Path("script") : new Path(basename);
        path = path.removeFileExtension();
        StringBuffer buffer = new StringBuffer(path.toString());
        buffer.append("_").append(source_counter++).append(".js");
        return buffer.toString();
    }

    public boolean isFindDuplicates() {
        return true;
    }
}

