/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.Event;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventQueue;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.internal.core.model.IJavaScriptEventListener;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public final class EventDispatcher
implements Runnable {
    public static final int EVENT_SCRIPT_LOADED = 1;
    private HashMap listeners = null;
    private boolean shutdown = false;
    private JavaScriptDebugTarget target = null;

    public EventDispatcher(JavaScriptDebugTarget target) {
        this.target = target;
    }

    public synchronized void addEventListener(IJavaScriptEventListener listener, EventRequest request) {
        HashSet<IJavaScriptEventListener> lsts;
        if (this.listeners == null) {
            this.listeners = new HashMap(4);
        }
        if ((lsts = (HashSet<IJavaScriptEventListener>)this.listeners.get(request)) == null) {
            lsts = new HashSet<IJavaScriptEventListener>(4);
            this.listeners.put(request, lsts);
        }
        lsts.add(listener);
    }

    public synchronized boolean removeEventListener(IJavaScriptEventListener listener, EventRequest request) {
        HashSet lsts;
        if (this.listeners != null && (lsts = (HashSet)this.listeners.get(request)) != null) {
            return lsts.remove(listener);
        }
        return false;
    }

    public void run() {
        if (this.shutdown) {
            return;
        }
        VirtualMachine vm = this.target.getVM();
        if (vm != null) {
            EventQueue queue = vm.eventQueue();
            EventSet eventset = null;
            while (!this.shutdown) {
                eventset = queue.remove();
                if (eventset == null) continue;
                this.dispatch(eventset);
            }
        }
    }

    void dispatch(EventSet eventSet) {
        Iterator iter2;
        Event event = null;
        boolean resume = true;
        HashSet lsts = null;
        Iterator iter = eventSet.iterator();
        while (iter.hasNext()) {
            event = (Event)iter.next();
            if (event == null || (lsts = (HashSet)this.listeners.get(event.request())) == null) continue;
            iter2 = lsts.iterator();
            while (iter2.hasNext()) {
                resume &= ((IJavaScriptEventListener)iter2.next()).handleEvent(event, this.target, false, eventSet);
            }
        }
        iter = eventSet.iterator();
        while (iter.hasNext()) {
            event = (Event)iter.next();
            if (event == null || (lsts = (HashSet)this.listeners.get(event.request())) == null) continue;
            iter2 = lsts.iterator();
            while (iter2.hasNext()) {
                ((IJavaScriptEventListener)iter2.next()).eventSetComplete(event, this.target, !resume, eventSet);
            }
        }
        if (resume) {
            eventSet.resume();
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.listeners.clear();
    }
}

