/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.commands;

import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class MoveChildCommand
extends Command {
    private EditPart child;
    private EditPart after;
    int oldPosition = -1;
    int newPosition = -1;
    XamlNode parentNode;
    XamlNode childNode;

    public MoveChildCommand(EditPart child, EditPart after) {
        super("Move Child Command");
        this.child = child;
        this.after = after;
    }

    public boolean canExecute() {
        EObject eContainer;
        Object model;
        if (this.child == null || this.child == this.after) {
            return false;
        }
        if (this.after != null && (model = this.after.getModel()) instanceof XamlNode && (eContainer = ((XamlNode)model).eContainer()) instanceof XamlNode) {
            this.parentNode = (XamlNode)eContainer;
        }
        if (this.parentNode == null && (model = this.child.getModel()) instanceof XamlNode && (eContainer = ((XamlNode)model).eContainer()) instanceof XamlNode) {
            this.parentNode = (XamlNode)eContainer;
        }
        if (this.parentNode == null) {
            return false;
        }
        this.oldPosition = this.parentNode.getChildNodes().indexOf(this.child.getModel());
        this.newPosition = this.after != null ? this.parentNode.getChildNodes().indexOf(this.after.getModel()) : this.parentNode.getChildNodes().size() - 1;
        if (this.newPosition > this.oldPosition) {
            --this.newPosition;
        }
        return this.newPosition != -1 && this.oldPosition != -1 && this.oldPosition != this.newPosition;
    }

    public void execute() {
        EList children = this.parentNode.getChildNodes();
        children.move(this.newPosition, this.oldPosition);
    }

    public boolean canUndo() {
        return this.parentNode != null && this.newPosition != -1 && this.oldPosition != -1 && this.newPosition != this.oldPosition;
    }

    public void undo() {
        this.parentNode.getChildNodes().move(this.oldPosition, this.newPosition);
    }
}

