/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventQueue;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.BreakpointRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ExceptionRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.StepRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.SuspendRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadEnterRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadExitRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.VMDeathRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.RhinoDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ScriptReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ThreadReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.BreakpointEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.DebuggerStatementEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.EventSetImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.ExceptionEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.ScriptLoadEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.StepEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.SuspendEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.ThreadEnterEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.ThreadExitEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.event.VMDeathEventImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.BreakpointRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.DebuggerStatementRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.EventRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.EventRequestManagerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.StepRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.SuspendRequestImpl;
import org.eclipse.wst.jsdt.debug.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.rhino.transport.TimeoutException;

public final class EventQueueImpl
implements EventQueue {
    private VirtualMachineImpl vm;
    private EventRequestManagerImpl eventRequestManager;

    public EventQueueImpl(VirtualMachineImpl vm, EventRequestManagerImpl eventRequestManager) {
        this.vm = vm;
        this.eventRequestManager = eventRequestManager;
    }

    public EventSet remove() {
        return this.remove(-1);
    }

    public EventSet remove(int timeout) {
        try {
            EventSetImpl eventSet;
            while (true) {
                Location location;
                ScriptReferenceImpl script;
                Long scriptId;
                ThreadReferenceImpl thread;
                Long threadId;
                EventPacket event = this.vm.receiveEvent(timeout);
                String eventName = event.getEvent();
                eventSet = new EventSetImpl(this.vm);
                if (eventName.equals("script")) {
                    threadId = new Long(((Number)event.getBody().get("threadId")).longValue());
                    thread = this.vm.getThread(threadId);
                    if (thread == null) continue;
                    eventSet.setThread(thread);
                    scriptId = new Long(((Number)event.getBody().get("scriptId")).longValue());
                    script = this.vm.addScript(scriptId);
                    if (script != null) {
                        List scriptLoadRequests = this.eventRequestManager.scriptLoadRequests();
                        Iterator iterator = scriptLoadRequests.iterator();
                        while (iterator.hasNext()) {
                            ScriptLoadRequest request = (ScriptLoadRequest)iterator.next();
                            if (!request.isEnabled()) continue;
                            eventSet.add(new ScriptLoadEventImpl(this.vm, (ThreadReference)thread, script, request));
                        }
                    }
                } else if (eventName.equals("break")) {
                    threadId = new Long(((Number)event.getBody().get("threadId")).longValue());
                    thread = this.vm.getThread(threadId);
                    if (thread == null) continue;
                    eventSet.setThread(thread);
                    scriptId = new Long(((Number)event.getBody().get("scriptId")).longValue());
                    script = this.vm.getScript(scriptId);
                    if (script != null) {
                        String stepType;
                        ThreadReference requestThread;
                        EventRequestImpl request;
                        Iterator iterator;
                        int lineNumber = ((Number)event.getBody().get("lineNumber")).intValue();
                        location = script.lineLocation(lineNumber);
                        boolean atBreakpoint = false;
                        List jsonBreakpoints = (List)event.getBody().get("breakpoints");
                        if (jsonBreakpoints != null) {
                            ArrayList<Long> breakpoints = new ArrayList<Long>(jsonBreakpoints.size());
                            Iterator iterator2 = jsonBreakpoints.iterator();
                            while (iterator2.hasNext()) {
                                Number breakpointId = (Number)iterator2.next();
                                breakpoints.add(new Long(breakpointId.longValue()));
                            }
                            List breakpointRequests = this.eventRequestManager.breakpointRequests();
                            iterator = breakpointRequests.iterator();
                            while (iterator.hasNext()) {
                                request = (BreakpointRequestImpl)iterator.next();
                                requestThread = ((BreakpointRequestImpl)request).thread();
                                if (!request.isEnabled() || requestThread != null && thread != requestThread || !breakpoints.contains(((BreakpointRequestImpl)request).breakpointId())) continue;
                                eventSet.add(new BreakpointEventImpl(this.vm, (ThreadReference)thread, location, (BreakpointRequest)request));
                                atBreakpoint = true;
                            }
                        }
                        if ("suspended".equals(stepType = (String)event.getBody().get("step"))) {
                            List suspendRequests = this.eventRequestManager.suspendRequests();
                            iterator = suspendRequests.iterator();
                            while (iterator.hasNext()) {
                                request = (SuspendRequestImpl)iterator.next();
                                requestThread = ((SuspendRequestImpl)request).thread();
                                if (!request.isEnabled() || requestThread != null && thread != requestThread) continue;
                                eventSet.add(new SuspendEventImpl(this.vm, (ThreadReference)thread, location, (SuspendRequest)request));
                            }
                        } else if (stepType != null) {
                            List stepRequests = this.eventRequestManager.stepRequests();
                            iterator = stepRequests.iterator();
                            while (iterator.hasNext()) {
                                request = (StepRequestImpl)iterator.next();
                                requestThread = ((StepRequestImpl)request).thread();
                                if (!request.isEnabled() || requestThread != null && thread != requestThread) continue;
                                eventSet.add(new StepEventImpl(this.vm, (ThreadReference)thread, location, (StepRequest)request));
                            }
                        }
                        Boolean debuggerStatement = (Boolean)event.getBody().get("debuggerStatement");
                        if (debuggerStatement.booleanValue()) {
                            List debuggerStatementRequests = this.eventRequestManager.debuggerStatementRequests();
                            Iterator iterator3 = debuggerStatementRequests.iterator();
                            while (iterator3.hasNext()) {
                                DebuggerStatementRequestImpl request2 = (DebuggerStatementRequestImpl)iterator3.next();
                                ThreadReference requestThread2 = request2.thread();
                                if (!request2.isEnabled() || requestThread2 != null && thread != requestThread2) continue;
                                eventSet.add(new DebuggerStatementEventImpl(this.vm, (ThreadReference)thread, location, request2));
                            }
                        }
                        if (!eventSet.isEmpty()) {
                            thread.markSuspended(atBreakpoint);
                        }
                    }
                } else if (eventName.equals("exception")) {
                    threadId = new Long(((Number)event.getBody().get("threadId")).longValue());
                    thread = this.vm.getThread(threadId);
                    if (thread != null) {
                        eventSet.setThread(thread);
                        scriptId = new Long(((Number)event.getBody().get("scriptId")).longValue());
                        script = this.vm.getScript(scriptId);
                        int lineNumber = ((Number)event.getBody().get("lineNumber")).intValue();
                        location = script.lineLocation(lineNumber);
                        String message = (String)event.getBody().get("message");
                        List exceptionRequests = this.eventRequestManager.exceptionRequests();
                        Iterator iterator = exceptionRequests.iterator();
                        while (iterator.hasNext()) {
                            ExceptionRequest request = (ExceptionRequest)iterator.next();
                            if (!request.isEnabled()) continue;
                            eventSet.add(new ExceptionEventImpl(this.vm, thread, location, message, request));
                        }
                        if (!eventSet.isEmpty()) {
                            thread.markSuspended(false);
                        }
                    }
                } else if (eventName.equals("thread")) {
                    ThreadExitRequest request;
                    Iterator iterator;
                    ThreadReferenceImpl thread2;
                    threadId = new Long(((Number)event.getBody().get("threadId")).longValue());
                    String type = (String)event.getBody().get("type");
                    if ("enter".equals(type)) {
                        thread2 = this.vm.getThread(threadId);
                        if (thread2 != null) {
                            eventSet.setThread(thread2);
                            List threadEnterRequests = this.eventRequestManager.threadEnterRequests();
                            iterator = threadEnterRequests.iterator();
                            while (iterator.hasNext()) {
                                request = (ThreadEnterRequest)iterator.next();
                                if (!request.isEnabled()) continue;
                                eventSet.add(new ThreadEnterEventImpl(this.vm, thread2, (ThreadEnterRequest)request));
                            }
                        }
                    } else if ("exit".equals(type)) {
                        thread2 = this.vm.removeThread(threadId);
                        List threadExitRequests = this.eventRequestManager.threadExitRequests();
                        iterator = threadExitRequests.iterator();
                        while (iterator.hasNext()) {
                            request = (ThreadExitRequest)iterator.next();
                            if (!request.isEnabled()) continue;
                            eventSet.add(new ThreadExitEventImpl(this.vm, thread2, request));
                        }
                    } else if ("vmdeath".equals(type)) {
                        List requests = this.eventRequestManager.vmDeathRequests();
                        Iterator iter = requests.iterator();
                        while (iter.hasNext()) {
                            VMDeathRequest request3 = (VMDeathRequest)iter.next();
                            if (!request3.isEnabled()) continue;
                            eventSet.add(new VMDeathEventImpl(this.vm, (EventRequest)request3));
                        }
                    }
                }
                if (!eventSet.isEmpty()) break;
                eventSet.resume();
            }
            return eventSet;
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        catch (DisconnectedException disconnectedException) {
            this.vm.disconnectVM();
        }
        return null;
    }
}

