/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;
import org.eclipse.pde.api.tools.internal.search.XmlReferenceDescriptorWriter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceLookupVisitor
extends UseScanVisitor {
    private IApiBaseline baseline;
    private IComponentDescriptor targetComponent;
    private IComponentDescriptor referencingComponent;
    private IApiComponent currComponent;
    private boolean skipped = false;
    private IMemberDescriptor targetMember;
    private IReferenceTypeDescriptor targetType;
    private IApiType currType;
    private List missingComponents = new ArrayList();
    private List skippedComponents = new ArrayList();
    private String location;
    private List unresolved = null;
    private String analysisScope = null;
    private String targetScope = null;

    public ReferenceLookupVisitor(IApiBaseline base, String xmlLocation) {
        this.baseline = base;
        this.location = xmlLocation;
    }

    public boolean visitComponent(IComponentDescriptor target) {
        this.unresolved = new ArrayList();
        this.targetComponent = target;
        this.skipped = false;
        if (this.targetScope == null || target.getId().matches(this.targetScope)) {
            this.currComponent = this.baseline.getApiComponent(this.targetComponent.getId());
            return true;
        }
        this.skipped = true;
        return false;
    }

    public boolean visitReferencingComponent(IComponentDescriptor component) {
        this.referencingComponent = component;
        if (this.currComponent == null) {
            return false;
        }
        return this.analysisScope == null || component.getId().matches(this.analysisScope);
    }

    public boolean visitMember(IMemberDescriptor referencedMember) {
        this.targetMember = referencedMember;
        switch (this.targetMember.getElementType()) {
            case 2: {
                this.targetType = (IReferenceTypeDescriptor)this.targetMember;
                break;
            }
            case 5: 
            case 6: {
                this.targetType = this.targetMember.getEnclosingType();
            }
        }
        this.currType = null;
        try {
            IApiTypeRoot typeRoot = null;
            IApiComponent[] comps = this.currComponent.getBaseline().resolvePackage(this.currComponent, this.targetType.getPackage().getName());
            int i = 0;
            while (i < comps.length) {
                typeRoot = comps[i].findTypeRoot(this.targetType.getQualifiedName());
                if (typeRoot != null) break;
                ++i;
            }
            if (typeRoot != null) {
                this.currType = typeRoot.getStructure();
            }
            return true;
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
            return false;
        }
    }

    public void visitReference(IReferenceDescriptor reference) {
        Reference ref = null;
        IApiMember resolved = null;
        int refKind = reference.getReferenceKind();
        int lineNumber = reference.getLineNumber();
        IMemberDescriptor origin = reference.getMember();
        if (this.currType != null) {
            switch (this.targetMember.getElementType()) {
                case 2: {
                    ref = Reference.typeReference(this.currType, this.targetType.getQualifiedName(), refKind);
                    break;
                }
                case 6: {
                    ref = Reference.methodReference(this.currType, this.targetType.getQualifiedName(), this.targetMember.getName(), ((IMethodDescriptor)this.targetMember).getSignature(), refKind);
                    break;
                }
                case 5: {
                    ref = Reference.fieldReference(this.currType, this.targetType.getQualifiedName(), this.targetMember.getName(), refKind);
                }
            }
        }
        if (ref != null) {
            try {
                ref.resolve();
                resolved = ref.getResolvedReference();
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
            }
        }
        if (resolved == null) {
            this.addError(Factory.referenceDescriptor(this.referencingComponent, origin, lineNumber, this.targetComponent, this.targetMember, refKind, reference.getReferenceFlags(), reference.getVisibility(), null));
        }
    }

    private void addError(IReferenceDescriptor error) {
        this.unresolved.add(error);
    }

    public void endVisit(IComponentDescriptor target) {
        if (this.skipped) {
            this.skippedComponents.add(target);
        } else if (this.currComponent == null) {
            this.missingComponents.add(target);
        } else if (!this.unresolved.isEmpty()) {
            XmlReferenceDescriptorWriter writer = new XmlReferenceDescriptorWriter(this.location);
            writer.setAlternate((IComponentDescriptor)this.currComponent.getHandle());
            writer.writeReferences(this.unresolved.toArray(new IReferenceDescriptor[this.unresolved.size()]));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void endVisitScan() {
        block25: {
            writer = null;
            try {
                rootfile = new File(this.location);
                if (!rootfile.exists()) {
                    rootfile.mkdirs();
                }
                if (!(file = new File(rootfile, "not_searched.xml")).exists()) {
                    file.createNewFile();
                }
                doc = Util.newDocument();
                root = doc.createElement("components");
                doc.appendChild(root);
                this.addMissingComponents(this.missingComponents, SearchMessages.ReferenceLookupVisitor_0, doc, root);
                this.addMissingComponents(this.skippedComponents, SearchMessages.SkippedComponent_component_was_excluded, doc, root);
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(Util.serializeDocument(doc));
                writer.flush();
            }
            catch (FileNotFoundException v0) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block25;
                }
                catch (IOException v1) {}
                break block25;
            }
            catch (IOException v2) {
                ** try [egrp 3[TRYBLOCK] [7 : 155->156)] { 
lbl31:
                // 1 sources

                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block25;
                }
                catch (IOException v3) {}
                break block25;
            }
            catch (CoreException v4) {
                ** try [egrp 5[TRYBLOCK] [8 : 171->172)] { 
lbl-1000:
                // 3 sources

                {
                    catch (Throwable var6_6) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException v5) {}
                        throw var6_6;
                    }
                }
lbl47:
                // 1 sources

                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block25;
                }
                catch (IOException v6) {}
                break block25;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException v7) {}
        }
    }

    private void addMissingComponents(List missing, String details, Document doc, Element root) {
        Iterator iter = missing.iterator();
        while (iter.hasNext()) {
            IComponentDescriptor component = (IComponentDescriptor)iter.next();
            Element comp = doc.createElement("component");
            comp.setAttribute("id", component.getId());
            comp.setAttribute("version", component.getVersion());
            comp.setAttribute("details", details);
            root.appendChild(comp);
        }
    }

    public void setAnalysisScope(String regex) {
        this.analysisScope = regex;
    }

    public void setTargetScope(String regex) {
        this.targetScope = regex;
    }
}

