/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.debugger;

import java.util.HashMap;
import org.eclipse.wst.jsdt.debug.rhino.debugger.DebugFrameImpl;
import org.eclipse.wst.jsdt.debug.rhino.debugger.ScriptImpl;

public class BreakpointImpl {
    private final Long breakpointId;
    private final ScriptImpl script;
    private final Integer lineNumber;
    private final Object functionName;
    private final String condition;
    private final Long threadId;

    public BreakpointImpl(Long breakpointId, ScriptImpl script, Integer lineNumber, String functionName, String condition, Long threadId) {
        if (script == null) {
            throw new NullPointerException();
        }
        this.breakpointId = breakpointId;
        this.script = script;
        this.lineNumber = lineNumber;
        this.functionName = functionName;
        this.condition = condition;
        this.threadId = threadId;
    }

    public Object toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("breakpointId", this.breakpointId);
        result.put("scriptId", this.script.getId());
        if (this.lineNumber != null) {
            result.put("line", this.lineNumber);
        }
        if (this.functionName != null) {
            result.put("function", this.functionName);
        }
        if (this.condition != null) {
            result.put("condition", this.condition);
        }
        if (this.threadId != null) {
            result.put("threadId", this.threadId);
        }
        return result;
    }

    public Long getId() {
        return this.breakpointId;
    }

    public ScriptImpl getScript() {
        return this.script;
    }

    public boolean matches(String functionName, Integer lineNumber, DebugFrameImpl frame) {
        if (this.lineNumber == null) {
            if (functionName == null) {
                return lineNumber == 1 && this.functionName == null && this.checkThread(frame) && this.checkCondition(frame);
            }
            return functionName.equals(this.functionName) && this.checkThread(frame) && this.checkCondition(frame);
        }
        return this.lineNumber.equals(lineNumber) && this.checkThread(frame) && this.checkCondition(frame);
    }

    private boolean checkThread(DebugFrameImpl frame) {
        if (this.threadId == null) {
            return true;
        }
        return frame.getThreadId().equals(this.threadId);
    }

    private boolean checkCondition(DebugFrameImpl frame) {
        if (this.condition == null) {
            return true;
        }
        return frame.evaluateCondition(this.condition);
    }
}

