/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.debugger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.wst.jsdt.debug.rhino.debugger.ContextData;
import org.eclipse.wst.jsdt.debug.rhino.debugger.DebugFrameImpl;
import org.eclipse.wst.jsdt.debug.rhino.debugger.RhinoDebugger;
import org.eclipse.wst.jsdt.debug.rhino.debugger.ScriptImpl;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class ThreadData {
    private final LinkedList contexts = new LinkedList();
    private final Long threadId;
    private final RhinoDebugger debugger;
    private long currentContextId = 0L;
    private long currentFrameId = 0L;

    public ThreadData(Long threadId, RhinoDebugger debugger) {
        this.threadId = threadId;
        this.debugger = debugger;
    }

    public synchronized Object toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("threadId", this.threadId);
        if (this.contexts.isEmpty()) {
            result.put("state", "running");
        } else {
            Context top = (Context)this.contexts.getFirst();
            result.put("state", ((ContextData)top.getDebuggerContextData()).getState());
        }
        ArrayList<Long> contextIds = new ArrayList<Long>(this.contexts.size());
        Iterator iterator = this.contexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            ContextData data = (ContextData)context.getDebuggerContextData();
            contextIds.add(data.getId());
        }
        result.put("contexts", contextIds);
        return result;
    }

    public synchronized void contextCreated(Context context) {
        context.setGeneratingDebug(true);
        context.setOptimizationLevel(-1);
        ContextData contextData = new ContextData(this.threadId, new Long(this.currentContextId++), this.debugger);
        context.setDebugger((Debugger)this.debugger, (Object)contextData);
        this.contexts.addFirst(context);
    }

    public synchronized void contextReleased(Context context) {
        if (this.hasContext()) {
            this.contexts.removeFirst();
        }
    }

    public synchronized boolean hasContext() {
        return !this.contexts.isEmpty();
    }

    public synchronized List getFrameIds() {
        ArrayList result = new ArrayList(this.contexts.size());
        Iterator iterator = this.contexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            ContextData data = (ContextData)context.getDebuggerContextData();
            result.addAll(data.getFrameIds());
        }
        return result;
    }

    public synchronized void suspend() {
        if (this.hasContext()) {
            Context context = (Context)this.contexts.getFirst();
            if (context == null) {
                return;
            }
            ContextData data = (ContextData)context.getDebuggerContextData();
            data.suspend();
        }
    }

    public synchronized void resume(String stepType) {
        if (this.hasContext()) {
            Context context = (Context)this.contexts.getFirst();
            if (context == null) {
                return;
            }
            ContextData data = (ContextData)context.getDebuggerContextData();
            data.resume(stepType);
        }
    }

    public DebugFrameImpl getFrame(Long frameId) {
        Iterator iterator = this.contexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            ContextData data = (ContextData)context.getDebuggerContextData();
            DebugFrameImpl frame = data.getFrame(frameId);
            if (frame == null) continue;
            return frame;
        }
        return null;
    }

    public synchronized DebugFrame getFrame(Context context, DebuggableScript debuggableScript, ScriptImpl script) {
        return new DebugFrameImpl(new Long(this.currentFrameId++), context, debuggableScript, script);
    }
}

