/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.transport;

import org.eclipse.wst.jsdt.debug.rhino.transport.Connection;
import org.eclipse.wst.jsdt.debug.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.rhino.transport.PacketReceiveManager;
import org.eclipse.wst.jsdt.debug.rhino.transport.PacketSendManager;
import org.eclipse.wst.jsdt.debug.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.rhino.transport.TimeoutException;

public class DebugSession {
    private final PacketReceiveManager packetReceiveManager;
    private final PacketSendManager packetSendManager;

    public DebugSession(Connection connection) {
        this.packetReceiveManager = new PacketReceiveManager(connection);
        Thread receiveThread = new Thread((Runnable)this.packetReceiveManager, "Debug Session - Receive Manager");
        receiveThread.setDaemon(true);
        this.packetSendManager = new PacketSendManager(connection);
        Thread sendThread = new Thread((Runnable)this.packetSendManager, "Debug Session - Send Manager");
        sendThread.setDaemon(true);
        this.packetReceiveManager.setPartnerThread(sendThread);
        this.packetSendManager.setPartnerThread(receiveThread);
        receiveThread.start();
        sendThread.start();
    }

    public void dispose() {
        this.packetReceiveManager.disconnect();
        this.packetSendManager.disconnect();
    }

    public void sendRequest(Request request) throws DisconnectedException {
        if (request == null) {
            throw new NullPointerException();
        }
        this.packetSendManager.sendPacket(request);
    }

    public void sendEvent(EventPacket event) throws DisconnectedException {
        if (event == null) {
            throw new NullPointerException();
        }
        this.packetSendManager.sendPacket(event);
    }

    public void sendResponse(Response response) throws DisconnectedException {
        if (response == null) {
            throw new NullPointerException();
        }
        this.packetSendManager.sendPacket(response);
    }

    public Response receiveResponse(int requestSequence, int timeout) throws TimeoutException, DisconnectedException {
        return this.packetReceiveManager.getResponse(requestSequence, timeout);
    }

    public EventPacket receiveEvent(int timeout) throws TimeoutException, DisconnectedException {
        return (EventPacket)this.packetReceiveManager.getCommand("event", timeout);
    }

    public Request receiveRequest(int timeout) throws TimeoutException, DisconnectedException {
        return (Request)this.packetReceiveManager.getCommand("request", timeout);
    }
}

