/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.transport;

import java.util.HashMap;
import java.util.Map;

public abstract class Packet {
    private static int currentSequence = 0;
    private final int sequence;
    private final String type;

    protected Packet(String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.sequence = Packet.nextSequence();
        this.type = type.intern();
    }

    protected Packet(Map json) {
        if (json == null) {
            throw new NullPointerException();
        }
        Number packetSeq = (Number)json.get("seq");
        this.sequence = packetSeq.intValue();
        String packetType = (String)json.get("type");
        this.type = packetType.intern();
    }

    private static synchronized int nextSequence() {
        return ++currentSequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getType() {
        return this.type;
    }

    public Map toJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("seq", new Integer(this.sequence));
        json.put("type", this.type);
        return json;
    }

    public static String getType(Map json) {
        if (json == null) {
            throw new NullPointerException();
        }
        return (String)json.get("type");
    }
}

