/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class Geometry {
    public static boolean linesIntersect(int ux, int uy, int vx, int vy, int sx, int sy, int tx, int ty) {
        long usX = (long)ux - (long)sx;
        long usY = (long)uy - (long)sy;
        long vsX = (long)vx - (long)sx;
        long vsY = (long)vy - (long)sy;
        long stX = (long)sx - (long)tx;
        long stY = (long)sy - (long)ty;
        if (Geometry.productSign(Geometry.cross(vsX, vsY, stX, stY), Geometry.cross(stX, stY, usX, usY)) >= 0) {
            long vuX = (long)vx - (long)ux;
            long vuY = (long)vy - (long)uy;
            long utX = (long)ux - (long)tx;
            long utY = (long)uy - (long)ty;
            return Geometry.productSign(Geometry.cross(-usX, -usY, vuX, vuY), Geometry.cross(vuX, vuY, utX, utY)) <= 0;
        }
        return false;
    }

    private static int productSign(long x, long y) {
        if (x == 0L || y == 0L) {
            return 0;
        }
        if (x < 0L ^ y < 0L) {
            return -1;
        }
        return 1;
    }

    private static long cross(long x1, long y1, long x2, long y2) {
        return x1 * y2 - x2 * y1;
    }

    public static boolean polylineContainsPoint(PointList points, int x, int y, int tolerance) {
        int[] coordinates = points.toIntArray();
        int index = 0;
        while (index < coordinates.length - 3) {
            if (Geometry.segmentContainsPoint(coordinates[index], coordinates[index + 1], coordinates[index + 2], coordinates[index + 3], x, y, tolerance)) {
                return true;
            }
            index += 2;
        }
        return false;
    }

    private static boolean segmentContainsPoint(int x1, int y1, int x2, int y2, int px, int py, int tolerance) {
        Rectangle lineBounds = Rectangle.SINGLETON;
        lineBounds.setSize(0, 0);
        lineBounds.setLocation(x1, y1);
        lineBounds.union(x2, y2);
        lineBounds.expand(tolerance, tolerance);
        if (!lineBounds.contains(px, py)) {
            return false;
        }
        if (x1 == x2 || y1 == y2) {
            return true;
        }
        int v2x = px - x1;
        int v1y = y2 - y1;
        int v1x = x2 - x1;
        int v2y = py - y1;
        int numerator = v2x * v1y - v1x * v2y;
        int denominator = v1x * v1x + v1y * v1y;
        int squareDistance = (int)((long)numerator * (long)numerator / (long)denominator);
        return squareDistance <= tolerance * tolerance;
    }

    public static boolean polygonContainsPoint(PointList points, int x, int y) {
        boolean isOdd = false;
        int[] coordinates = points.toIntArray();
        int n = coordinates.length;
        if (n > 3) {
            int x0 = coordinates[n - 2];
            int y0 = coordinates[n - 1];
            int i = 0;
            while (i < n) {
                int y1;
                int x1 = coordinates[i++];
                if (Geometry.segmentContaintPoint(y0, y1 = coordinates[i++], y)) {
                    int crossProduct = Geometry.crossProduct(x1, y1, x0, y0, x, y);
                    if (crossProduct == 0) {
                        if (Geometry.segmentContaintPoint(x0, x1, x)) {
                            return true;
                        }
                    } else if (y0 <= y && y < y1 && crossProduct > 0 || y1 <= y && y < y0 && crossProduct < 0) {
                        isOdd = !isOdd;
                    }
                }
                x0 = x1;
                y0 = y1;
            }
            return isOdd;
        }
        return false;
    }

    private static boolean segmentContaintPoint(int x0, int x1, int x) {
        return !(x < x0 && x < x1 || x > x0 && x > x1);
    }

    private static int crossProduct(int ax, int ay, int bx, int by, int cx, int cy) {
        return (ax - cx) * (by - cy) - (ay - cy) * (bx - cx);
    }
}

