/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Point;

public final class Ray {
    public int x;
    public int y;

    public Ray() {
    }

    public Ray(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Ray(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Ray(Point start, Point end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public Ray(Ray start, Ray end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public int assimilarity(Ray r) {
        return Math.abs(this.x * r.y - this.y * r.x);
    }

    public int dotProduct(Ray r) {
        return this.x * r.x + this.y * r.y;
    }

    long dotProductL(Ray r) {
        return (long)this.x * (long)r.x + (long)this.y * (long)r.y;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Ray) {
            Ray r = (Ray)obj;
            return this.x == r.x && this.y == r.y;
        }
        return false;
    }

    public Ray getAdded(Ray r) {
        return new Ray(r.x + this.x, r.y + this.y);
    }

    public Ray getSubtracted(Ray q) {
        return new Ray(this.x - q.x, this.y - q.y);
    }

    public double getAngle(Ray q) {
        double cosAlpha = (double)this.dotProduct(q) / (this.length() * q.length());
        return Math.acos(cosAlpha);
    }

    public Ray getAveraged(Ray r) {
        return new Ray((this.x + r.x) / 2, (this.y + r.y) / 2);
    }

    public Ray getScaled(int s) {
        return new Ray(this.x * s, this.y * s);
    }

    public Ray getOrthogonalComplement() {
        return new Ray(-this.y, this.x);
    }

    public int hashCode() {
        return this.x * this.y ^ this.x + this.y;
    }

    public boolean isHorizontal() {
        return this.x != 0;
    }

    public double length() {
        return Math.sqrt(this.dotProductL(this));
    }

    public int similarity(Ray r) {
        return Math.abs(this.dotProduct(r));
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Point toPoint() {
        return new Point(this.x, this.y);
    }
}

