/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.BasicVersion;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.generator.Activator;
import org.eclipse.equinox.internal.p2.metadata.generator.LocalizationHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteCategory;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.BundleDescriptionFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.FeatureEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.GeneratorBundleInfo;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class MetadataGeneratorHelper {
    public static final String NAMESPACE_ECLIPSE_TYPE = "org.eclipse.equinox.p2.eclipse.type";
    public static final String TYPE_ECLIPSE_BUNDLE = "bundle";
    public static final String TYPE_ECLIPSE_FEATURE = "feature";
    public static final String TYPE_ECLIPSE_SOURCE = "source";
    public static final String NAMESPACE_IU_LOCALIZATION = "org.eclipse.equinox.p2.localization";
    public static final String[] BUNDLE_LOCALIZED_PROPERTIES = new String[]{"Bundle-Name", "Bundle-Description", "Bundle-Vendor", "Bundle-ContactAddress", "Bundle-DocURL", "Bundle-UpdateLocation"};
    public static final int BUNDLE_LOCALIZATION_INDEX = BUNDLE_LOCALIZED_PROPERTIES.length;
    private static final String[] BUNDLE_IU_PROPERTY_MAP = new String[]{"Bundle-Name", "org.eclipse.equinox.p2.name", "Bundle-Description", "org.eclipse.equinox.p2.description", "Bundle-Vendor", "org.eclipse.equinox.p2.provider", "Bundle-ContactAddress", "org.eclipse.equinox.p2.contact", "Bundle-DocURL", "org.eclipse.equinox.p2.doc.url"};
    private static final String CAPABILITY_NS_JAVA_PACKAGE = "java.package";
    private static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    private static final String CAPABILITY_NS_OSGI_FRAGMENT = "osgi.fragment";
    private static final String CAPABILITY_NS_UPDATE_FEATURE = "org.eclipse.update.feature";
    private static final Version DEFAULT_JRE_VERSION = Version.create((String)"1.6");
    public static final String ECLIPSE_FEATURE_CLASSIFIER = "org.eclipse.update.feature";
    public static final String OSGI_BUNDLE_CLASSIFIER = "osgi.bundle";
    public static final String BINARY_ARTIFACT_CLASSIFIER = "binary";
    public static final IMatchExpression INSTALL_FEATURES_FILTER = InstallableUnit.parseFilter((String)"(org.eclipse.update.install.features=true)");
    private static final String IU_NAMESPACE = "org.eclipse.equinox.p2.iu";
    private static final String LAUNCHER_ID_PREFIX = "org.eclipse.launcher";
    private static final String ECLIPSE_INSTALL_HANDLER_PROP = "org.eclipse.update.installHandler";
    private static final String UPDATE_FEATURE_APPLICATION_PROP = "org.eclipse.update.feature.application";
    private static final String UPDATE_FEATURE_PLUGIN_PROP = "org.eclipse.update.feature.plugin";
    private static final String UPDATE_FEATURE_EXCLUSIVE_PROP = "org.eclipse.update.feature.exclusive";
    private static final String UPDATE_FEATURE_PRIMARY_PROP = "org.eclipse.update.feature.primary";
    private static final Version LAUNCHER_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
    public static final ITouchpointType TOUCHPOINT_NATIVE = MetadataFactory.createTouchpointType((String)"org.eclipse.equinox.p2.native", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    public static final ITouchpointType TOUCHPOINT_OSGI = MetadataFactory.createTouchpointType((String)"org.eclipse.equinox.p2.osgi", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    public static final IProvidedCapability BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    public static final IProvidedCapability FEATURE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"feature", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    public static final IProvidedCapability SOURCE_BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"source", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    static final String DEFAULT_BUNDLE_LOCALIZATION = "plugin";
    static final String BUNDLE_ADVICE_FILE = "META-INF/p2.inf";
    static final String ADVICE_INSTRUCTIONS_PREFIX = "instructions.";
    static final String NAMESPACE_FLAVOR = "org.eclipse.equinox.p2.flavor";
    static /* synthetic */ Class class$0;

    public static IArtifactDescriptor createArtifactDescriptor(IArtifactKey key, File pathOnDisk, boolean asIs, boolean recur) {
        String md5;
        ArtifactDescriptor result = new ArtifactDescriptor(key);
        if (pathOnDisk != null) {
            result.setProperty("artifact.size", Long.toString(pathOnDisk.length()));
            result.setProperty("download.size", Long.toString(pathOnDisk.length()));
        }
        if ((md5 = MetadataGeneratorHelper.computeMD5(pathOnDisk)) != null) {
            result.setProperty("download.md5", md5);
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private static String computeMD5(File file) {
        String string;
        InputStream fis;
        block21: {
            MessageDigest md5Checker;
            if (file == null || file.isDirectory() || !file.exists()) {
                return null;
            }
            try {
                md5Checker = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
            fis = null;
            fis = new BufferedInputStream(new FileInputStream(file));
            int read = -1;
            while ((read = fis.read()) != -1) {
                md5Checker.update((byte)read);
            }
            byte[] digest = md5Checker.digest();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < digest.length) {
                if ((digest[i] & 0xFF) < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(digest[i] & 0xFF));
                ++i;
            }
            string = buf.toString();
            if (fis == null) break block21;
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (FileNotFoundException fileNotFoundException) {
            block22: {
                if (fis == null) break block22;
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
        catch (IOException iOException) {
            block23: {
                if (fis == null) break block23;
                {
                    catch (Throwable throwable) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    fis.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    public static IArtifactDescriptor createPack200ArtifactDescriptor(IArtifactKey key, File pathOnDisk, String installSize) {
        ArtifactDescriptor result = new ArtifactDescriptor(key);
        if (pathOnDisk != null) {
            result.setProperty("artifact.size", installSize);
            result.setProperty("download.size", Long.toString(pathOnDisk.length()));
        }
        IProcessingStepDescriptor[] steps = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
        result.setProcessingSteps(steps);
        result.setProperty("format", "packed");
        return result;
    }

    public static IInstallableUnit createBundleConfigurationUnit(String iuId, Version iuVersion, boolean isBundleFragment, GeneratorBundleInfo configInfo, String configurationFlavor, String ldapFilter) {
        IMatchExpression filter = ldapFilter == null ? null : InstallableUnit.parseFilter((String)ldapFilter);
        return MetadataGeneratorHelper.createBundleConfigurationUnit(iuId, iuVersion, isBundleFragment, configInfo, configurationFlavor, filter);
    }

    public static IInstallableUnit createBundleConfigurationUnit(String iuId, Version iuVersion, boolean isBundleFragment, GeneratorBundleInfo configInfo, String configurationFlavor, IMatchExpression filter) {
        if (configInfo == null) {
            return null;
        }
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = String.valueOf(configurationFlavor) + iuId;
        cu.setId(configUnitId);
        cu.setVersion(iuVersion);
        cu.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)"osgi.bundle", (String)iuId, (VersionRange)new VersionRange(iuVersion, true, Version.MAX_VERSION, true), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)NAMESPACE_ECLIPSE_TYPE, (String)TYPE_ECLIPSE_BUNDLE, (VersionRange)new VersionRange(Version.createOSGi((int)1, (int)0, (int)0), true, Version.createOSGi((int)2, (int)0, (int)0), false), null, (boolean)false, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(configUnitId, iuVersion), MetadataFactory.createProvidedCapability((String)NAMESPACE_FLAVOR, (String)configurationFlavor, (Version)Version.createOSGi((int)1, (int)0, (int)0))});
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "uninstallBundle(bundle:${artifact})");
        touchpointData.put("configure", MetadataGeneratorHelper.createConfigScript(configInfo, isBundleFragment));
        touchpointData.put("unconfigure", MetadataGeneratorHelper.createUnconfigScript(configInfo, isBundleFragment));
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cu.setFilter(filter);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    public static IInstallableUnit createBundleIU(BundleDescription bd, Map manifest, boolean isFolderPlugin, IArtifactKey key, boolean useNestedAdvice) {
        Map manifestLocalizations = null;
        if (manifest != null && bd.getLocation() != null) {
            manifestLocalizations = MetadataGeneratorHelper.getManifestLocalizations(manifest, new File(bd.getLocation()));
        }
        return MetadataGeneratorHelper.createBundleIU(bd, manifest, isFolderPlugin, key, manifestLocalizations, useNestedAdvice);
    }

    private static VersionRange computeUpdateRange(org.osgi.framework.Version base) {
        VersionRange updateRange = null;
        updateRange = !base.equals((Object)org.osgi.framework.Version.emptyVersion) ? new VersionRange(Version.emptyVersion, true, MetadataGeneratorHelper.fromOSGiVersion(base), false) : VersionRange.emptyRange;
        return updateRange;
    }

    public static IInstallableUnit createBundleIU(BundleDescription bd, Map manifest, boolean isFolderPlugin, IArtifactKey key, Map manifestLocalizations, boolean useNestedAdvice) {
        boolean isBinaryBundle = true;
        if (manifest != null && manifest.containsKey("Eclipse-SourceBundle")) {
            isBinaryBundle = false;
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(bd.isSingleton());
        iu.setId(bd.getSymbolicName());
        iu.setVersion(MetadataGeneratorHelper.fromOSGiVersion(bd.getVersion()));
        iu.setFilter(bd.getPlatformFilter());
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)bd.getSymbolicName(), (VersionRange)MetadataGeneratorHelper.computeUpdateRange(bd.getVersion()), (int)0, null));
        boolean isFragment = bd.getHost() != null;
        BundleSpecification[] requiredBundles = bd.getRequiredBundles();
        ArrayList<IRequirement> reqsDeps = new ArrayList<IRequirement>();
        if (isFragment) {
            reqsDeps.add(MetadataFactory.createRequirement((String)"osgi.bundle", (String)bd.getHost().getName(), (VersionRange)MetadataGeneratorHelper.fromOSGiVersionRange(bd.getHost().getVersionRange()), null, (boolean)false, (boolean)false));
        }
        int j = 0;
        while (j < requiredBundles.length) {
            reqsDeps.add(MetadataFactory.createRequirement((String)"osgi.bundle", (String)requiredBundles[j].getName(), (VersionRange)MetadataGeneratorHelper.fromOSGiVersionRange(requiredBundles[j].getVersionRange()), null, (boolean)requiredBundles[j].isOptional(), (boolean)false));
            ++j;
        }
        ImportPackageSpecification[] osgiImports = bd.getImportPackages();
        int i = 0;
        while (i < osgiImports.length) {
            ImportPackageSpecification importSpec = osgiImports[i];
            String importPackageName = importSpec.getName();
            if (importPackageName.indexOf(42) == -1) {
                VersionRange versionRange = MetadataGeneratorHelper.fromOSGiVersionRange(importSpec.getVersionRange());
                reqsDeps.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_JAVA_PACKAGE, (String)importPackageName, (VersionRange)versionRange, null, (boolean)MetadataGeneratorHelper.isOptional(importSpec), (boolean)false));
            }
            ++i;
        }
        iu.setRequirements(reqsDeps.toArray(new IRequirement[reqsDeps.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(MetadataGeneratorHelper.createSelfCapability(bd.getSymbolicName(), MetadataGeneratorHelper.fromOSGiVersion(bd.getVersion())));
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"osgi.bundle", (String)bd.getSymbolicName(), (Version)MetadataGeneratorHelper.fromOSGiVersion(bd.getVersion())));
        ExportPackageDescription[] exports = bd.getExportPackages();
        int i2 = 0;
        while (i2 < exports.length) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_JAVA_PACKAGE, (String)exports[i2].getName(), (Version)MetadataGeneratorHelper.fromOSGiVersion(exports[i2].getVersion())));
            ++i2;
        }
        if (isBinaryBundle) {
            providedCapabilities.add(BUNDLE_CAPABILITY);
        } else {
            providedCapabilities.add(SOURCE_BUNDLE_CAPABILITY);
        }
        if (isFragment) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_OSGI_FRAGMENT, (String)bd.getHost().getName(), (Version)MetadataGeneratorHelper.fromOSGiVersion(bd.getVersion())));
        }
        if (manifestLocalizations != null) {
            Iterator iter = manifestLocalizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)manifestLocalizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(MetadataGeneratorHelper.makeTranslationCapability(bd.getSymbolicName(), locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        iu.setArtifacts(new IArtifactKey[]{key});
        iu.setTouchpointType(TOUCHPOINT_OSGI);
        if (manifest != null) {
            i = 0;
            while (i < BUNDLE_IU_PROPERTY_MAP.length) {
                String value;
                if (manifest.containsKey(BUNDLE_IU_PROPERTY_MAP[i]) && (value = (String)manifest.get(BUNDLE_IU_PROPERTY_MAP[i])) != null && value.length() > 0) {
                    iu.setProperty(BUNDLE_IU_PROPERTY_MAP[i + 1], value);
                }
                i += 2;
            }
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        if (isFolderPlugin) {
            touchpointData.put("zipped", "true");
        }
        touchpointData.put("manifest", MetadataGeneratorHelper.toManifestString(manifest));
        if (useNestedAdvice) {
            MetadataGeneratorHelper.mergeInstructionsAdvice(touchpointData, MetadataGeneratorHelper.getBundleAdvice(bd.getLocation(), BUNDLE_ADVICE_FILE));
        }
        iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    public static void mergeInstructionsAdvice(Map touchpointData, Map bundleAdvice) {
        if (touchpointData == null || bundleAdvice == null) {
            return;
        }
        Iterator iterator = bundleAdvice.keySet().iterator();
        while (iterator.hasNext()) {
            String instructions;
            String key = (String)iterator.next();
            if (!key.startsWith(ADVICE_INSTRUCTIONS_PREFIX)) continue;
            String phase = key.substring(ADVICE_INSTRUCTIONS_PREFIX.length());
            String string = instructions = touchpointData.containsKey(phase) ? (String)touchpointData.get(phase) : "";
            if (instructions.length() > 0) {
                instructions = String.valueOf(instructions) + ";";
            }
            instructions = String.valueOf(instructions) + ((String)bundleAdvice.get(key)).trim();
            touchpointData.put(phase, instructions);
        }
    }

    public static void createHostLocalizationFragment(IInstallableUnit bundleIU, BundleDescription bd, String hostId, String[] hostBundleManifestValues, Set localizationIUs) {
        Map hostLocalizations = MetadataGeneratorHelper.getHostLocalizations(new File(bd.getLocation()), hostBundleManifestValues);
        if (hostLocalizations != null) {
            IInstallableUnitFragment localizationFragment = MetadataGeneratorHelper.createLocalizationFragmentOfHost(bd, hostId, hostBundleManifestValues, hostLocalizations);
            localizationIUs.add(localizationFragment);
        }
    }

    private static IInstallableUnitFragment createLocalizationFragmentOfHost(BundleDescription bd, String hostId, String[] hostManifestValues, Map hostLocalizations) {
        MetadataFactory.InstallableUnitFragmentDescription fragment = new MetadataFactory.InstallableUnitFragmentDescription();
        String fragmentId = MetadataGeneratorHelper.makeHostLocalizationFragmentId(bd.getSymbolicName());
        fragment.setId(fragmentId);
        fragment.setVersion(MetadataGeneratorHelper.fromOSGiVersion(bd.getVersion()));
        HostSpecification hostSpec = bd.getHost();
        IRequirement[] hostReqs = new IRequirement[]{MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)hostSpec.getName(), (VersionRange)MetadataGeneratorHelper.fromOSGiVersionRange(hostSpec.getVersionRange()), null, (boolean)false, (boolean)false, (boolean)false)};
        fragment.setHost(hostReqs);
        fragment.setSingleton(true);
        fragment.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>(hostLocalizations.keySet().size());
        Iterator iter = hostLocalizations.keySet().iterator();
        while (iter.hasNext()) {
            Locale locale = (Locale)iter.next();
            Properties translatedStrings = (Properties)hostLocalizations.get(locale);
            Enumeration<?> propertyKeys = translatedStrings.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String nextKey = (String)propertyKeys.nextElement();
                fragment.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
            }
            providedCapabilities.add(MetadataGeneratorHelper.makeTranslationCapability(hostId, locale));
        }
        fragment.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        return MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)fragment);
    }

    private static String makeHostLocalizationFragmentId(String id) {
        return String.valueOf(id) + ".translated_host_properties";
    }

    private static IProvidedCapability makeTranslationCapability(String hostId, Locale locale) {
        return MetadataFactory.createProvidedCapability((String)NAMESPACE_IU_LOCALIZATION, (String)locale.toString(), (Version)Version.createOSGi((int)1, (int)0, (int)0));
    }

    public static IInstallableUnit createCategoryIU(SiteCategory category, Set featureIUs, IInstallableUnit parentCategory) {
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = category.getName();
        cat.setId(categoryId);
        cat.setVersion(Version.emptyVersion);
        cat.setProperty("org.eclipse.equinox.p2.name", category.getLabel());
        cat.setProperty("org.eclipse.equinox.p2.description", category.getDescription());
        ArrayList<IRequirement> reqsConfigurationUnits = new ArrayList<IRequirement>(featureIUs.size());
        Iterator iterator = featureIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)iu.getId(), (VersionRange)range, (IMatchExpression)(iu.getFilter() == null ? null : iu.getFilter()), (boolean)false, (boolean)false));
        }
        if (parentCategory != null) {
            reqsConfigurationUnits.add(MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)parentCategory.getId(), (VersionRange)VersionRange.emptyRange, (IMatchExpression)(parentCategory.getFilter() == null ? null : parentCategory.getFilter()), (boolean)false, (boolean)false));
        }
        cat.setRequirements(reqsConfigurationUnits.toArray(new IRequirement[reqsConfigurationUnits.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(MetadataGeneratorHelper.createSelfCapability(categoryId, Version.emptyVersion));
        Map localizations = category.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    cat.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(MetadataGeneratorHelper.makeTranslationCapability(categoryId, locale));
            }
        }
        cat.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }

    private static String createConfigScript(GeneratorBundleInfo configInfo, boolean isBundleFragment) {
        if (configInfo == null) {
            return "";
        }
        String configScript = "";
        if (!isBundleFragment && configInfo.getStartLevel() != -1) {
            configScript = String.valueOf(configScript) + "setStartLevel(startLevel:" + configInfo.getStartLevel() + ");";
        }
        if (!isBundleFragment && configInfo.isMarkedAsStarted()) {
            configScript = String.valueOf(configScript) + "markStarted(started: true);";
        }
        if (configInfo.getSpecialConfigCommands() != null) {
            configScript = String.valueOf(configScript) + configInfo.getSpecialConfigCommands();
        }
        return configScript;
    }

    private static String createDefaultBundleConfigScript(GeneratorBundleInfo configInfo) {
        return MetadataGeneratorHelper.createConfigScript(configInfo, false);
    }

    public static IInstallableUnit createDefaultBundleConfigurationUnit(GeneratorBundleInfo configInfo, GeneratorBundleInfo unconfigInfo, String configurationFlavor) {
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = MetadataGeneratorHelper.createDefaultConfigUnitId("osgi.bundle", configurationFlavor);
        cu.setId(configUnitId);
        Version configUnitVersion = Version.createOSGi((int)1, (int)0, (int)0);
        cu.setVersion(configUnitVersion);
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(configUnitId, configUnitVersion), MetadataFactory.createProvidedCapability((String)NAMESPACE_FLAVOR, (String)configurationFlavor, (Version)Version.createOSGi((int)1, (int)0, (int)0))});
        IRequirement[] reqs = new IRequirement[]{MetadataFactory.createRequirement((String)NAMESPACE_ECLIPSE_TYPE, (String)TYPE_ECLIPSE_BUNDLE, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true, (boolean)false)};
        cu.setHost(reqs);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "uninstallBundle(bundle:${artifact})");
        touchpointData.put("configure", MetadataGeneratorHelper.createDefaultBundleConfigScript(configInfo));
        touchpointData.put("unconfigure", MetadataGeneratorHelper.createDefaultBundleUnconfigScript(unconfigInfo));
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    private static String createDefaultBundleUnconfigScript(GeneratorBundleInfo unconfigInfo) {
        return MetadataGeneratorHelper.createUnconfigScript(unconfigInfo, false);
    }

    public static String createDefaultConfigUnitId(String classifier, String configurationFlavor) {
        return String.valueOf(configurationFlavor) + "." + classifier + ".default";
    }

    public static IInstallableUnit createDefaultFeatureConfigurationUnit(String configurationFlavor) {
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = MetadataGeneratorHelper.createDefaultConfigUnitId("org.eclipse.update.feature", configurationFlavor);
        cu.setId(configUnitId);
        Version configUnitVersion = Version.createOSGi((int)1, (int)0, (int)0);
        cu.setVersion(configUnitVersion);
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(configUnitId, configUnitVersion), MetadataFactory.createProvidedCapability((String)NAMESPACE_FLAVOR, (String)configurationFlavor, (Version)Version.createOSGi((int)1, (int)0, (int)0))});
        IRequirement[] reqs = new IRequirement[]{MetadataFactory.createRequirement((String)NAMESPACE_ECLIPSE_TYPE, (String)TYPE_ECLIPSE_FEATURE, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)true, (boolean)false)};
        cu.setHost(reqs);
        cu.setFilter(INSTALL_FEATURES_FILTER);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installFeature(feature:${artifact},featureId:default,featureVersion:default)");
        touchpointData.put("uninstall", "uninstallFeature(feature:${artifact},featureId:default,featureVersion:default)");
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    public static IInstallableUnit createDefaultConfigurationUnitForSourceBundles(String configurationFlavor) {
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = MetadataGeneratorHelper.createDefaultConfigUnitId(TYPE_ECLIPSE_SOURCE, configurationFlavor);
        cu.setId(configUnitId);
        Version configUnitVersion = Version.createOSGi((int)1, (int)0, (int)0);
        cu.setVersion(configUnitVersion);
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(configUnitId, configUnitVersion), MetadataFactory.createProvidedCapability((String)NAMESPACE_FLAVOR, (String)configurationFlavor, (Version)Version.createOSGi((int)1, (int)0, (int)0))});
        IRequirement[] reqs = new IRequirement[]{MetadataFactory.createRequirement((String)NAMESPACE_ECLIPSE_TYPE, (String)TYPE_ECLIPSE_SOURCE, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)true, (boolean)false)};
        cu.setHost(reqs);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "addSourceBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "removeSourceBundle(bundle:${artifact})");
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    public static IArtifactKey createFeatureArtifactKey(String fsn, String version) {
        return new ArtifactKey("org.eclipse.update.feature", fsn, Version.create((String)version));
    }

    public static IInstallableUnit createFeatureJarIU(Feature feature, boolean isExploded) {
        return MetadataGeneratorHelper.createFeatureJarIU(feature, isExploded, null);
    }

    public static IInstallableUnit createFeatureJarIU(Feature feature, boolean isExploded, Properties extraProperties) {
        Map localizations;
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        String id = MetadataGeneratorHelper.getTransformedId(feature.getId(), false, false);
        iu.setId(id);
        Version version = MetadataGeneratorHelper.fromOSGiVersion(new org.osgi.framework.Version(feature.getVersion()));
        iu.setVersion(version);
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)MetadataGeneratorHelper.computeUpdateRange(new org.osgi.framework.Version(feature.getVersion())), (int)0, null));
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        if (feature.getDescription() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description", feature.getDescription());
        }
        if (feature.getDescriptionURL() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description.url", feature.getDescriptionURL());
        }
        if (feature.getProviderName() != null) {
            iu.setProperty("org.eclipse.equinox.p2.provider", feature.getProviderName());
        }
        if (feature.getLicense() != null) {
            iu.setLicenses(new ILicense[]{MetadataFactory.createLicense((URI)MetadataGeneratorHelper.toURIOrNull(feature.getLicenseURL()), (String)feature.getLicense())});
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(MetadataFactory.createCopyright((URI)MetadataGeneratorHelper.toURIOrNull(feature.getCopyrightURL()), (String)feature.getCopyright()));
        }
        if (feature.getApplication() != null) {
            iu.setProperty(UPDATE_FEATURE_APPLICATION_PROP, feature.getApplication());
        }
        if (feature.getPlugin() != null) {
            iu.setProperty(UPDATE_FEATURE_PLUGIN_PROP, feature.getPlugin());
        }
        if (feature.isExclusive()) {
            iu.setProperty(UPDATE_FEATURE_EXCLUSIVE_PROP, Boolean.TRUE.toString());
        }
        if (feature.isPrimary()) {
            iu.setProperty(UPDATE_FEATURE_PRIMARY_PROP, Boolean.TRUE.toString());
        }
        iu.setTouchpointType(TOUCHPOINT_OSGI);
        iu.setFilter(INSTALL_FEATURES_FILTER);
        iu.setSingleton(true);
        if (feature.getInstallHandler() != null && feature.getInstallHandler().trim().length() > 0) {
            String installHandlerProperty = "handler=" + feature.getInstallHandler();
            if (feature.getInstallHandlerLibrary() != null) {
                installHandlerProperty = String.valueOf(installHandlerProperty) + ", library=" + feature.getInstallHandlerLibrary();
            }
            if (feature.getInstallHandlerURL() != null) {
                installHandlerProperty = String.valueOf(installHandlerProperty) + ", url=" + feature.getInstallHandlerURL();
            }
            iu.setProperty(ECLIPSE_INSTALL_HANDLER_PROP, installHandlerProperty);
        }
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(MetadataGeneratorHelper.createSelfCapability(id, version));
        providedCapabilities.add(FEATURE_CAPABILITY);
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.update.feature", (String)feature.getId(), (Version)version));
        iu.setArtifacts(new IArtifactKey[]{MetadataGeneratorHelper.createFeatureArtifactKey(feature.getId(), version.toString())});
        if (isExploded) {
            HashMap<String, String> touchpointData = new HashMap<String, String>();
            touchpointData.put("zipped", "true");
            iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        }
        if ((localizations = feature.getLocalizations()) != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(MetadataGeneratorHelper.makeTranslationCapability(id, locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        if (extraProperties != null) {
            Enumeration<?> e = extraProperties.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                iu.setProperty(name, extraProperties.getProperty(name));
            }
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    public static IInstallableUnit createGroupIU(Feature feature, IInstallableUnit featureIU) {
        return MetadataGeneratorHelper.createGroupIU(feature, featureIU, null, true);
    }

    public static IInstallableUnit createGroupIU(Feature feature, IInstallableUnit featureIU, Properties extraProperties, boolean transformIds) {
        if (MetadataGeneratorHelper.isPatch(feature)) {
            return MetadataGeneratorHelper.createPatchIU(feature, featureIU, extraProperties);
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        String id = feature.getId();
        if (transformIds) {
            id = MetadataGeneratorHelper.getTransformedId(id, false, true);
        }
        iu.setId(id);
        Version version = MetadataGeneratorHelper.fromOSGiVersion(new org.osgi.framework.Version(feature.getVersion()));
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        if (feature.getDescription() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description", feature.getDescription());
        }
        if (feature.getDescriptionURL() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description.url", feature.getDescriptionURL());
        }
        if (feature.getProviderName() != null) {
            iu.setProperty("org.eclipse.equinox.p2.provider", feature.getProviderName());
        }
        if (feature.getLicense() != null) {
            iu.setLicenses(new ILicense[]{MetadataFactory.createLicense((URI)MetadataGeneratorHelper.toURIOrNull(feature.getLicenseURL()), (String)feature.getLicense())});
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(MetadataFactory.createCopyright((URI)MetadataGeneratorHelper.toURIOrNull(feature.getCopyrightURL()), (String)feature.getCopyright()));
        }
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)MetadataGeneratorHelper.computeUpdateRange(new org.osgi.framework.Version(feature.getVersion())), (int)0, null));
        FeatureEntry[] entries = feature.getEntries();
        IRequirement[] required = new IRequirement[entries.length + (featureIU == null ? 0 : 1)];
        int i = 0;
        while (i < entries.length) {
            VersionRange range = MetadataGeneratorHelper.getVersionRange(entries[i]);
            String requiredId = entries[i].getId();
            if (transformIds) {
                requiredId = MetadataGeneratorHelper.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true);
            }
            required[i] = MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)requiredId, (VersionRange)range, (IMatchExpression)MetadataGeneratorHelper.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false);
            ++i;
        }
        if (featureIU != null) {
            required[entries.length] = MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)featureIU.getId(), (VersionRange)new VersionRange(featureIU.getVersion(), true, featureIU.getVersion(), true), (IMatchExpression)INSTALL_FEATURES_FILTER, (boolean)false, (boolean)false);
        }
        iu.setRequirements(required);
        iu.setTouchpointType(ITouchpointType.NONE);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(MetadataGeneratorHelper.createSelfCapability(id, version));
        Map localizations = feature.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(MetadataGeneratorHelper.makeTranslationCapability(id, locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        if (extraProperties != null) {
            Enumeration<?> e = extraProperties.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                iu.setProperty(name, extraProperties.getProperty(name));
            }
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    public static IInstallableUnit createPatchIU(Feature feature, IInstallableUnit featureIU, Properties extraProperties) {
        MetadataFactory.InstallableUnitPatchDescription iu = new MetadataFactory.InstallableUnitPatchDescription();
        String id = MetadataGeneratorHelper.getTransformedId(feature.getId(), false, true);
        iu.setId(id);
        Version version = MetadataGeneratorHelper.fromOSGiVersion(new org.osgi.framework.Version(feature.getVersion()));
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        if (feature.getDescription() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description", feature.getDescription());
        }
        if (feature.getDescriptionURL() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description.url", feature.getDescriptionURL());
        }
        if (feature.getProviderName() != null) {
            iu.setProperty("org.eclipse.equinox.p2.provider", feature.getProviderName());
        }
        if (feature.getLicense() != null) {
            iu.setLicenses(new ILicense[]{MetadataFactory.createLicense((URI)MetadataGeneratorHelper.toURIOrNull(feature.getLicenseURL()), (String)feature.getLicense())});
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(MetadataFactory.createCopyright((URI)MetadataGeneratorHelper.toURIOrNull(feature.getCopyrightURL()), (String)feature.getCopyright()));
        }
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)MetadataGeneratorHelper.computeUpdateRange(new org.osgi.framework.Version(feature.getVersion())), (int)0, null));
        FeatureEntry[] entries = feature.getEntries();
        ArrayList<IRequirement> applicabilityScope = new ArrayList<IRequirement>();
        ArrayList<IRequirement> patchRequirements = new ArrayList<IRequirement>();
        ArrayList<IRequirementChange> requirementChanges = new ArrayList<IRequirementChange>();
        int i = 0;
        while (i < entries.length) {
            VersionRange range = MetadataGeneratorHelper.getVersionRange(entries[i]);
            IRequirement req = MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)MetadataGeneratorHelper.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true), (VersionRange)range, (IMatchExpression)MetadataGeneratorHelper.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false);
            if (entries[i].isRequires()) {
                applicabilityScope.add(req);
                if (applicabilityScope.size() == 1) {
                    iu.setLifeCycle(MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)MetadataGeneratorHelper.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true), (VersionRange)range, null, (boolean)false, (boolean)false, (boolean)false));
                }
            } else if (entries[i].isPlugin()) {
                IRequirement from = MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)MetadataGeneratorHelper.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true), (VersionRange)VersionRange.emptyRange, (IMatchExpression)MetadataGeneratorHelper.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false);
                requirementChanges.add(MetadataFactory.createRequirementChange((IRequirement)from, (IRequirement)req));
            } else {
                patchRequirements.add(req);
            }
            ++i;
        }
        patchRequirements.add(MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)featureIU.getId(), (VersionRange)new VersionRange(featureIU.getVersion(), true, featureIU.getVersion(), true), (IMatchExpression)INSTALL_FEATURES_FILTER, (boolean)false, (boolean)false));
        iu.setRequirements(patchRequirements.toArray(new IRequirement[patchRequirements.size()]));
        iu.setApplicabilityScope((IRequirement[][])new IRequirement[][]{applicabilityScope.toArray(new IRequirement[applicabilityScope.size()])});
        iu.setRequirementChanges(requirementChanges.toArray(new IRequirementChange[requirementChanges.size()]));
        iu.setTouchpointType(ITouchpointType.NONE);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        iu.setProperty("org.eclipse.equinox.p2.type.patch", Boolean.TRUE.toString());
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(MetadataGeneratorHelper.createSelfCapability(id, version));
        Map localizations = feature.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(MetadataGeneratorHelper.makeTranslationCapability(id, locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        if (extraProperties != null) {
            Enumeration<?> e = extraProperties.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                iu.setProperty(name, extraProperties.getProperty(name));
            }
        }
        return MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iu);
    }

    private static boolean isPatch(Feature feature) {
        FeatureEntry[] entries = feature.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IArtifactDescriptor createJREData(File jreLocation, Set resultantIUs) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(false);
        String id = "a.jre";
        Version version = DEFAULT_JRE_VERSION;
        iu.setId(id);
        iu.setVersion(version);
        iu.setTouchpointType(TOUCHPOINT_NATIVE);
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configId = "config." + id;
        cu.setId(configId);
        cu.setVersion(version);
        cu.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)id, (VersionRange)new VersionRange(version, true, Version.MAX_VERSION, true), null, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(configId, version)});
        cu.setTouchpointType(TOUCHPOINT_NATIVE);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        if (jreLocation == null || !jreLocation.exists()) {
            iu.setVersion(version);
            iu.setCapabilities(MetadataGeneratorHelper.generateJRECapability(id, version, null));
            resultantIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu));
            touchpointData.put("install", "");
            cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
            resultantIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu));
            return null;
        }
        MetadataGeneratorHelper.generateJREIUData(iu, id, version, jreLocation);
        ArtifactKey key = new ArtifactKey(BINARY_ARTIFACT_CLASSIFIER, id, version);
        iu.setArtifacts(new IArtifactKey[]{key});
        resultantIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu));
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        resultantIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu));
        return MetadataGeneratorHelper.createArtifactDescriptor((IArtifactKey)key, jreLocation, false, true);
    }

    public static ArtifactKey createLauncherArtifactKey(String id, Version version) {
        return new ArtifactKey(BINARY_ARTIFACT_CLASSIFIER, id, version);
    }

    public static IArtifactDescriptor createLauncherIU(File launcher, String configurationFlavor, Set resultantIUs) {
        EnvironmentInfo info;
        if (launcher == null || !launcher.exists()) {
            return null;
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(true);
        String launcherId = "org.eclipse.launcher_" + launcher.getName();
        iu.setId(launcherId);
        iu.setVersion(LAUNCHER_VERSION);
        ArtifactKey key = MetadataGeneratorHelper.createLauncherArtifactKey(launcherId, LAUNCHER_VERSION);
        iu.setArtifacts(new IArtifactKey[]{key});
        iu.setCapabilities(new IProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(launcherId, LAUNCHER_VERSION)});
        iu.setTouchpointType(TOUCHPOINT_NATIVE);
        resultantIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu));
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = String.valueOf(configurationFlavor) + launcherId;
        cu.setId(configUnitId);
        cu.setVersion(LAUNCHER_VERSION);
        cu.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)IU_NAMESPACE, (String)launcherId, (VersionRange)new VersionRange(LAUNCHER_VERSION, true, Version.MAX_VERSION, true), null, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(configUnitId, LAUNCHER_VERSION)});
        cu.setTouchpointType(TOUCHPOINT_NATIVE);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).getOS().equals("win32")) {
            if (info.getOS().equals("macosx")) {
                configurationData = String.valueOf(configurationData) + " chmod(targetDir:${installFolder}/Eclipse.app/Contents/MacOS, targetFile:eclipse, permissions:755);";
                MetadataGeneratorHelper.generateLauncherSetter("Eclipse", launcherId, LAUNCHER_VERSION, "macosx", null, null, resultantIUs);
            } else {
                configurationData = String.valueOf(configurationData) + " chmod(targetDir:${installFolder}, targetFile:" + launcher.getName() + ", permissions:755);";
            }
        } else {
            MetadataGeneratorHelper.generateLauncherSetter("eclipse", launcherId, LAUNCHER_VERSION, "win32", null, null, resultantIUs);
        }
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        resultantIUs.add(MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)cu));
        return MetadataGeneratorHelper.createArtifactDescriptor((IArtifactKey)key, launcher, false, true);
    }

    public static IInstallableUnit generateLauncherSetter(String launcherName, String iuId, Version version, String os, String ws, String arch, Set result) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId(String.valueOf(iuId) + '.' + launcherName);
        iud.setVersion(version);
        iud.setTouchpointType(TOUCHPOINT_OSGI);
        iud.setCapabilities(new IProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(String.valueOf(iuId) + '.' + launcherName, version)});
        if (os != null || ws != null || arch != null) {
            String filterOs = os != null ? "(osgi.os=" + os + ")" : "";
            String filterWs = ws != null ? "(osgi.ws=" + ws + ")" : "";
            String filterArch = arch != null ? "(osgi.arch=" + arch + ")" : "";
            iud.setFilter("(& " + filterOs + filterWs + filterArch + ")");
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("configure", "setLauncherName(name:" + launcherName + ")");
        touchpointData.put("unconfigure", "setLauncherName()");
        iud.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
        result.add(iu);
        return iu;
    }

    public static IProvidedCapability createSelfCapability(String installableUnitId, Version installableUnitVersion) {
        return MetadataFactory.createProvidedCapability((String)IU_NAMESPACE, (String)installableUnitId, (Version)installableUnitVersion);
    }

    private static String createUnconfigScript(GeneratorBundleInfo unconfigInfo, boolean isBundleFragment) {
        if (unconfigInfo == null) {
            return "";
        }
        String unconfigScript = "";
        if (!isBundleFragment && unconfigInfo.getStartLevel() != -1) {
            unconfigScript = String.valueOf(unconfigScript) + "setStartLevel(startLevel:-1);";
        }
        if (!isBundleFragment && unconfigInfo.isMarkedAsStarted()) {
            unconfigScript = String.valueOf(unconfigScript) + "markStarted(started: false);";
        }
        if (unconfigInfo.getSpecialUnconfigCommands() != null) {
            unconfigScript = String.valueOf(unconfigScript) + unconfigInfo.getSpecialUnconfigCommands();
        }
        return unconfigScript;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IProvidedCapability[] generateJRECapability(String installableUnitId, Version installableUnitVersion, InputStream profileStream) {
        if (profileStream == null) {
            try {
                profileStream = Activator.getContext().getBundle().getEntry("JavaSE-1.6.profile").openStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Properties p = new Properties();
        p.load(profileStream);
        ManifestElement[] jrePackages = ManifestElement.parseHeader((String)"org.osgi.framework.system.packages", (String)((String)p.get("org.osgi.framework.system.packages")));
        IProvidedCapability[] exportedPackageAsCapabilities = new IProvidedCapability[jrePackages.length + 1];
        exportedPackageAsCapabilities[0] = MetadataGeneratorHelper.createSelfCapability(installableUnitId, installableUnitVersion);
        int i = 1;
        while (i <= jrePackages.length) {
            exportedPackageAsCapabilities[i] = MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_JAVA_PACKAGE, (String)jrePackages[i - 1].getValue(), null);
            ++i;
        }
        IProvidedCapability[] iProvidedCapabilityArray = exportedPackageAsCapabilities;
        if (profileStream == null) return iProvidedCapabilityArray;
        try {
            profileStream.close();
            return iProvidedCapabilityArray;
        }
        catch (IOException iOException) {}
        return iProvidedCapabilityArray;
        catch (IOException e) {
            e.printStackTrace();
            if (profileStream == null) return new IProvidedCapability[0];
            try {
                profileStream.close();
                return new IProvidedCapability[0];
            }
            catch (IOException iOException) {}
            return new IProvidedCapability[0];
        }
        catch (BundleException e2) {
            e2.printStackTrace();
            if (profileStream == null) return new IProvidedCapability[0];
            {
                catch (Throwable throwable) {
                    if (profileStream == null) throw throwable;
                    try {
                        profileStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                profileStream.close();
                return new IProvidedCapability[0];
            }
            catch (IOException iOException) {}
            return new IProvidedCapability[0];
        }
    }

    private static void generateJREIUData(MetadataFactory.InstallableUnitDescription iu, String installableUnitId, Version installableUnitVersion, File jreLocation) {
        File[] profiles = jreLocation.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".profile");
            }
        });
        if (profiles.length != 1) {
            iu.setVersion(DEFAULT_JRE_VERSION);
            iu.setCapabilities(MetadataGeneratorHelper.generateJRECapability(installableUnitId, installableUnitVersion, null));
            return;
        }
        String profileName = profiles[0].getAbsolutePath().substring(profiles[0].getAbsolutePath().lastIndexOf(47));
        Version version = DEFAULT_JRE_VERSION;
        if (profileName.indexOf("1.6") > 0) {
            version = Version.create((String)"1.6");
        } else if (profileName.indexOf("1.5") > 0) {
            version = Version.create((String)"1.5");
        } else if (profileName.indexOf("1.4") > 0) {
            version = Version.create((String)"1.4");
        }
        iu.setVersion(version);
        try {
            iu.setCapabilities(MetadataGeneratorHelper.generateJRECapability(installableUnitId, installableUnitVersion, new FileInputStream(profiles[0])));
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static IMatchExpression getFilter(FeatureEntry entry) {
        StringBuffer result = new StringBuffer();
        result.append("(&");
        if (entry.getFilter() != null) {
            result.append(entry.getFilter());
        }
        if (entry.getOS() != null) {
            result.append("(osgi.os=" + entry.getOS() + ')');
        }
        if (entry.getWS() != null) {
            result.append("(osgi.ws=" + entry.getWS() + ')');
        }
        if (entry.getArch() != null) {
            result.append("(osgi.arch=" + entry.getArch() + ')');
        }
        if (entry.getNL() != null) {
            result.append("(osgi.nl=" + entry.getNL() + ')');
        }
        if (result.length() == 2) {
            return null;
        }
        result.append(')');
        return InstallableUnit.parseFilter((String)result.toString());
    }

    public static String getTransformedId(String original, boolean isPlugin, boolean isGroup) {
        return isPlugin ? original : String.valueOf(original) + (isGroup ? ".feature.group" : ".feature.jar");
    }

    public static VersionRange getVersionRange(FeatureEntry entry) {
        String versionSpec = entry.getVersion();
        if (versionSpec == null) {
            return VersionRange.emptyRange;
        }
        Version version = Version.create((String)versionSpec);
        if (version.equals(Version.emptyVersion)) {
            return VersionRange.emptyRange;
        }
        if (!entry.isRequires()) {
            return new VersionRange(version, true, version, true);
        }
        String match = entry.getMatch();
        org.osgi.framework.Version osgiVersion = MetadataGeneratorHelper.toOSGiVersion(version);
        if (match == null || match.equals("compatible")) {
            Version upper = Version.createOSGi((int)(osgiVersion.getMajor() + 1), (int)0, (int)0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("perfect")) {
            return new VersionRange(version, true, version, true);
        }
        if (match.equals("equivalent")) {
            Version upper = Version.createOSGi((int)osgiVersion.getMajor(), (int)(osgiVersion.getMinor() + 1), (int)0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("greaterOrEqual")) {
            return new VersionRange(version, true, new VersionRange(null).getMaximum(), true);
        }
        return null;
    }

    public static Map getBundleAdvice(String bundleLocation, String suffixLocation) {
        if (bundleLocation == null) {
            return Collections.EMPTY_MAP;
        }
        File bundle = new File(bundleLocation);
        if (!bundle.exists()) {
            return Collections.EMPTY_MAP;
        }
        ZipFile jar = null;
        InputStream stream = null;
        if (bundle.isDirectory()) {
            File adviceFile = new File(bundle, suffixLocation);
            if (adviceFile.exists()) {
                try {
                    stream = new BufferedInputStream(new FileInputStream(adviceFile));
                }
                catch (IOException iOException) {
                    return Collections.EMPTY_MAP;
                }
            }
        } else if (bundle.isFile()) {
            try {
                jar = new ZipFile(bundle);
                ZipEntry entry = jar.getEntry(suffixLocation);
                if (entry != null) {
                    stream = new BufferedInputStream(jar.getInputStream(entry));
                }
            }
            catch (IOException iOException) {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException2) {}
                }
                return Collections.EMPTY_MAP;
            }
        }
        Map advice = null;
        if (stream != null) {
            try {
                try {
                    advice = new Properties();
                    ((Properties)advice).load(stream);
                }
                catch (IOException iOException) {
                    Map map = Collections.EMPTY_MAP;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException3) {}
                    return map;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException iOException) {}
        }
        return advice != null ? advice : Collections.EMPTY_MAP;
    }

    private static boolean isOptional(ImportPackageSpecification importedPackage) {
        return importedPackage.getDirective("resolution").equals("dynamic") || importedPackage.getDirective("resolution").equals("optional");
    }

    private static String toManifestString(Map p) {
        if (p == null) {
            return null;
        }
        Set properties = p.entrySet();
        StringBuffer result = new StringBuffer();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Map.Entry aProperty = (Map.Entry)iterator.next();
            if (aProperty.getKey().equals(BundleDescriptionFactory.BUNDLE_FILE_KEY)) continue;
            result.append(aProperty.getKey()).append(": ").append(aProperty.getValue()).append('\n');
        }
        return result.toString();
    }

    private static URI toURIOrNull(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URIUtil.fromString((String)url);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private static Map getManifestLocalizations(Map manifest, File bundleLocation) {
        Locale defaultLocale = null;
        String[] bundleManifestValues = MetadataGeneratorHelper.getManifestCachedValues(manifest);
        String bundleLocalization = bundleManifestValues[BUNDLE_LOCALIZATION_INDEX];
        Map localizations = "jar".equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile() ? LocalizationHelper.getJarPropertyLocalizations(bundleLocation, bundleLocalization, defaultLocale, bundleManifestValues) : LocalizationHelper.getDirPropertyLocalizations(bundleLocation, bundleLocalization, defaultLocale, bundleManifestValues);
        return localizations;
    }

    public static String[] getManifestCachedValues(Map manifest) {
        String[] cachedValues = new String[BUNDLE_LOCALIZED_PROPERTIES.length + 1];
        int j = 0;
        while (j < BUNDLE_LOCALIZED_PROPERTIES.length) {
            String value = (String)manifest.get(BUNDLE_LOCALIZED_PROPERTIES[j]);
            if (value != null && value.length() > 1 && value.charAt(0) == '%') {
                cachedValues[j] = value.substring(1);
            }
            ++j;
        }
        String localizationFile = (String)manifest.get("Bundle-Localization");
        cachedValues[MetadataGeneratorHelper.BUNDLE_LOCALIZATION_INDEX] = localizationFile != null ? localizationFile : DEFAULT_BUNDLE_LOCALIZATION;
        return cachedValues;
    }

    public static Map getHostLocalizations(File bundleLocation, String[] hostBundleManifestValues) {
        Locale defaultLocale = null;
        String hostBundleLocalization = hostBundleManifestValues[BUNDLE_LOCALIZATION_INDEX];
        Map localizations = "jar".equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile() ? LocalizationHelper.getJarPropertyLocalizations(bundleLocation, hostBundleLocalization, defaultLocale, hostBundleManifestValues) : LocalizationHelper.getDirPropertyLocalizations(bundleLocation, hostBundleLocalization, defaultLocale, hostBundleManifestValues);
        return localizations;
    }

    public static org.osgi.framework.Version toOSGiVersion(Version version) {
        if (version == null) {
            return null;
        }
        if (version == Version.emptyVersion) {
            return org.osgi.framework.Version.emptyVersion;
        }
        if (version == Version.MAX_VERSION) {
            return new org.osgi.framework.Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        BasicVersion bv = (BasicVersion)version;
        return new org.osgi.framework.Version(bv.getMajor(), bv.getMinor(), bv.getMicro(), bv.getQualifier());
    }

    public static Version fromOSGiVersion(org.osgi.framework.Version version) {
        if (version == null) {
            return null;
        }
        if (version.getMajor() == Integer.MAX_VALUE && version.getMicro() == Integer.MAX_VALUE && version.getMicro() == Integer.MAX_VALUE) {
            return Version.MAX_VERSION;
        }
        return Version.createOSGi((int)version.getMajor(), (int)version.getMinor(), (int)version.getMicro(), (String)version.getQualifier());
    }

    public static org.eclipse.osgi.service.resolver.VersionRange toOSGiVersionRange(VersionRange range) {
        if (range.equals((Object)VersionRange.emptyRange)) {
            return org.eclipse.osgi.service.resolver.VersionRange.emptyRange;
        }
        return new org.eclipse.osgi.service.resolver.VersionRange(MetadataGeneratorHelper.toOSGiVersion(range.getMinimum()), range.getIncludeMinimum(), MetadataGeneratorHelper.toOSGiVersion(range.getMaximum()), range.getIncludeMinimum());
    }

    public static VersionRange fromOSGiVersionRange(org.eclipse.osgi.service.resolver.VersionRange range) {
        if (range.equals((Object)org.eclipse.osgi.service.resolver.VersionRange.emptyRange)) {
            return VersionRange.emptyRange;
        }
        return new VersionRange(MetadataGeneratorHelper.fromOSGiVersion(range.getMinimum()), range.getIncludeMinimum(), MetadataGeneratorHelper.fromOSGiVersion(range.getMaximum()), range.getIncludeMaximum());
    }
}

