/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvisioningContext {
    private IProvisioningAgent agent;
    private URI[] artifactRepositories;
    private final List<IInstallableUnit> extraIUs = Collections.synchronizedList(new ArrayList());
    private URI[] metadataRepositories;
    private final Map<String, String> properties = new HashMap<String, String>();
    private Map<String, IRepositoryReference> metadataRepositorySnapshot = null;
    private Map<String, IRepositoryReference> artifactRepositorySnapshot = null;
    private Map<String, IArtifactRepository> referencedArtifactRepositories = null;
    private static final String FILE_PROTOCOL = "file";
    private static final Comparator<URI> LOCAL_FIRST_COMPARATOR = new Comparator<URI>(){

        @Override
        public int compare(URI arg0, URI arg1) {
            String protocol0 = arg0.getScheme();
            String protocol1 = arg1.getScheme();
            if (ProvisioningContext.FILE_PROTOCOL.equals(protocol0) && !ProvisioningContext.FILE_PROTOCOL.equals(protocol1)) {
                return -1;
            }
            if (!ProvisioningContext.FILE_PROTOCOL.equals(protocol0) && ProvisioningContext.FILE_PROTOCOL.equals(protocol1)) {
                return 1;
            }
            return 0;
        }
    };
    public static final String FOLLOW_REPOSITORY_REFERENCES = "org.eclipse.equinox.p2.director.followRepositoryReferences";

    public ProvisioningContext(IProvisioningAgent agent) {
        this.agent = agent;
        this.metadataRepositories = null;
        this.artifactRepositories = null;
    }

    public IQueryable<IArtifactKey> getArtifactKeys(IProgressMonitor monitor) {
        return QueryUtil.compoundQueryable(this.getLoadedArtifactRepositories(monitor));
    }

    public IQueryable<IArtifactDescriptor> getArtifactDescriptors(IProgressMonitor monitor) {
        List<IArtifactRepository> repos = this.getLoadedArtifactRepositories(monitor);
        ArrayList<IQueryable> descriptorQueryables = new ArrayList<IQueryable>();
        for (IArtifactRepository repo : repos) {
            descriptorQueryables.add(repo.descriptorQueryable());
        }
        return QueryUtil.compoundQueryable(descriptorQueryables);
    }

    public IQueryable<IArtifactRepository> getArtifactRepositories(IProgressMonitor monitor) {
        return new ArtifactRepositoryQueryable(this.getLoadedArtifactRepositories(monitor));
    }

    private List<IArtifactRepository> getLoadedArtifactRepositories(IProgressMonitor monitor) {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        URI[] repositories = this.artifactRepositories == null ? repoManager.getKnownRepositories(0) : this.artifactRepositories;
        Arrays.sort(repositories, LOCAL_FIRST_COMPARATOR);
        ArrayList<IArtifactRepository> repos = new ArrayList<IArtifactRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 100));
        int i = 0;
        while (i < repositories.length) {
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                repos.add(repoManager.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100)));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        if (this.referencedArtifactRepositories != null) {
            for (IArtifactRepository repo : this.referencedArtifactRepositories.values()) {
                repos.add(repo);
            }
        }
        return repos;
    }

    private Set<IMetadataRepository> getLoadedMetadataRepositories(IProgressMonitor monitor) {
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        URI[] repositories = this.metadataRepositories == null ? repoManager.getKnownRepositories(0) : this.metadataRepositories;
        HashSet<IMetadataRepository> repos = new HashSet<IMetadataRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 100 + 100));
        int i = 0;
        while (i < repositories.length) {
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                repos.add(repoManager.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100)));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        if (!this.shouldFollowReferences()) {
            sub.done();
            return repos;
        }
        sub = SubMonitor.convert((IProgressMonitor)sub.newChild(100), (int)(100 * repositories.length));
        this.snapShotRepositoryState();
        this.referencedArtifactRepositories = new HashMap<String, IArtifactRepository>();
        i = 0;
        while (i < repositories.length) {
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.loadMetadataRepository(repoManager, repositories[i], repos, this.shouldFollowReferences(), (IProgressMonitor)sub.newChild(100));
            ++i;
        }
        this.restoreRepositoryState();
        return repos;
    }

    private void snapShotRepositoryState() {
        this.metadataRepositorySnapshot = new HashMap<String, IRepositoryReference>();
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        ArrayList<URI> all = new ArrayList<URI>();
        all.addAll(Arrays.asList(manager.getKnownRepositories(0)));
        all.addAll(Arrays.asList(manager.getKnownRepositories(8)));
        for (URI location : all) {
            int options = manager.isEnabled(location) ? 1 : 0;
            this.metadataRepositorySnapshot.put(location.toString(), (IRepositoryReference)new RepositoryReference(location, manager.getRepositoryProperty(location, "p2.nickname"), 0, options));
        }
        this.artifactRepositorySnapshot = new HashMap<String, IRepositoryReference>();
        IArtifactRepositoryManager artManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        all = new ArrayList();
        all.addAll(Arrays.asList(artManager.getKnownRepositories(0)));
        all.addAll(Arrays.asList(artManager.getKnownRepositories(8)));
        for (URI location : all) {
            int options = artManager.isEnabled(location) ? 1 : 0;
            this.artifactRepositorySnapshot.put(location.toString(), (IRepositoryReference)new RepositoryReference(location, artManager.getRepositoryProperty(location, "p2.nickname"), 1, options));
        }
    }

    private void restoreRepositoryState() {
        IRepositoryReference reference;
        ArrayList<URI> all;
        IMetadataRepositoryManager manager;
        if (this.metadataRepositorySnapshot != null) {
            manager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            all = new ArrayList<URI>();
            all.addAll(Arrays.asList(manager.getKnownRepositories(0)));
            all.addAll(Arrays.asList(manager.getKnownRepositories(8)));
            for (URI location : all) {
                reference = this.metadataRepositorySnapshot.get(location.toString());
                if (reference == null) {
                    manager.removeRepository(location);
                    continue;
                }
                manager.setEnabled(location, (reference.getOptions() & 1) == 1);
                manager.setRepositoryProperty(location, "p2.nickname", reference.getNickname());
                this.metadataRepositorySnapshot.remove(location);
            }
            for (IRepositoryReference ref : this.metadataRepositorySnapshot.values()) {
                manager.addRepository(ref.getLocation());
                manager.setEnabled(ref.getLocation(), (ref.getOptions() & 1) == 1);
                manager.setRepositoryProperty(ref.getLocation(), "p2.nickname", ref.getNickname());
            }
            this.metadataRepositorySnapshot = null;
        }
        if (this.artifactRepositorySnapshot != null) {
            manager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            all = new ArrayList();
            all.addAll(Arrays.asList(manager.getKnownRepositories(0)));
            all.addAll(Arrays.asList(manager.getKnownRepositories(8)));
            for (URI location : all) {
                reference = this.artifactRepositorySnapshot.get(location.toString());
                if (reference == null) {
                    manager.removeRepository(location);
                    continue;
                }
                manager.setEnabled(location, (reference.getOptions() & 1) == 1);
                manager.setRepositoryProperty(location, "p2.nickname", reference.getNickname());
                this.artifactRepositorySnapshot.remove(location);
            }
            for (IRepositoryReference ref : this.artifactRepositorySnapshot.values()) {
                manager.addRepository(ref.getLocation());
                manager.setEnabled(ref.getLocation(), (ref.getOptions() & 1) == 1);
                manager.setRepositoryProperty(ref.getLocation(), "p2.nickname", ref.getNickname());
            }
            this.artifactRepositorySnapshot = null;
        }
    }

    private void loadMetadataRepository(IMetadataRepositoryManager manager, URI location, Set<IMetadataRepository> repos, boolean followReferences, IProgressMonitor monitor) {
        try {
            if (!followReferences) {
                repos.add(manager.loadRepository(location, monitor));
                return;
            }
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
            IMetadataRepository repository = manager.loadRepository(location, (IProgressMonitor)sub.newChild(500));
            repos.add(repository);
            Collection references = repository.getReferences();
            if (references.size() > 0) {
                IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
                SubMonitor repoSubMon = SubMonitor.convert((IProgressMonitor)sub.newChild(500), (int)(100 * references.size()));
                for (IRepositoryReference ref : references) {
                    if (ref.getType() == 0) {
                        this.loadMetadataRepository(manager, ref.getLocation(), repos, followReferences, (IProgressMonitor)repoSubMon.newChild(100));
                        continue;
                    }
                    this.referencedArtifactRepositories.put(ref.getLocation().toString(), artifactManager.loadRepository(ref.getLocation(), (IProgressMonitor)repoSubMon.newChild(100)));
                }
            } else {
                sub.done();
            }
        }
        catch (ProvisionException provisionException) {}
    }

    private boolean shouldFollowReferences() {
        return Boolean.valueOf(this.getProperty(FOLLOW_REPOSITORY_REFERENCES));
    }

    public IQueryable<IInstallableUnit> getMetadata(IProgressMonitor monitor) {
        return QueryUtil.compoundQueryable(this.getLoadedMetadataRepositories(monitor));
    }

    public List<IInstallableUnit> getExtraInstallableUnits() {
        return this.extraIUs;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setArtifactRepositories(URI[] artifactRepositories) {
        this.artifactRepositories = artifactRepositories;
    }

    public void setMetadataRepositories(URI[] metadataRepositories) {
        this.metadataRepositories = metadataRepositories;
    }

    public void setExtraInstallableUnits(List<IInstallableUnit> extraIUs) {
        this.extraIUs.clear();
        if (extraIUs != null) {
            this.extraIUs.addAll(extraIUs);
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new StringBuffer("{artifactRepos=").append(DebugHelper.formatArray(this.artifactRepositories != null ? Arrays.asList(this.artifactRepositories) : null, true, false)).toString());
        buffer.append(new StringBuffer(", metadataRepos=").append(DebugHelper.formatArray(this.metadataRepositories != null ? Arrays.asList(this.metadataRepositories) : null, true, false)).toString());
        buffer.append(new StringBuffer(", properties=").append(this.getProperties()).append("}").toString());
        return buffer.toString();
    }

    public URI[] getArtifactRepositories() {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        URI[] repositories = this.artifactRepositories == null ? repoManager.getKnownRepositories(0) : this.artifactRepositories;
        Arrays.sort(repositories, LOCAL_FIRST_COMPARATOR);
        return repositories;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArtifactRepositoryQueryable
    implements IQueryable<IArtifactRepository> {
        List<IArtifactRepository> repositories;

        ArtifactRepositoryQueryable(List<IArtifactRepository> repositories) {
            this.repositories = repositories;
        }

        public IQueryResult<IArtifactRepository> query(IQuery<IArtifactRepository> query, IProgressMonitor mon) {
            return query.perform(this.repositories.listIterator());
        }
    }
}

