/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SemanticLightweightDecorator
implements ILightweightLabelDecorator {
    private static final ImageDescriptor EDIT_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.resources.semantic", (String)"$nl$/icons/edit.gif");
    private static final ImageDescriptor LOCAL_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.resources.semantic", (String)"$nl$/icons/local.gif");
    private static final ImageDescriptor LOCKED_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.resources.semantic", (String)"$nl$/icons/lock.gif");
    private ListenerList listeners = new ListenerList();

    public void decorate(Object element, IDecoration decoration) {
        ISemanticResource sresource;
        if (element instanceof IResource && (sresource = (ISemanticResource)((IResource)element).getAdapter(ISemanticResource.class)) != null && sresource instanceof ISemanticFile) {
            try {
                int options = 26;
                ISemanticResourceInfo attrs = sresource.fetchResourceInfo(options, null);
                if (attrs.isLocalOnly()) {
                    decoration.addOverlay(LOCAL_IMAGE, 3);
                } else if (attrs.isLocked()) {
                    decoration.addOverlay(LOCKED_IMAGE, 3);
                } else if (!attrs.isReadOnly()) {
                    decoration.addOverlay(EDIT_IMAGE, 3);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }
}

