/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.site.PluginPathFinder;
import org.eclipse.pde.internal.core.P2Utils;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;

public class ProfileBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "Profile";
    private String fHome;
    private String fConfiguration;

    public ProfileBundleContainer(String home, String configurationLocation) {
        this.fHome = home;
        this.fConfiguration = configurationLocation;
    }

    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.resolveHomeLocation().toOSString();
        }
        return this.fHome;
    }

    public String getType() {
        return TYPE;
    }

    public String getConfigurationLocation() {
        return this.fConfiguration;
    }

    protected IResolvedBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        String home = this.resolveHomeLocation().toOSString();
        if (!new File(home).isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_0, (Object)home)));
        }
        URL configUrl = this.getConfigurationArea();
        if (configUrl != null && !new File(configUrl.getFile()).isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_2, (Object)home)));
        }
        BundleInfo[] infos = P2Utils.readBundles(home, configUrl);
        if (infos == null) {
            IResolvedBundle[] platformXML = this.resolvePlatformXML(definition, home, monitor);
            if (platformXML != null) {
                return platformXML;
            }
            infos = new BundleInfo[]{};
        }
        if (monitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        BundleInfo[] source = P2Utils.readSourceBundles(home, configUrl);
        if (source == null) {
            source = new BundleInfo[]{};
        }
        IResolvedBundle[] all = new IResolvedBundle[infos.length + source.length];
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)all.length);
        int i = 0;
        while (i < infos.length) {
            if (monitor.isCanceled()) {
                return new IResolvedBundle[0];
            }
            BundleInfo info = infos[i];
            all[i] = this.resolveBundle(info, false);
            localMonitor.worked(1);
            ++i;
        }
        int index = 0;
        int i2 = infos.length;
        while (i2 < all.length) {
            if (monitor.isCanceled()) {
                return new IResolvedBundle[0];
            }
            BundleInfo info = source[index];
            all[i2] = this.resolveBundle(info, true);
            ++index;
            localMonitor.worked(1);
            ++i2;
        }
        localMonitor.done();
        return all;
    }

    protected IFeatureModel[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        if (definition instanceof TargetDefinition) {
            return ((TargetDefinition)definition).getFeatureModels(this.getLocation(false), monitor);
        }
        return new IFeatureModel[0];
    }

    protected IResolvedBundle[] resolvePlatformXML(ITargetDefinition definition, String home, IProgressMonitor monitor) throws CoreException {
        File[] files = PluginPathFinder.getPaths((String)home, (boolean)false, (boolean)false);
        if (files.length > 0) {
            ArrayList<IResolvedBundle> all = new ArrayList<IResolvedBundle>(files.length);
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)files.length);
            int i = 0;
            while (i < files.length) {
                if (localMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    IResolvedBundle rb = this.generateBundle(files[i]);
                    if (rb != null) {
                        all.add(rb);
                    }
                }
                catch (CoreException coreException) {}
                localMonitor.worked(1);
                ++i;
            }
            localMonitor.done();
            if (!all.isEmpty()) {
                return all.toArray(new IResolvedBundle[all.size()]);
            }
        }
        return null;
    }

    private IPath resolveHomeLocation() throws CoreException {
        return new Path(this.resolveVariables(this.fHome));
    }

    private URL getConfigurationArea() throws CoreException {
        IPath home = this.resolveHomeLocation();
        Object configuration = null;
        configuration = this.fConfiguration == null ? home.append("configuration") : new Path(this.resolveVariables(this.fConfiguration));
        File file = configuration.toFile();
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_1, (Object)home.toOSString()), (Throwable)e));
            }
        }
        if (this.fConfiguration != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_2, (Object)configuration.toOSString())));
        }
        return null;
    }

    public boolean isContentEqual(AbstractBundleContainer container) {
        if (container instanceof ProfileBundleContainer) {
            ProfileBundleContainer pbc = (ProfileBundleContainer)container;
            return this.fHome.equals(pbc.fHome) && this.isNullOrEqual(this.fConfiguration, this.fConfiguration);
        }
        return false;
    }

    private boolean isNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public String toString() {
        return "Installation " + this.fHome + ' ' + (this.fConfiguration == null ? "Default Configuration" : this.fConfiguration);
    }
}

