/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.actions.ResourceActionDelegate;

public class FormatActionDelegate
extends ResourceActionDelegate {
    private MultiStatus fErrorStatus = new MultiStatus("org.eclipse.wst.sse.ui", 4, SSEUIMessages.FormatActionDelegate_errorStatusMessage, null);

    protected void format(IProgressMonitor monitor, IFile file) {
        if (monitor == null || monitor.isCanceled()) {
            return;
        }
        try {
            IContentType contentType;
            IStructuredFormatProcessor formatProcessor;
            monitor.beginTask("", 100);
            IContentDescription contentDescription = file.getContentDescription();
            monitor.worked(5);
            if (contentDescription != null && (formatProcessor = this.getFormatProcessor((contentType = contentDescription.getContentType()).getId())) != null && !monitor.isCanceled()) {
                String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_3, (Object[])new String[]{file.getFullPath().toString().substring(1)});
                monitor.subTask(message);
                formatProcessor.setProgressMonitor(monitor);
                formatProcessor.formatFile(file);
            }
            monitor.worked(95);
            monitor.done();
        }
        catch (MalformedInputExceptionWithDetail e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_5, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
    }

    private Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected void format(IProgressMonitor monitor, IResource resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 150->156)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IStructuredFormatProcessor getFormatProcessor(String contentTypeId) {
        return FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentTypeId);
    }

    protected Job getJob() {
        return new FormatJob(SSEUIMessages.FormatActionDelegate_jobName);
    }

    protected void process(IProgressMonitor monitor, IResource resource) {
        monitor.beginTask("", 100);
        this.format((IProgressMonitor)new SubProgressMonitor(monitor, 98), resource);
        try {
            resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{resource.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        monitor.done();
    }

    protected boolean processorAvailable(IResource resource) {
        boolean result;
        block8: {
            result = false;
            if (resource.isAccessible()) {
                try {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        IStructuredFormatProcessor formatProcessor = null;
                        IContentDescription contentDescription = file.getContentDescription();
                        if (contentDescription != null) {
                            IContentType contentType = contentDescription.getContentType();
                            formatProcessor = this.getFormatProcessor(contentType.getId());
                        }
                        if (formatProcessor != null) {
                            result = true;
                        }
                        break block8;
                    }
                    if (!(resource instanceof IContainer)) break block8;
                    IContainer container = (IContainer)resource;
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        boolean available = this.processorAvailable(members[i]);
                        if (available) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        return result;
    }

    class FormatJob
    extends Job {
        public FormatJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            Object[] elements = FormatActionDelegate.this.fSelection.toArray();
            monitor.beginTask("", elements.length);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IResource) {
                    FormatActionDelegate.this.process((IProgressMonitor)new SubProgressMonitor(monitor, 1), (IResource)elements[i]);
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
            monitor.done();
            if (FormatActionDelegate.this.fErrorStatus.getChildren().length > 0) {
                status = FormatActionDelegate.this.fErrorStatus;
                FormatActionDelegate.this.fErrorStatus = new MultiStatus("org.eclipse.wst.sse.ui", 4, SSEUIMessages.FormatActionDelegate_errorStatusMessage, null);
            }
            return status;
        }
    }
}

