/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.search.FindOccurrencesProcessor;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public abstract class FindOccurrencesActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IEditorPart fEditor;
    static /* synthetic */ Class class$0;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
    }

    public void dispose() {
        this.fEditor = null;
    }

    public void init(IAction action) {
        if (action != null) {
            action.setText(SSEUIMessages.FindOccurrences_label);
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        ITextSelection textSelection;
        FindOccurrencesProcessor findOccurrenceProcessor;
        ITextEditor textEditor;
        IDocument document;
        boolean okay = false;
        if (this.fEditor instanceof ITextEditor && (document = (textEditor = (ITextEditor)this.fEditor).getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null && (findOccurrenceProcessor = this.getProcessorForCurrentSelection(document, textSelection = this.getTextSelection(textEditor))) != null && textEditor.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)textEditor.getEditorInput()).getFile();
            okay = findOccurrenceProcessor.findOccurrences(document, textSelection, file);
        }
        if (okay) {
            PlatformStatusLineUtil.clearStatusLine();
        } else {
            String errorMessage = SSEUIMessages.FindOccurrencesActionProvider_0;
            PlatformStatusLineUtil.displayErrorMessage(errorMessage);
            PlatformStatusLineUtil.addOneTimeClearListener();
        }
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        PlatformStatusLineUtil.clearStatusLine();
    }

    private FindOccurrencesProcessor getProcessorForCurrentSelection(IDocument document, ITextSelection textSelection) {
        ITypedRegion tr = this.getPartition(document, textSelection);
        String partition = tr != null ? tr.getType() : "";
        Iterator it = this.getProcessors().iterator();
        FindOccurrencesProcessor processor = null;
        while (it.hasNext()) {
            processor = (FindOccurrencesProcessor)it.next();
            if (!processor.enabledForParitition(partition)) continue;
            return processor;
        }
        ExtendedConfigurationBuilder extendedConfigurationBuilder = ExtendedConfigurationBuilder.getInstance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.search.FindOccurrencesProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List extendedFindOccurrencesProcessors = extendedConfigurationBuilder.getConfigurations(clazz.getName(), partition);
        int i = 0;
        while (i < extendedFindOccurrencesProcessors.size()) {
            Object o = extendedFindOccurrencesProcessors.get(i);
            if (o instanceof FindOccurrencesProcessor && (processor = (FindOccurrencesProcessor)o).enabledForParitition(partition)) {
                return processor;
            }
            ++i;
        }
        return null;
    }

    private ITypedRegion getPartition(IDocument document, ITextSelection textSelection) {
        ITypedRegion region = null;
        if (textSelection != null) {
            try {
                region = document.getPartition(textSelection.getOffset());
            }
            catch (BadLocationException badLocationException) {
                region = null;
            }
        }
        return region;
    }

    private ITextSelection getTextSelection(ITextEditor textEditor) {
        ITextSelection textSelection = null;
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty()) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }

    protected abstract List getProcessors();
}

