/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.internal.resources.ResourceListVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceListVirtualComponent
implements IVirtualComponent {
    protected IProject project;
    protected IVirtualComponent referencingComp;

    public AbstractResourceListVirtualComponent(IProject p, IVirtualComponent referencingComponent) {
        this.project = p;
        this.referencingComp = referencingComponent;
    }

    @Override
    public void create(int updateFlags, IProgressMonitor aMonitor) throws CoreException {
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public IVirtualComponent getComponent() {
        return this;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public String getDeployedName() {
        return this.getName();
    }

    public String getId() {
        String firstSegment = this.getFirstIdSegment();
        if (this.project != null && this.project.equals((Object)this.referencingComp.getProject())) {
            return firstSegment;
        }
        return String.valueOf(firstSegment) + '/' + this.project.getName();
    }

    protected abstract String getFirstIdSegment();

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IVirtualComponent[] getReferencingComponents() {
        IVirtualComponent[] iVirtualComponentArray;
        if (this.referencingComp == null) {
            iVirtualComponentArray = new IVirtualComponent[]{};
        } else {
            IVirtualComponent[] iVirtualComponentArray2 = new IVirtualComponent[1];
            iVirtualComponentArray = iVirtualComponentArray2;
            iVirtualComponentArray2[0] = this.referencingComp;
        }
        return iVirtualComponentArray;
    }

    @Override
    public IVirtualFolder getRootFolder() {
        IContainer[] containers = this.getUnderlyingContainers();
        IResource[] looseResources = this.getLooseResources();
        ResourceListVirtualFolder folder = new ResourceListVirtualFolder(this.project, (IPath)new Path("/"), containers, looseResources);
        return folder;
    }

    protected abstract IContainer[] getUnderlyingContainers();

    protected abstract IResource[] getLooseResources();

    @Override
    public Properties getMetaProperties() {
        return null;
    }

    @Override
    public IPath[] getMetaResources() {
        return null;
    }

    @Override
    public IVirtualReference getReference(String aComponentName) {
        return null;
    }

    @Override
    public IVirtualReference[] getReferences() {
        return new IVirtualReference[0];
    }

    @Override
    public IVirtualReference[] getReferences(Map<String, Object> options) {
        return new IVirtualReference[0];
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public void setMetaProperties(Properties properties) {
    }

    @Override
    public void setMetaProperty(String name, String value) {
    }

    @Override
    public void setMetaResources(IPath[] theMetaResourcePaths) {
    }

    @Override
    public void setReferences(IVirtualReference[] theReferences) {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public void addReferences(IVirtualReference[] references) {
    }
}

