/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpointParticipant;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.StackFrame;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.Event;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.StepEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.SuspendEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequestManager;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.StepRequest;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptThread;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.IJavaScriptEventListener;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugElement;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptValue;
import org.eclipse.wst.jsdt.debug.internal.core.model.ModelMessages;

public class JavaScriptThread
extends JavaScriptDebugElement
implements IJavaScriptThread,
IJavaScriptEventListener {
    static final IStackFrame[] NO_STACK_FRAMES = new IStackFrame[0];
    static final IBreakpoint[] NO_BREAKPOINTS = new IBreakpoint[0];
    private static final int UNKNOWN = 0;
    private static final int SUSPENDED = 1;
    private static final int RUNNING = 2;
    private static final int STEPPING = 3;
    private static final int TERMINATED = 4;
    private List frames = null;
    private ArrayList breakpoints = new ArrayList(4);
    private int state = 0;
    private final ThreadReference thread;
    private boolean suspending = false;

    public JavaScriptThread(JavaScriptDebugTarget target, ThreadReference thread) {
        super(target);
        Assert.isNotNull((Object)thread);
        this.thread = thread;
        this.state = thread.isSuspended() ? 1 : 2;
    }

    private String statusText() {
        switch (this.state) {
            case 1: {
                if (this.breakpoints.size() > 0) {
                    try {
                        JavaScriptBreakpoint breakpoint = (JavaScriptBreakpoint)this.breakpoints.get(0);
                        if (breakpoint instanceof JavaScriptLoadBreakpoint) {
                            String name = breakpoint.getScriptPath();
                            if ("".equals(name)) {
                                name = ModelMessages.JavaScriptThread_evaluated_script;
                            }
                            return NLS.bind((String)ModelMessages.JSDIThread_suspended_loading_script, (Object)name);
                        }
                    }
                    catch (CoreException ce) {
                        JavaScriptDebugPlugin.log(ce);
                    }
                }
                return ModelMessages.thread_suspended;
            }
            case 2: {
                return ModelMessages.thread_running;
            }
            case 3: {
                return ModelMessages.thread_stepping;
            }
            case 4: {
                return ModelMessages.thread_terminated;
            }
            case 0: {
                return ModelMessages.thread_zombie;
            }
        }
        return ModelMessages.thread_state_unknown;
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.breakpoints.isEmpty()) {
            return NO_BREAKPOINTS;
        }
        return this.breakpoints.toArray(new IBreakpoint[this.breakpoints.size()]);
    }

    public String getName() throws DebugException {
        return NLS.bind((String)ModelMessages.JSDIThread_thread_title, (Object[])new String[]{this.thread.name(), this.statusText()});
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return NO_STACK_FRAMES;
        }
        if (this.frames == null) {
            this.frames = new ArrayList();
            List threadFrames = this.thread.frames();
            Iterator iterator = threadFrames.iterator();
            while (iterator.hasNext()) {
                StackFrame stackFrame = (StackFrame)iterator.next();
                JavaScriptStackFrame jsdiStackFrame = this.createJSDIStackFrame(stackFrame);
                this.frames.add(jsdiStackFrame);
            }
        }
        return this.frames.toArray(new IStackFrame[this.frames.size()]);
    }

    JavaScriptStackFrame createJSDIStackFrame(StackFrame stackFrame) {
        return new JavaScriptStackFrame(this, stackFrame);
    }

    private synchronized void clearFrames() {
        if (this.frames != null) {
            this.frames.clear();
            this.frames = null;
        }
    }

    private synchronized void clearBreakpoints() {
        this.breakpoints.clear();
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] stackFrames = this.getStackFrames();
        if (stackFrames != null && stackFrames.length > 0) {
            return stackFrames[0];
        }
        return null;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public synchronized boolean canResume() {
        return this.state == 1;
    }

    public synchronized boolean canSuspend() {
        return this.state == 2;
    }

    public synchronized boolean isSuspended() {
        return this.state == 1;
    }

    public synchronized void resume() throws DebugException {
        if (this.getDebugTarget().isSuspended()) {
            this.getDebugTarget().resume();
        } else {
            this.resume(true);
        }
    }

    public synchronized void targetResume() {
        this.resume(false);
    }

    void resume(boolean fireevent) {
        if (this.canResume()) {
            this.thread.resume();
            this.markResumed();
            if (fireevent) {
                this.fireResumeEvent(32);
            }
        }
    }

    public synchronized void suspend() throws DebugException {
        if (this.canSuspend()) {
            this.suspendUnderlyingThread();
        }
    }

    void suspendUnderlyingThread() {
        if (this.suspending) {
            return;
        }
        if (this.isSuspended()) {
            this.fireSuspendEvent(32);
            return;
        }
        this.suspending = true;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        JavaScriptThread.this.thread.suspend();
                        long stop = System.currentTimeMillis() + 30000L;
                        boolean suspended = JavaScriptThread.this.thread.isSuspended();
                        while (System.currentTimeMillis() < stop && !suspended) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            if (!(suspended = JavaScriptThread.this.thread.isSuspended())) continue;
                        }
                        if (!suspended) {
                            Status status = new Status(4, "org.eclipse.wst.jsdt.debug.core", 100, NLS.bind((String)ModelMessages.thread_timed_out_trying_to_suspend, (Object[])new String[]{new Integer(30000).toString()}), null);
                            JavaScriptDebugPlugin.log((IStatus)status);
                        }
                        JavaScriptThread.this.markSuspended();
                        JavaScriptThread.this.fireSuspendEvent(32);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    JavaScriptThread.this.suspending = false;
                    throw throwable;
                }
                {
                    Object var5_6 = null;
                }
                JavaScriptThread.this.suspending = false;
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public boolean suspendForBreakpoint(IJavaScriptBreakpoint breakpoint, boolean vote) {
        IJavaScriptBreakpointParticipant[] participants = JavaScriptDebugPlugin.getParticipantManager().getParticipants(breakpoint);
        int suspend = 0;
        int i = 0;
        while (i < participants.length) {
            suspend |= participants[i].breakpointHit(this, breakpoint);
            ++i;
        }
        if ((suspend & 1) > 0 || suspend == 0) {
            this.addBreakpoint(breakpoint);
            return true;
        }
        return false;
    }

    public void suspendForBreakpointComplete(IJavaScriptBreakpoint breakpoint, boolean suspend, EventSet eventSet) {
        if (suspend) {
            try {
                if (breakpoint.getSuspendPolicy() == 1) {
                    this.markSuspended();
                } else {
                    this.getDebugTarget().suspend();
                }
                this.fireSuspendEvent(16);
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
    }

    public int suspendForScriptLoad(IJavaScriptBreakpoint breakpoint, ScriptReference script, boolean vote) {
        IJavaScriptBreakpointParticipant[] participants = JavaScriptDebugPlugin.getParticipantManager().getParticipants(breakpoint);
        int suspend = 0;
        int i = 0;
        while (i < participants.length) {
            suspend |= participants[i].scriptLoaded(this, script, breakpoint);
            ++i;
        }
        return suspend;
    }

    public void suspendForScriptLoadComplete(IJavaScriptBreakpoint breakpoint, ScriptReference script, boolean suspend, EventSet eventSet) {
        if (suspend) {
            try {
                if (breakpoint.getSuspendPolicy() == 1) {
                    this.markSuspended();
                } else {
                    this.getDebugTarget().suspend();
                }
                this.suspendUnderlyingThread();
                this.fireSuspendEvent(16);
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBreakpoint(IJavaScriptBreakpoint breakpoint) {
        ArrayList arrayList = this.breakpoints;
        synchronized (arrayList) {
            return this.breakpoints.add(breakpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBreakpoint(IJavaScriptBreakpoint breakpoint) {
        ArrayList arrayList = this.breakpoints;
        synchronized (arrayList) {
            return this.breakpoints.remove(breakpoint);
        }
    }

    synchronized void markSuspended() {
        this.state = 1;
    }

    synchronized void markResumed() {
        this.state = 2;
        this.clearFrames();
        this.clearBreakpoints();
    }

    synchronized void markTerminated() {
        this.state = 4;
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public synchronized boolean isStepping() {
        return this.state == 3;
    }

    private synchronized void step(int step, int debugEvent) throws DebugException {
        if (this.canResume()) {
            this.registerStepRequest(step);
            this.thread.resume();
            this.state = 3;
            this.clearFrames();
            this.clearBreakpoints();
            this.fireResumeEvent(debugEvent);
        }
    }

    public void registerStepRequest(int step) {
        EventRequestManager requestManager = this.thread.virtualMachine().eventRequestManager();
        StepRequest stepRequest = requestManager.createStepRequest(this.thread, step);
        stepRequest.setEnabled(true);
        this.getJavaScriptDebugTarget().addJSDIEventListener(this, stepRequest);
    }

    public void stepInto() throws DebugException {
        this.step(1, 1);
    }

    public void stepOver() throws DebugException {
        this.step(2, 2);
    }

    public void stepReturn() throws DebugException {
        this.step(3, 4);
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public synchronized boolean isTerminated() {
        return this.state == 4;
    }

    public synchronized void terminate() throws DebugException {
        this.state = 4;
        this.getJavaScriptDebugTarget().terminate();
    }

    public boolean matches(ThreadReference thread) {
        return this.thread == thread;
    }

    public void eventSetComplete(Event event, JavaScriptDebugTarget target, boolean suspend, EventSet eventSet) {
        EventRequestManager requestManager;
        ThreadReference threadReference;
        if (event instanceof SuspendEvent) {
            SuspendEvent suspendEvent = (SuspendEvent)event;
            threadReference = suspendEvent.thread();
            if (threadReference == this.thread) {
                this.fireSuspendEvent(32);
            }
            requestManager = this.thread.virtualMachine().eventRequestManager();
            requestManager.deleteEventRequest(event.request());
            this.getJavaScriptDebugTarget().removeJSDIEventListener(this, event.request());
        }
        if (event instanceof StepEvent) {
            StepEvent stepEvent = (StepEvent)event;
            threadReference = stepEvent.thread();
            if (threadReference == this.thread) {
                this.fireSuspendEvent(8);
            }
            requestManager = this.thread.virtualMachine().eventRequestManager();
            requestManager.deleteEventRequest(event.request());
            this.getJavaScriptDebugTarget().removeJSDIEventListener(this, event.request());
        }
    }

    public synchronized boolean handleEvent(Event event, JavaScriptDebugTarget target, boolean suspendVote, EventSet eventSet) {
        if (event instanceof SuspendEvent) {
            SuspendEvent suspendEvent = (SuspendEvent)event;
            ThreadReference threadReference = suspendEvent.thread();
            if (threadReference == this.thread) {
                this.markSuspended();
            }
            return false;
        }
        if (event instanceof StepEvent) {
            StepEvent stepEvent = (StepEvent)event;
            ThreadReference threadReference = stepEvent.thread();
            if (threadReference == this.thread) {
                this.markSuspended();
            }
            return false;
        }
        return true;
    }

    public IJavaScriptValue evaluate(String expression) {
        try {
            IStackFrame frame = this.getTopStackFrame();
            if (frame instanceof JavaScriptStackFrame) {
                return new JavaScriptValue(this.getJavaScriptDebugTarget(), ((JavaScriptStackFrame)frame).getUnderlyingStackFrame().evaluate(expression));
            }
        }
        catch (DebugException debugException) {}
        return new JavaScriptValue(this.getJavaScriptDebugTarget(), this.getVM().mirrorOfNull());
    }

    public int getFrameCount() {
        if (this.isSuspended()) {
            return this.thread.frameCount();
        }
        return 0;
    }
}

