/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.patch.HunkDiffNode;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.PatchProjectDiffNode;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriber;
import org.eclipse.team.internal.ui.synchronize.patch.DiffProjectResourceMapping;
import org.eclipse.team.internal.ui.synchronize.patch.FilePatchResourceMapping;
import org.eclipse.team.internal.ui.synchronize.patch.HunkResourceMapping;
import org.eclipse.team.internal.ui.synchronize.patch.PatchWorkspace;

public class PatchModelProvider
extends ModelProvider {
    public static final String ID = "org.eclipse.team.ui.patchModelProvider";
    private static PatchModelProvider provider;

    public static PatchModelProvider getProvider() {
        if (provider == null) {
            try {
                provider = (PatchModelProvider)ModelProvider.getModelProviderDescriptor((String)ID).getModelProvider();
            }
            catch (CoreException e) {
                TeamPlugin.log((CoreException)e);
            }
        }
        return provider;
    }

    static ResourceMapping getResourceMapping(IDiffElement object) {
        if (object instanceof PatchProjectDiffNode) {
            return new DiffProjectResourceMapping(((PatchProjectDiffNode)object).getDiffProject());
        }
        if (object instanceof PatchFileDiffNode) {
            return new FilePatchResourceMapping(((PatchFileDiffNode)object).getDiffResult());
        }
        if (object instanceof HunkDiffNode) {
            return new HunkResourceMapping(((HunkDiffNode)object).getHunkResult());
        }
        return null;
    }

    static IResource getResource(PatchDiffNode element) {
        IResource resource = null;
        if (element instanceof PatchProjectDiffNode) {
            return ((PatchProjectDiffNode)element).getResource();
        }
        if (element instanceof PatchFileDiffNode) {
            return ((PatchFileDiffNode)element).getResource();
        }
        if (element instanceof HunkDiffNode) {
            return ((HunkDiffNode)element).getResource();
        }
        return resource;
    }

    static Object getPatchObject(IResource resource, WorkspacePatcher patcher) {
        switch (resource.getType()) {
            case 4: {
                int i;
                if (patcher.isWorkspacePatch()) {
                    DiffProject[] diffProjects = patcher.getDiffProjects();
                    i = 0;
                    while (i < diffProjects.length) {
                        if (diffProjects[i].getName().equals(resource.getName())) {
                            return diffProjects[i];
                        }
                        ++i;
                    }
                }
            }
            case 1: {
                FilePatch2[] diffs = patcher.getDiffs();
                int i = 0;
                while (i < diffs.length) {
                    if (resource.equals((Object)PatchModelProvider.getFile(diffs[i], patcher))) {
                        return diffs[i];
                    }
                    ++i;
                }
                break;
            }
        }
        return null;
    }

    static IFile getFile(FilePatch2 diff, WorkspacePatcher patcher) {
        IProject project = null;
        if (patcher.isWorkspacePatch()) {
            DiffProject diffProject = diff.getProject();
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(diffProject.getName());
            if (project.getName().equals(diffProject.getName())) {
                return project.getFile(diff.getPath(patcher.isReversed()));
            }
        } else {
            project = patcher.getTarget().getProject();
            if (project.getName().equals(patcher.getTarget().getProject().getName())) {
                return project.getFile(diff.getPath(patcher.isReversed()));
            }
        }
        return project.getFile(diff.getPath(patcher.isReversed()));
    }

    public static PatchWorkspace getPatchWorkspace(Subscriber subscriber) {
        if (subscriber instanceof ApplyPatchSubscriber) {
            ApplyPatchSubscriber aps = (ApplyPatchSubscriber)subscriber;
            return new PatchWorkspace(aps.getPatcher());
        }
        return null;
    }
}

