/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportUtilities;
import org.eclipse.draw2d.geometry.Rectangle;

public class ConnectionLayer
extends FreeformLayer {
    int antialias = -1;
    protected ConnectionRouter connectionRouter;

    public ConnectionLayer() {
        this.setClippingStrategy(new ClippingStrategy());
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        if (figure instanceof Connection && this.getConnectionRouter() != null) {
            ((Connection)figure).setConnectionRouter(this.getConnectionRouter());
        }
    }

    public ConnectionRouter getConnectionRouter() {
        return this.connectionRouter;
    }

    public void paint(Graphics graphics) {
        if (this.antialias != -1) {
            graphics.setAntialias(this.antialias);
        }
        super.paint(graphics);
    }

    public void remove(IFigure figure) {
        if (figure instanceof Connection) {
            ((Connection)figure).setConnectionRouter(null);
        }
        super.remove(figure);
    }

    public void setConnectionRouter(ConnectionRouter router) {
        this.connectionRouter = router;
        Figure.FigureIterator iter = new Figure.FigureIterator(this);
        while (iter.hasNext()) {
            IFigure figure = iter.nextFigure();
            if (!(figure instanceof Connection)) continue;
            ((Connection)figure).setConnectionRouter(router);
        }
    }

    public void setAntialias(int antialias) {
        this.antialias = antialias;
    }

    protected class ClippingStrategy
    implements IClippingStrategy {
        protected ClippingStrategy() {
        }

        public Rectangle[] getClip(IFigure figure) {
            Rectangle[] clipRect = null;
            clipRect = figure instanceof Connection ? this.getEdgeClippingRectangle((Connection)figure) : new Rectangle[]{this.getNodeClippingRectangle(figure)};
            int i = 0;
            while (i < clipRect.length) {
                figure.translateToRelative(clipRect[i]);
                ++i;
            }
            return clipRect;
        }

        protected Rectangle[] getEdgeClippingRectangle(Connection connection) {
            Viewport nearestEnclosingTargetViewport;
            Viewport nearestEnclosingSourceViewport;
            Rectangle clipRect = this.getAbsoluteBoundsCopy(connection);
            ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
            ConnectionAnchor targetAnchor = connection.getTargetAnchor();
            if (sourceAnchor == null || sourceAnchor.getOwner() == null || targetAnchor == null || targetAnchor.getOwner() == null) {
                return new Rectangle[]{clipRect};
            }
            Viewport nearestEnclosingSourceTargetViewport = ViewportUtilities.getNearestCommonViewport(sourceAnchor.getOwner(), targetAnchor.getOwner());
            if (nearestEnclosingSourceTargetViewport != null) {
                clipRect.intersect(this.getNodeClippingRectangle(nearestEnclosingSourceTargetViewport.getParent()));
            }
            if ((nearestEnclosingSourceViewport = ViewportUtilities.getNearestEnclosingViewport(sourceAnchor.getOwner())) != (nearestEnclosingTargetViewport = ViewportUtilities.getNearestEnclosingViewport(targetAnchor.getOwner()))) {
                Rectangle sourceClipRect = this.getNodeClippingRectangle(sourceAnchor.getOwner());
                Rectangle targetClipRect = this.getNodeClippingRectangle(targetAnchor.getOwner());
                if (!sourceClipRect.contains(sourceAnchor.getLocation(sourceAnchor.getReferencePoint())) || !targetClipRect.contains(targetAnchor.getLocation(targetAnchor.getReferencePoint()))) {
                    Rectangle sourceClip = new Rectangle();
                    if (nearestEnclosingSourceViewport != nearestEnclosingSourceTargetViewport) {
                        sourceClip = clipRect.getIntersection(this.getNodeClippingRectangle(nearestEnclosingSourceViewport.getParent()));
                    }
                    Rectangle targetClip = new Rectangle();
                    if (nearestEnclosingTargetViewport != nearestEnclosingSourceTargetViewport) {
                        sourceClip = clipRect.getIntersection(this.getNodeClippingRectangle(nearestEnclosingTargetViewport.getParent()));
                    }
                    return new Rectangle[]{sourceClip, targetClip};
                }
                return new Rectangle[]{clipRect};
            }
            return new Rectangle[]{clipRect};
        }

        protected Rectangle getNodeClippingRectangle(IFigure figure) {
            Rectangle clipRect = this.getAbsoluteBoundsCopy(figure);
            List enclosingViewportsPath = ViewportUtilities.getEnclosingViewportsPath(figure);
            Iterator iterator = enclosingViewportsPath.iterator();
            while (iterator.hasNext()) {
                Viewport viewport = (Viewport)iterator.next();
                clipRect.intersect(this.getAbsoluteBoundsCopy(viewport.getParent()));
            }
            return clipRect;
        }

        private Rectangle getAbsoluteBoundsCopy(IFigure figure) {
            Rectangle absoluteFigureBounds = figure.getBounds().getCopy();
            figure.translateToAbsolute(absoluteFigureBounds);
            return absoluteFigureBounds;
        }
    }
}

