/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.model.MethodKey;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;

public abstract class AbstractIllegalMethodReference
extends AbstractProblemDetector {
    private Map fIllegalMethods = new HashMap();
    private Map fMethodComponents = new HashMap();

    void addIllegalMethod(IMethodDescriptor method, String componentId) {
        this.fIllegalMethods.put(new MethodKey(method.getEnclosingType().getQualifiedName(), method.getName(), method.getSignature(), true), method);
        this.fMethodComponents.put(method, componentId);
    }

    public boolean considerReference(IReference reference) {
        if (super.considerReference(reference) & this.fIllegalMethods.containsKey(new MethodKey(reference.getReferencedTypeName(), reference.getReferencedMemberName(), reference.getReferencedSignature(), true))) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    protected boolean isProblem(IReference reference) {
        if (!super.isProblem(reference)) {
            return false;
        }
        IApiMember method = reference.getResolvedReference();
        String componentId = (String)this.fMethodComponents.get(method.getHandle());
        return componentId != null && method.getApiComponent().getSymbolicName().equals(componentId);
    }

    protected int getElementType(IReference reference) {
        return 6;
    }

    protected int getProblemFlags(IReference reference) {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        if (method.isConstructor()) {
            return 7;
        }
        return 8;
    }
}

