/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;

public abstract class AbstractIllegalTypeReference
extends AbstractProblemDetector {
    private Map fIllegalTypes = new HashMap();

    void addIllegalType(IReferenceTypeDescriptor type, String componentId) {
        this.fIllegalTypes.put(type.getQualifiedName(), componentId);
    }

    public boolean considerReference(IReference reference) {
        if (super.considerReference(reference) & this.fIllegalTypes.containsKey(reference.getReferencedTypeName())) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    protected boolean isIllegalType(IReference reference) {
        return this.fIllegalTypes.containsKey(reference.getReferencedTypeName());
    }

    protected boolean isProblem(IReference reference) {
        if (!super.isProblem(reference)) {
            return false;
        }
        IApiMember type = reference.getResolvedReference();
        Object componentId = this.fIllegalTypes.get(type.getName());
        return componentId != null && type.getApiComponent().getSymbolicName().equals(componentId);
    }

    protected Position getSourceRange(IType type, IDocument doc, IReference reference) throws CoreException, BadLocationException {
        ISourceRange range = type.getNameRange();
        Position pos = null;
        if (range != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    protected int getElementType(IReference reference) {
        return 2;
    }

    protected String[] getMessageArgs(IReference reference) throws CoreException {
        return new String[]{this.getSimpleTypeName(reference.getResolvedReference()), this.getSimpleTypeName(reference.getMember())};
    }

    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        return new String[]{this.getQualifiedTypeName(reference.getResolvedReference()), this.getQualifiedTypeName(reference.getMember())};
    }

    protected int getProblemFlags(IReference reference) {
        return 0;
    }
}

