/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.releng.tools.MapEntry;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ui.UIProjectSetSerializationContext;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class LoadMap
extends CVSAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(null){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        IResource[] resources = LoadMap.this.getSelectedResources();
                        String[] referenceStrings = LoadMap.this.getReferenceStrings(resources);
                        RepositoryProviderType type = RepositoryProviderType.getProviderType((String)CVSProviderPlugin.getTypeId());
                        ProjectSetCapability c = type.getProjectSetCapability();
                        c.addToWorkspace(referenceStrings, (ProjectSetSerializationContext)new UIProjectSetSerializationContext(LoadMap.this.getShell(), null), monitor);
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, true, 1);
    }

    protected String[] getReferenceStrings(IResource[] mapFiles) throws CoreException {
        ArrayList<String> allStrings = new ArrayList<String>();
        int i = 0;
        while (i < mapFiles.length) {
            IResource resource = mapFiles[i];
            String[] referenceStrings = LoadMap.readReferenceStrings((IFile)resource);
            allStrings.addAll(Arrays.asList(referenceStrings));
            ++i;
        }
        return allStrings.toArray(new String[allStrings.size()]);
    }

    protected static String[] readReferenceStrings(IFile file) throws CoreException {
        String[] stringArray;
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));
        try {
            String line = reader.readLine();
            ArrayList<String> references = new ArrayList<String>();
            while (line != null) {
                String referenceString = new MapEntry(line).getReferenceString();
                if (referenceString != null) {
                    references.add(referenceString);
                }
                line = reader.readLine();
            }
            stringArray = references.toArray(new String[references.size()]);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.releng.tools", 0, "An I/O error occured", (Throwable)e));
            }
        }
        reader.close();
        return stringArray;
    }

    public boolean isEnabled() {
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() != 1) {
                return false;
            }
            if (!resource.getFileExtension().equals("map")) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

