/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.releng.tools.MapEntry;

public class MapFile {
    public static final String MAP_FILE_EXTENSION = "map";
    protected IFile file;
    protected MapEntry[] entries;

    public MapFile(IFile aFile) throws CoreException {
        this.file = aFile;
        this.loadEntries();
    }

    public IFile getFile() {
        return this.file;
    }

    protected void loadEntries() throws CoreException {
        InputStream inputStream = null;
        ArrayList<MapEntry> list = new ArrayList<MapEntry>();
        try {
            try {
                inputStream = this.file.getContents();
                BufferedReader aReader = new BufferedReader(new InputStreamReader(inputStream));
                String aLine = aReader.readLine();
                while (aLine != null) {
                    if (this.isMapLine(aLine)) {
                        list.add(new MapEntry(aLine));
                    }
                    aLine = aReader.readLine();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.releng.tools", 0, "An I/O Error occurred process map file " + this.file.getFullPath().toString(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.entries = list.toArray(new MapEntry[list.size()]);
    }

    private boolean isMapLine(String line) {
        if (line.trim().length() == 0) {
            return false;
        }
        return !line.startsWith("!");
    }

    public boolean contains(IProject project) {
        int j = 0;
        while (j < this.entries.length) {
            if (this.entries[j].isMappedTo(project)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public MapEntry getMapEntry(IProject project) {
        int j = 0;
        while (j < this.entries.length) {
            if (this.entries[j].isMappedTo(project)) {
                return this.entries[j];
            }
            ++j;
        }
        return null;
    }

    public IProject[] getAccessibleProjects() {
        HashSet<IProject> list = new HashSet<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (this.entries == null || this.entries.length == 0) {
            return null;
        }
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.isAccessible()) {
                int j = 0;
                while (j < this.entries.length) {
                    if (this.entries[j].isMappedTo(project)) {
                        list.add(project);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new IProject[list.size()]);
    }

    public String getName() {
        return this.file.getName();
    }
}

