/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.releng.tools.SourceFile;

public class XmlFile
extends SourceFile {
    public XmlFile(IFile file) {
        super(file);
    }

    public String getCommentStart() {
        return "<!--";
    }

    public String getCommentEnd() {
        return "-->";
    }

    public int getFileType() {
        return 7;
    }

    protected void doInsert(String comment, IDocument document) throws BadLocationException, IOException {
        int insertOffset = this.findInsertOffset(document);
        document.replace(insertOffset, 0, comment);
    }

    private int findInsertOffset(IDocument document) throws BadLocationException {
        boolean inInstruction = false;
        int insertOffset = 0;
        int offset = 0;
        while (offset < document.getLength()) {
            char c = document.getChar(offset);
            if (Character.isWhitespace(c)) {
                insertOffset = offset;
            } else {
                char c2;
                char c3 = c2 = offset + 1 < document.getLength() ? document.getChar(offset + 1) : (char)'\u0000';
                if (inInstruction) {
                    if (c == '?' && c2 == '>') {
                        insertOffset = offset + 1;
                        inInstruction = false;
                        ++offset;
                    }
                } else {
                    if (c != '<' || c2 != '?') break;
                    inInstruction = true;
                    ++offset;
                }
            }
            ++offset;
        }
        return insertOffset;
    }
}

