/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CopyrightPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String NEW_LINE = "\n";
    private Composite fComposite;
    private Label fCopyrightLabel;
    private SourceViewer fEditor;
    private Text fInstructions;
    private Label fCreationYearLabel;
    private Text fCreationYear;
    private Label fRevisionYearLabel;
    private Text fRevisionYear;
    private Button fUseDefaultRevisionYear;
    private Button fReplaceAllExisting;
    private Button fIgnoreProperties;
    private Button fIgnoreXml;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fComposite.setLayoutData((Object)new GridData(1808));
        this.fEditor = this.createEditor(this.fComposite);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 0;
        this.fInstructions = new Text(this.fComposite, 8);
        this.fInstructions.setText(Messages.getString("CopyrightPreferencePage.0"));
        this.fInstructions.setLayoutData((Object)data);
        this.fCreationYearLabel = new Label(this.fComposite, 0);
        this.fCreationYearLabel.setText(Messages.getString("CopyrightPreferencePage.1"));
        this.fCreationYear = new Text(this.fComposite, 2048);
        this.fCreationYear.setTextLimit(4);
        this.fRevisionYearLabel = new Label(this.fComposite, 0);
        this.fRevisionYearLabel.setText(Messages.getString("CopyrightPreferencePage.7"));
        this.fRevisionYear = new Text(this.fComposite, 2048);
        this.fRevisionYear.setTextLimit(4);
        this.fUseDefaultRevisionYear = new Button(this.fComposite, 32);
        this.fUseDefaultRevisionYear.setText(Messages.getString("CopyrightPreferencePage.8"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.fUseDefaultRevisionYear.setLayoutData((Object)data);
        this.fReplaceAllExisting = new Button(this.fComposite, 32);
        this.fReplaceAllExisting.setText(Messages.getString("CopyrightPreferencePage.2"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.fReplaceAllExisting.setLayoutData((Object)data);
        this.fIgnoreProperties = new Button(this.fComposite, 32);
        this.fIgnoreProperties.setText(Messages.getString("CopyrightPreferencePage.4"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.fIgnoreProperties.setLayoutData((Object)data);
        this.fIgnoreXml = new Button(this.fComposite, 32);
        this.fIgnoreXml.setText(Messages.getString("CopyrightPreferencePage.9"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.fIgnoreXml.setLayoutData((Object)data);
        KeyAdapter listener1 = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CopyrightPreferencePage.this.validateValues();
            }
        };
        this.fCreationYear.addKeyListener((KeyListener)listener1);
        this.fRevisionYear.addKeyListener((KeyListener)listener1);
        this.initializeValues();
        this.applyDialogFont(this.fComposite);
        return this.fComposite;
    }

    private SourceViewer createEditor(Composite parent) {
        this.fCopyrightLabel = new Label(parent, 0);
        this.fCopyrightLabel.setText(Messages.getString("CopyrightPreferencePage.5"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.fCopyrightLabel.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        Document document = new Document();
        viewer.setEditable(true);
        viewer.setDocument((IDocument)document);
        int nLines = 10;
        Control control = viewer.getControl();
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(nLines);
        data.horizontalSpan = 2;
        control.setLayoutData((Object)data);
        return viewer;
    }

    private SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){};
        viewer.configure(configuration);
        return viewer;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fEditor.getDocument().set(store.getString("org.eclipse.releng.tools.copyrightTemplate"));
        this.fCreationYear.setText(store.getString("org.eclipse.releng.tools.creationYear"));
        this.fRevisionYear.setText(store.getString("org.eclipse.releng.tools.revisionYear"));
        this.fUseDefaultRevisionYear.setSelection(store.getBoolean("org.eclipse.releng.tools.useDefaultRevisionYear"));
        this.fReplaceAllExisting.setSelection(store.getBoolean("org.eclipse.releng.tools.replaceAllExisting"));
        this.fIgnoreProperties.setSelection(store.getBoolean("org.eclipse.releng.tools.ignoreProperties"));
        this.fIgnoreXml.setSelection(store.getBoolean("org.eclipse.releng.tools.ignoreXml"));
    }

    private void validateValues() {
        String ERROR_MESSAGE = Messages.getString("CopyrightPreferencePage.6");
        String errorMsg = null;
        String creationYear = this.fCreationYear.getText();
        String revisionYear = this.fRevisionYear.getText();
        try {
            int year = Integer.parseInt(creationYear);
            if (year < 0) {
                errorMsg = ERROR_MESSAGE;
            }
            if ((year = Integer.parseInt(revisionYear)) < 0) {
                errorMsg = ERROR_MESSAGE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            errorMsg = ERROR_MESSAGE;
        }
        this.setErrorMessage(errorMsg);
        this.setValid(errorMsg == null);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return RelEngPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fEditor.getDocument().set(store.getDefaultString("org.eclipse.releng.tools.copyrightTemplate"));
        this.fCreationYear.setText(store.getDefaultString("org.eclipse.releng.tools.creationYear"));
        this.fRevisionYear.setText(store.getDefaultString("org.eclipse.releng.tools.revisionYear"));
        this.fUseDefaultRevisionYear.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.releng.tools.useDefaultRevisionYear"));
        this.fReplaceAllExisting.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.releng.tools.replaceAllExisting"));
        this.fIgnoreProperties.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.releng.tools.ignoreProperties"));
        this.fIgnoreXml.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.releng.tools.ignoreXml"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.releng.tools.copyrightTemplate", this.fixupLineDelimiters(this.fEditor.getDocument()));
        store.setValue("org.eclipse.releng.tools.creationYear", this.fCreationYear.getText());
        store.setValue("org.eclipse.releng.tools.revisionYear", this.fRevisionYear.getText());
        store.setValue("org.eclipse.releng.tools.useDefaultRevisionYear", this.fUseDefaultRevisionYear.getSelection());
        store.setValue("org.eclipse.releng.tools.replaceAllExisting", this.fReplaceAllExisting.getSelection());
        store.setValue("org.eclipse.releng.tools.ignoreProperties", this.fIgnoreProperties.getSelection());
        store.setValue("org.eclipse.releng.tools.ignoreXml", this.fIgnoreXml.getSelection());
        RelEngPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    private String fixupLineDelimiters(IDocument doc) {
        String docContents = doc.get();
        String newText = "";
        int lineCount = doc.getNumberOfLines();
        int i = 0;
        while (i < lineCount) {
            try {
                IRegion lineInfo = doc.getLineInformation(i);
                int lineStartOffset = lineInfo.getOffset();
                int lineLength = lineInfo.getLength();
                int lineEndOffset = lineStartOffset + lineLength;
                newText = String.valueOf(newText) + docContents.substring(lineStartOffset, lineEndOffset);
                if (i < lineCount - 1 && this.fEditor.getDocument().getLineDelimiter(i) != null) {
                    newText = String.valueOf(newText) + "\n";
                }
            }
            catch (BadLocationException badLocationException) {}
            ++i;
        }
        return newText;
    }
}

