/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.ReplaceAction;
import org.eclipse.search.internal.ui.util.FileTypeEditor;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class TextSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage {
    private static final int HISTORY_SIZE = 12;
    public static final String EXTENSION_POINT_ID = "org.eclipse.search.internal.ui.text.TextSearchPage";
    private static final String PAGE_NAME = "TextSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_IS_REG_EX_SEARCH = "REG_EX_SEARCH";
    private static final String STORE_SEARCH_DERIVED = "SEARCH_DERIVED";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private static final String STORE_EXTENSIONS = "EXTENSIONS";
    private List fPreviousSearchPatterns = new ArrayList(12);
    private boolean fFirstTime = true;
    private boolean fIsCaseSensitive;
    private boolean fIsRegExSearch;
    private boolean fSearchDerived;
    private Combo fPattern;
    private Button fIsCaseSensitiveCheckbox;
    private Combo fExtensions;
    private Button fIsRegExCheckbox;
    private CLabel fStatusLabel;
    private Button fSearchDerivedCheckbox;
    private ISearchPageContainer fContainer;
    private FileTypeEditor fFileTypeEditor;
    private ContentAssistCommandAdapter fPatterFieldContentAssist;
    private String[] fPreviousExtensions;
    static /* synthetic */ Class class$0;

    private ISearchQuery newQuery() throws CoreException {
        SearchPatternData data = this.getPatternData();
        TextSearchPageInput input = new TextSearchPageInput(data.textPattern, data.isCaseSensitive, data.isRegExSearch, this.createTextSearchScope());
        return TextSearchQueryProvider.getPreferred().createQuery(input);
    }

    public boolean performAction() {
        try {
            NewSearchUI.runQueryInBackground(this.newQuery());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_searchproblems_message, (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public boolean performReplace() {
        IStatus status;
        block4: {
            try {
                status = NewSearchUI.runQueryInForeground(this.getContainer().getRunnableContext(), this.newQuery());
                if (!status.matches(8)) break block4;
                return false;
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_querycreationproblem_message, (IStatus)e.getStatus());
                return false;
            }
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_runproblem_message, (IStatus)status);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                ISearchResultPage page;
                ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                if (view != null && (page = view.getActivePage()) instanceof FileSearchPage) {
                    FileSearchPage filePage = (FileSearchPage)page;
                    new ReplaceAction(filePage.getSite().getShell(), (FileSearchResult)filePage.getInput(), null, true).run();
                }
            }
        });
        return true;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    public FileTextSearchScope createTextSearchScope() {
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                return FileTextSearchScope.newWorkspaceScope(this.getExtensions(), this.fSearchDerived);
            }
            case 1: {
                return this.getSelectedResourcesScope();
            }
            case 3: {
                return this.getEnclosingProjectScope();
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                return FileTextSearchScope.newSearchScope(workingSets, this.getExtensions(), this.fSearchDerived);
            }
        }
        return FileTextSearchScope.newWorkspaceScope(this.getExtensions(), this.fSearchDerived);
    }

    private FileTextSearchScope getSelectedResourcesScope() {
        HashSet<IResource> resources = new HashSet<IResource>();
        ISelection sel = this.getContainer().getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            Iterator iter = ((IStructuredSelection)sel).iterator();
            while (iter.hasNext()) {
                IResource resource;
                Object curr = iter.next();
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return FileTextSearchScope.newWorkspaceScope(this.getExtensions(), this.fSearchDerived);
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2;
                        IAdaptable iAdaptable = elements[i];
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((resource2 = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && resource2.isAccessible()) {
                            resources.add(resource2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)curr;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null || !resource.isAccessible()) continue;
                resources.add(resource);
            }
        }
        IResource[] arr = resources.toArray(new IResource[resources.size()]);
        return FileTextSearchScope.newSearchScope(arr, this.getExtensions(), this.fSearchDerived);
    }

    private FileTextSearchScope getEnclosingProjectScope() {
        String[] enclosingProjectName = this.getContainer().getSelectedProjectNames();
        if (enclosingProjectName == null) {
            return FileTextSearchScope.newWorkspaceScope(this.getExtensions(), this.fSearchDerived);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        int i = 0;
        while (i < res.length) {
            res[i] = root.getProject(enclosingProjectName[i]);
            ++i;
        }
        return FileTextSearchScope.newSearchScope(res, this.getExtensions(), this.fSearchDerived);
    }

    private SearchPatternData findInPrevious(String pattern) {
        Iterator iter = this.fPreviousSearchPatterns.iterator();
        while (iter.hasNext()) {
            SearchPatternData element = (SearchPatternData)iter.next();
            if (!pattern.equals(element.textPattern)) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        SearchPatternData match = this.findInPrevious(this.fPattern.getText());
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getPattern(), this.isCaseSensitive(), this.fIsRegExCheckbox.getSelection(), this.getExtensions(), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    private String[] getPreviousExtensionsOldStyle() {
        ArrayList<String> extensions = new ArrayList<String>(this.fPreviousSearchPatterns.size());
        int size = this.fPreviousSearchPatterns.size();
        int i = 0;
        while (i < size) {
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            String text = FileTypeEditor.typesToString(data.fileNamePatterns);
            if (!extensions.contains(text)) {
                extensions.add(text);
            }
            ++i;
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    private String[] getPreviousSearchPatterns() {
        int size = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = ((SearchPatternData)this.fPreviousSearchPatterns.get((int)i)).textPattern;
            ++i;
        }
        return patterns;
    }

    private String[] getExtensions() {
        return this.fFileTypeEditor.getFileTypes();
    }

    private boolean isCaseSensitive() {
        return this.fIsCaseSensitiveCheckbox.getSelection();
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.fExtensions.setItems(this.fPreviousExtensions);
                if (!this.initializePatternControl()) {
                    this.fPattern.select(0);
                    this.fExtensions.setText("*");
                    this.handleWidgetSelected();
                }
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    final void updateOKStatus() {
        boolean regexStatus = this.validateRegex();
        boolean hasFilePattern = this.fExtensions.getText().length() > 0;
        this.getContainer().setPerformActionEnabled(regexStatus && hasFilePattern);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        this.addTextPatternControls(result);
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.addFileNameControls(result);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.search.text_search_page_context");
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        if (this.fIsRegExCheckbox.getSelection()) {
            block5: {
                try {
                    PatternConstructor.createPattern(this.fPattern.getText(), this.fIsCaseSensitive, true);
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.statusMessage(true, locMessage.substring(0, i));
                return false;
            }
            this.statusMessage(false, "");
        } else {
            this.statusMessage(false, SearchMessages.SearchPage_containingText_hint);
        }
        return true;
    }

    private void addTextPatternControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.SearchPage_containingText_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fPattern = new Combo(group, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchPage.this.handleWidgetSelected();
                TextSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.fPatterFieldContentAssist = new ContentAssistCommandAdapter((Control)this.fPattern, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        this.fPatterFieldContentAssist.setEnabled(this.fIsRegExSearch);
        this.fIsCaseSensitiveCheckbox = new Button(group, 32);
        this.fIsCaseSensitiveCheckbox.setText(SearchMessages.SearchPage_caseSensitive);
        this.fIsCaseSensitiveCheckbox.setSelection(this.fIsCaseSensitive);
        this.fIsCaseSensitiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchPage.this.fIsCaseSensitive = TextSearchPage.this.fIsCaseSensitiveCheckbox.getSelection();
            }
        });
        this.fIsCaseSensitiveCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsCaseSensitiveCheckbox.setFont(group.getFont());
        this.fStatusLabel = new CLabel(group, 16384);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fStatusLabel.setFont(group.getFont());
        this.fStatusLabel.setAlignment(16384);
        this.fStatusLabel.setText(SearchMessages.SearchPage_containingText_hint);
        this.fIsRegExCheckbox = new Button(group, 32);
        this.fIsRegExCheckbox.setText(SearchMessages.SearchPage_regularExpression);
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.fIsRegExCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchPage.this.fIsRegExSearch = TextSearchPage.this.fIsRegExCheckbox.getSelection();
                TextSearchPage.this.updateOKStatus();
                TextSearchPage.this.writeConfiguration();
                TextSearchPage.this.fPatterFieldContentAssist.setEnabled(TextSearchPage.this.fIsRegExSearch);
            }
        });
        this.fIsRegExCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsRegExCheckbox.setFont(group.getFont());
    }

    private void handleWidgetSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData patternData = (SearchPatternData)this.fPreviousSearchPatterns.get(selectionIndex);
        if (!this.fPattern.getText().equals(patternData.textPattern)) {
            return;
        }
        this.fIsCaseSensitiveCheckbox.setSelection(patternData.isCaseSensitive);
        this.fIsRegExSearch = patternData.isRegExSearch;
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.fPattern.setText(patternData.textPattern);
        this.fPatterFieldContentAssist.setEnabled(this.fIsRegExSearch);
        this.fFileTypeEditor.setFileTypes(patternData.fileNamePatterns);
        if (patternData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(patternData.workingSets);
        } else {
            this.getContainer().setSelectedScope(patternData.scope);
        }
    }

    private boolean initializePatternControl() {
        String text;
        ISelection selection = this.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && (text = ((ITextSelection)selection).getText()) != null) {
            if (this.fIsRegExSearch) {
                this.fPattern.setText(FindReplaceDocumentAdapter.escapeForRegExPattern((String)text));
            } else {
                this.fPattern.setText(this.insertEscapeChars(text));
            }
            if (this.fPreviousExtensions.length > 0) {
                this.fExtensions.setText(this.fPreviousExtensions[0]);
            } else {
                String extension = this.getExtensionFromEditor();
                if (extension != null) {
                    this.fExtensions.setText(extension);
                } else {
                    this.fExtensions.setText("*");
                }
            }
            return true;
        }
        return false;
    }

    private String insertEscapeChars(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        StringBuffer sbIn = new StringBuffer(text);
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int lengthOfFirstLine = 0;
        try {
            lengthOfFirstLine = reader.readLine().length();
        }
        catch (IOException iOException) {
            return "";
        }
        StringBuffer sbOut = new StringBuffer(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = sbIn.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append("\\");
            }
            sbOut.append(ch);
            ++i;
        }
        return sbOut.toString();
    }

    private String getExtensionFromEditor() {
        IEditorInput elem;
        IEditorPart ep = SearchPlugin.getActivePage().getActiveEditor();
        if (ep != null && (elem = ep.getEditorInput()) instanceof IFileEditorInput) {
            String extension = ((IFileEditorInput)elem).getFile().getFileExtension();
            if (extension == null) {
                return ((IFileEditorInput)elem).getFile().getName();
            }
            return "*." + extension;
        }
        return null;
    }

    private void addFileNameControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.SearchPage_fileNamePatterns_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fExtensions = new Combo(group, 2052);
        this.fExtensions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextSearchPage.this.updateOKStatus();
            }
        });
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fExtensions.setLayoutData((Object)data);
        this.fExtensions.setFont(group.getFont());
        Button button = new Button(group, 8);
        button.setText(SearchMessages.SearchPage_browse);
        GridData gridData = new GridData(1, 0x1000000, false, false, 1, 1);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        button.setFont(group.getFont());
        this.fFileTypeEditor = new FileTypeEditor(this.fExtensions, button);
        Label description = new Label(group, 16384);
        description.setText(SearchMessages.SearchPage_fileNamePatterns_hint);
        description.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        description.setFont(group.getFont());
        this.fSearchDerivedCheckbox = new Button(group, 32);
        this.fSearchDerivedCheckbox.setText(SearchMessages.TextSearchPage_searchDerived_label);
        this.fSearchDerivedCheckbox.setSelection(this.fSearchDerived);
        this.fSearchDerivedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchPage.this.fSearchDerived = TextSearchPage.this.fSearchDerivedCheckbox.getSelection();
                TextSearchPage.this.writeConfiguration();
            }
        });
        this.fSearchDerivedCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.fSearchDerivedCheckbox.setFont(group.getFont());
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private ISelection getSelection() {
        return this.fContainer.getSelection();
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection(PAGE_NAME);
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        this.fIsRegExSearch = s.getBoolean(STORE_IS_REG_EX_SEARCH);
        this.fSearchDerived = s.getBoolean(STORE_SEARCH_DERIVED);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        LinkedHashSet<String> previousExtensions = new LinkedHashSet<String>(12);
        IDialogSettings extensionsSettings = s.getSection(STORE_EXTENSIONS);
        if (extensionsSettings != null) {
            int i = 0;
            while (i < 12) {
                String extension = extensionsSettings.get(Integer.toString(i));
                if (extension == null) break;
                previousExtensions.add(extension);
                ++i;
            }
            this.fPreviousExtensions = new String[previousExtensions.size()];
            previousExtensions.toArray(this.fPreviousExtensions);
        } else {
            this.fPreviousExtensions = this.getPreviousExtensionsOldStyle();
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        s.put(STORE_IS_REG_EX_SEARCH, this.fIsRegExSearch);
        s.put(STORE_SEARCH_DERIVED, this.fSearchDerived);
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
        IDialogSettings extensionsSettings = s.addNewSection(STORE_EXTENSIONS);
        extensionsSettings.put(Integer.toString(0), this.fExtensions.getText());
        HashSet<String> extensions = new HashSet<String>(12);
        extensions.add(this.fExtensions.getText());
        int length = Math.min(this.fExtensions.getItemCount(), 11);
        int j = 1;
        int i2 = 0;
        while (i2 < length) {
            String extension = this.fExtensions.getItem(i2);
            if (extensions.add(extension)) {
                extensionsSettings.put(Integer.toString(j++), extension);
            }
            ++i2;
        }
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
    }

    private static class SearchPatternData {
        public final boolean isCaseSensitive;
        public final boolean isRegExSearch;
        public final String textPattern;
        public final String[] fileNamePatterns;
        public final int scope;
        public final IWorkingSet[] workingSets;

        public SearchPatternData(String textPattern, boolean isCaseSensitive, boolean isRegExSearch, String[] fileNamePatterns, int scope, IWorkingSet[] workingSets) {
            Assert.isNotNull((Object)fileNamePatterns);
            this.isCaseSensitive = isCaseSensitive;
            this.isRegExSearch = isRegExSearch;
            this.textPattern = textPattern;
            this.fileNamePatterns = fileNamePatterns;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public void store(IDialogSettings settings) {
            settings.put("ignoreCase", !this.isCaseSensitive);
            settings.put("isRegExSearch", this.isRegExSearch);
            settings.put("textPattern", this.textPattern);
            settings.put("fileNamePatterns", this.fileNamePatterns);
            settings.put("scope", this.scope);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getLabel();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }

        public static SearchPatternData create(IDialogSettings settings) {
            String[] fileNamePatterns;
            String textPattern = settings.get("textPattern");
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            if ((fileNamePatterns = settings.getArray("fileNamePatterns")) == null) {
                fileNamePatterns = new String[]{};
            }
            try {
                int scope = settings.getInt("scope");
                boolean isRegExSearch = settings.getBoolean("isRegExSearch");
                boolean ignoreCase = settings.getBoolean("ignoreCase");
                return new SearchPatternData(textPattern, !ignoreCase, isRegExSearch, fileNamePatterns, scope, workingSets);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static class TextSearchPageInput
    extends TextSearchQueryProvider.TextSearchInput {
        private final String fSearchText;
        private final boolean fIsCaseSensitive;
        private final boolean fIsRegEx;
        private final FileTextSearchScope fScope;

        public TextSearchPageInput(String searchText, boolean isCaseSensitive, boolean isRegEx, FileTextSearchScope scope) {
            this.fSearchText = searchText;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fIsRegEx = isRegEx;
            this.fScope = scope;
        }

        public String getSearchText() {
            return this.fSearchText;
        }

        public boolean isCaseSensitiveSearch() {
            return this.fIsCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.fIsRegEx;
        }

        public FileTextSearchScope getScope() {
            return this.fScope;
        }
    }
}

