/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.rhino.transport.Packet;

public class Request
extends Packet {
    private final String command;
    private final Map arguments = Collections.synchronizedMap(new HashMap());

    public Request(String command) {
        super("request");
        if (command == null) {
            throw new NullPointerException();
        }
        this.command = command.intern();
    }

    public Request(Map json) {
        super(json);
        if (json == null) {
            throw new NullPointerException();
        }
        String packetCommand = (String)json.get("command");
        this.command = packetCommand.intern();
        Map packetArguments = (Map)json.get("arguments");
        this.arguments.putAll(packetArguments);
    }

    public String getCommand() {
        return this.command;
    }

    public Map getArguments() {
        return this.arguments;
    }

    public void setArgument(String key, Object argument) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (argument == null) {
            throw new NullPointerException();
        }
        this.arguments.put(key, argument);
    }

    public Map toJSON() {
        Map json = super.toJSON();
        json.put("command", this.command);
        json.put("arguments", this.arguments);
        return json;
    }
}

