/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.transport;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.rhino.transport.Connection;
import org.eclipse.wst.jsdt.debug.rhino.transport.Packet;
import org.eclipse.wst.jsdt.debug.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.rhino.transport.SocketConnection;
import org.eclipse.wst.jsdt.debug.rhino.transport.TransportService;

public class SocketTransportService
implements TransportService {
    static final Class serverSocketClass;
    Map listeners = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.net.ServerSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serverSocketClass = clazz;
    }

    public synchronized TransportService.ListenerKey startListening(String address) throws IOException {
        String host = null;
        int port = 0;
        if (address != null) {
            String[] strings = address.split(":");
            if (strings.length == 2) {
                host = strings[0];
                port = Integer.parseInt(strings[1]);
            } else {
                port = Integer.parseInt(strings[0]);
            }
        }
        if (host == null) {
            host = "localhost";
        }
        if (!host.equals("localhost")) {
            throw new IllegalArgumentException("Only localhost is supported.");
        }
        SocketListenerKey key = new SocketListenerKey(String.valueOf(host) + ":" + port);
        ServerSocket serverSocket = new ServerSocket(port);
        this.listeners.put(key, serverSocket);
        return key;
    }

    public void stopListening(TransportService.ListenerKey key) throws IOException {
        ServerSocket serverSocket = (ServerSocket)this.listeners.remove(key);
        if (serverSocket != null) {
            serverSocket.close();
        }
    }

    public Connection accept(TransportService.ListenerKey key, long attachTimeout, long handshakeTimeout) throws IOException {
        SocketConnection connection;
        Packet packet;
        ServerSocket serverSocket = (ServerSocket)this.listeners.get(key);
        if (serverSocket == null) {
            throw new IllegalStateException("Accept failed. Not listening for address: key.address()");
        }
        if (attachTimeout > 0L) {
            if (attachTimeout > Integer.MAX_VALUE) {
                attachTimeout = Integer.MAX_VALUE;
            }
            serverSocket.setSoTimeout((int)attachTimeout);
        }
        if (!((packet = (connection = new SocketConnection(serverSocket.accept())).readPacket()) instanceof Request)) {
            throw new IOException("failure establishing_connection");
        }
        Request request = (Request)packet;
        if (!request.getCommand().equals("connect")) {
            throw new IOException("failure establishing connection");
        }
        Response response = new Response(request.getSequence(), request.getCommand());
        connection.writePacket(response);
        return connection;
    }

    public Connection attach(String address, long attachTimeout, long handshakeTimeout) throws IOException {
        String host = null;
        int port = 0;
        if (address != null) {
            String[] strings = address.split(":");
            if (strings.length == 2) {
                host = strings[0];
                port = Integer.parseInt(strings[1]);
            } else {
                port = Integer.parseInt(strings[0]);
            }
        }
        if (host == null) {
            host = "localhost";
        }
        SocketConnection connection = new SocketConnection(new Socket(host, port));
        Request request = new Request("connect");
        connection.writePacket(request);
        Packet packet = connection.readPacket();
        if (!(packet instanceof Response)) {
            throw new IOException("failure establishing connection");
        }
        Response response = (Response)packet;
        if (!(response.getCommand().equals("connect") && response.getRequestSequence() == request.getSequence() && response.isSuccess() && response.isRunning())) {
            throw new IOException("failure establishing connection");
        }
        return connection;
    }

    public static class SocketListenerKey
    implements TransportService.ListenerKey {
        private String address;

        public SocketListenerKey(String address) {
            this.address = address;
        }

        public String address() {
            return this.address;
        }
    }
}

