/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.semantic.ISemanticFileStoreInternal;
import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.internal.resources.semantic.SemanticFileInfo;
import org.eclipse.core.internal.resources.semantic.SemanticFileSystem;
import org.eclipse.core.internal.resources.semantic.SemanticFileSystemCore;
import org.eclipse.core.internal.resources.semantic.SemanticProperties;
import org.eclipse.core.internal.resources.semantic.SemanticResourceInfo;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.internal.resources.semantic.Util;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.ResourceTreeNode;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticResourceDBFactory;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeNodeType;
import org.eclipse.core.internal.resources.semantic.util.ISemanticFileSystemLog;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderFederation;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderLocal;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderLocking;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderREST;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderRemote;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticFileStore
extends SemanticProperties
implements ISemanticFileStore,
ISemanticFileStoreInternal {
    private static final String DEFAULT_CONTENT_PROVIDER_ID = "org.eclipse.core.resources.semantic.provider.DefaultContentProvider";
    private static final String ATTRIBUTE_URI_STRING = Util.qualifiedNameToString(SemanticFileSystem.ATTRIBUTE_URI);
    private final ISemanticFileSystemLog log;
    private ISemanticContentProvider provider;

    SemanticFileStore(SemanticFileSystem fs, ResourceTreeNode node) {
        super(fs, node);
        this.log = fs.getLog();
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        try {
            this.fs.lockForRead();
            EList<ResourceTreeNode> children = this.node.getChildren();
            int counter = 0;
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.isExists()) continue;
                ++counter;
            }
            String[] names = new String[counter];
            int i = 0;
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.isExists()) continue;
                names[i] = resourceTreeNode.getName();
                ++i;
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        SemanticFileInfo info;
        block15: {
            ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
            boolean askContentProviderForReadonly = false;
            boolean askContentProviderForTimestamp = false;
            try {
                this.fs.lockForRead();
                info = new SemanticFileInfo();
                info.setName(this.node.getName());
                info.setExists(this.node.isExists());
                TreeNodeType actType = this.node.getType();
                info.setDirectory(actType.equals((Object)TreeNodeType.FOLDER) || actType.equals((Object)TreeNodeType.PROJECT));
                if (info.isDirectory() || !this.node.isExists() || actType.equals((Object)TreeNodeType.UNKNOWN)) {
                    info.setLastModified(0L);
                    info.setAttribute(2, false);
                } else {
                    askContentProviderForTimestamp = true;
                    if (!this.node.isLocalOnly()) {
                        askContentProviderForReadonly = true;
                    } else {
                        info.setAttribute(2, false);
                    }
                }
            }
            finally {
                this.fs.unlockForRead();
            }
            if (askContentProviderForReadonly) {
                boolean readOnly;
                block14: {
                    readOnly = true;
                    try {
                        readOnly = effectiveProvider.fetchResourceInfo(this, 16, monitor).isReadOnly();
                    }
                    catch (CoreException e) {
                        if (!SfsTraceLocation.CONTENTPROVIDER.isActive()) break block14;
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), e.getMessage(), (Throwable)e);
                    }
                }
                info.setAttribute(2, readOnly);
            }
            if (askContentProviderForTimestamp) {
                try {
                    info.setLastModified(effectiveProvider.getResourceTimestamp(this, monitor));
                }
                catch (CoreException e) {
                    info.setLastModified(0L);
                    if (!SfsTraceLocation.CONTENTPROVIDER.isActive()) break block15;
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), e.getMessage(), (Throwable)e);
                }
            }
        }
        return info;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_UpdateFileInfo_XMSG, (Object)this.getPath().toString()));
        }
        this.checkAccessible();
        if ((options & 0x400) != 0) {
            this.getEffectiveContentProvider().setReadOnly(this, info.getAttribute(2), monitor);
        }
        if ((options & 0x800) != 0) {
            long timestamp = info.getLastModified();
            this.getEffectiveContentProvider().setResourceTimestamp(this, timestamp, monitor);
        }
    }

    private static ISemanticContentProvider initProvider(String contentProviderID, ISemanticFileStore store) throws CoreException {
        ISemanticContentProvider actProvider = SemanticFileSystemCore.getInstance().getContentProviderFactory(contentProviderID).createContentProvider();
        actProvider.setRootStore(store);
        ((SemanticFileStore)store).setProvider(actProvider);
        return actProvider;
    }

    @Override
    public ISemanticContentProvider getEffectiveContentProvider() throws CoreException {
        String parentContentProviderId = null;
        try {
            this.fs.lockForWrite();
            if (this.provider != null) {
                ISemanticContentProvider iSemanticContentProvider = this.provider;
                return iSemanticContentProvider;
            }
            String contentProviderID = this.node.getTemplateID();
            if (contentProviderID == null) {
                ISemanticContentProvider parentProvider;
                ResourceTreeNode parent = this.node.getParent();
                ResourceTreeNode oldParent = this.node;
                while (parent != null) {
                    parentContentProviderId = parent.getTemplateID();
                    if (parentContentProviderId != null) break;
                    oldParent = parent;
                    parent = parent.getParent();
                }
                if (parentContentProviderId == null) {
                    parentContentProviderId = DEFAULT_CONTENT_PROVIDER_ID;
                    parent = oldParent;
                }
                SemanticFileStore parentStore = this.fs.getStore(parent);
                ISemanticContentProvider iSemanticContentProvider = parentProvider = SemanticFileStore.initProvider(parentContentProviderId, parentStore);
                return iSemanticContentProvider;
            }
            SemanticFileStore.initProvider(contentProviderID, this);
            if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)contentProviderID);
            }
            ISemanticContentProvider iSemanticContentProvider = this.provider;
            return iSemanticContentProvider;
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        if (options != 4096 && this.node.isExists()) {
            ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
            if (effectiveProvider instanceof ISemanticContentProviderLocal) {
                return ((ISemanticContentProviderLocal)((Object)effectiveProvider)).toLocalFile(this);
            }
            return null;
        }
        return super.toLocalFile(options, monitor);
    }

    public IFileStore getChild(String name) {
        SemanticFileStore result;
        block15: {
            ISemanticContentProvider effectiveProvider;
            SemanticFileStore store = this.findChild(name);
            if (store != null) {
                return store;
            }
            try {
                effectiveProvider = this.getEffectiveContentProvider();
            }
            catch (CoreException ce) {
                this.log.log(ce);
                return EFS.getNullFileSystem().getStore(this.getPath().append(name));
            }
            String federatedContentProviderId = null;
            if (effectiveProvider instanceof ISemanticContentProviderFederation) {
                federatedContentProviderId = ((ISemanticContentProviderFederation)((Object)effectiveProvider)).getFederatedProviderIDForPath(this.getPath().append(name));
            }
            try {
                try {
                    this.fs.lockForWrite();
                    ResourceTreeNode child = this.checkChildExists(name);
                    ResourceTreeNode newnode = this.createLocalChildNode(name, child, federatedContentProviderId);
                    result = this.fs.getStore(newnode);
                    this.fs.requestFlush(false);
                }
                catch (CoreException e) {
                    if (SfsTraceLocation.CORE.isActive()) {
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), e.getMessage(), (Throwable)e);
                    }
                    IFileStore iFileStore = EFS.getNullFileSystem().getStore(this.getPath().append(name));
                    this.fs.unlockForWrite();
                    return iFileStore;
                }
            }
            finally {
                this.fs.unlockForWrite();
            }
            if (result != null) {
                effectiveProvider.onImplicitStoreCreate(result);
                if (federatedContentProviderId != null) {
                    try {
                        result.getEffectiveContentProvider().onImplicitStoreCreate(result);
                    }
                    catch (CoreException e) {
                        if (!SfsTraceLocation.CONTENTPROVIDER.isActive()) break block15;
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public String getName() {
        try {
            this.fs.lockForRead();
            String string = this.node.getName();
            return string;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    public IFileStore getParent() {
        try {
            this.fs.lockForRead();
            if (this.node.getParent() != null) {
                SemanticFileStore semanticFileStore = this.fs.getStore(this.node.getParent());
                return semanticFileStore;
            }
            return null;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.checkAccessible();
        try {
            this.fs.lockForRead();
            TreeNodeType type = this.node.getType();
            if (type != TreeNodeType.FILE) {
                throw new SemanticResourceException(SemanticResourceStatusCode.INVALID_RESOURCE_TYPE, this.getPath(), Messages.SemanticFileStore_OpenInputOnlyOnFiles_XMSG);
            }
        }
        finally {
            this.fs.unlockForRead();
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_OpeningInputInfo_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()));
        }
        return effectiveProvider.openInputStream(this, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        OutputStream os;
        block14: {
            IStatus status;
            ISemanticSpiResourceInfo info;
            boolean append;
            if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
            }
            try {
                this.fs.lockForRead();
                TreeNodeType type = this.node.getType();
                if (type != TreeNodeType.FILE && type != TreeNodeType.UNKNOWN) {
                    throw new SemanticResourceException(SemanticResourceStatusCode.INVALID_RESOURCE_TYPE, this.getPath(), Messages.SemanticFileStore_OpenOutputNotOnFolders_XMSG);
                }
            }
            finally {
                this.fs.unlockForRead();
            }
            ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
            boolean bl = append = (options & 1) != 0;
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                String message = append ? NLS.bind((String)Messages.SemanticFileStore_AppendingInfo_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()) : NLS.bind((String)Messages.SemanticFileStore_OpeningInfo_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString());
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), message);
            }
            if ((info = effectiveProvider.fetchResourceInfo(this, 16, monitor)).isReadOnly() && !(status = effectiveProvider.validateSave(this)).isOK()) {
                throw new CoreException(status);
            }
            int actOptions = 0;
            if (append) {
                actOptions = 1;
            }
            os = effectiveProvider.openOutputStream(this, actOptions, monitor);
            try {
                boolean changeRequired;
                this.fs.lockForWrite();
                boolean bl2 = changeRequired = !this.node.isExists() || this.node.getType() != TreeNodeType.FILE;
                if (!changeRequired) break block14;
                this.node.setExists(true);
                this.node.setType(TreeNodeType.FILE);
                try {
                    this.fs.requestFlush(false);
                }
                catch (CoreException e) {
                    Util.safeClose(os);
                    throw e;
                }
            }
            finally {
                this.fs.unlockForWrite();
            }
        }
        return os;
    }

    public URI toURI() {
        try {
            this.fs.lockForRead();
            try {
                URI uRI = new URI("semanticfs", null, this.getPath().toString(), null);
                return uRI;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    public SemanticFileSystem getFileSystem() {
        return this.fs;
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE_VERBOSE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_MkDir_XMSG, (Object)this.getPath().toString()));
        }
        try {
            this.fs.lockForWrite();
            ResourceTreeNode parent = this.node.getParent();
            if ((options & 4) != 0) {
                if (parent != null && !parent.isExists()) {
                    throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_PARENT_DOESNT_EXIST, this.getPath(), Messages.SemanticFileStore_ShallowMkDirFailed_XMSG);
                }
            } else if (parent != null && !parent.isExists()) {
                SemanticFileStore.mkdir(parent);
            }
            SemanticFileStore.makeFolder(this.node);
        }
        finally {
            this.fs.unlockForWrite();
        }
        return this;
    }

    private static void mkdir(ResourceTreeNode actNode) throws CoreException {
        ResourceTreeNode parent = actNode.getParent();
        if (parent != null && !parent.isExists()) {
            SemanticFileStore.mkdir(parent);
        }
        SemanticFileStore.makeFolder(actNode);
    }

    private static void makeFolder(ResourceTreeNode actNode) throws CoreException {
        if (actNode.getType() == TreeNodeType.FILE) {
            SemanticFileSystem fs = (SemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, fs.getStore(actNode).getPath(), Messages.SemanticFileStore_MkDirOnFile_XMSG);
        }
        if (!actNode.isExists()) {
            actNode.setExists(true);
        }
        if (actNode.getType() != TreeNodeType.PROJECT) {
            actNode.setType(TreeNodeType.FOLDER);
        }
    }

    @Override
    public void createFileRemotely(String name, InputStream source, Object context, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_CreateFileRemote_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        if (!(effectiveProvider instanceof ISemanticContentProviderRemote)) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
        }
        ((ISemanticContentProviderRemote)((Object)effectiveProvider)).createFileRemotely(this, name, source, context, monitor);
    }

    @Override
    public ISemanticFileStoreInternal createResourceRemotely(String name, Object context, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_CreateResourceRemtoe_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        if (!(effectiveProvider instanceof ISemanticContentProviderRemote)) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
        }
        ((ISemanticContentProviderRemote)((Object)effectiveProvider)).createResourceRemotely(this, name, context, monitor);
        return this.findChild(name);
    }

    @Override
    public void addFileFromRemote(String name, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddFileRemote_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        effectiveProvider.addResource(this, name, ISemanticFileStore.ResourceType.FILE_TYPE, monitor);
    }

    @Override
    public void addFileFromRemoteByURI(String name, URI uri, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (effectiveProvider instanceof ISemanticContentProviderREST) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddFileRemoteURI_XMSG, name, uri.toString(), effectiveProvider.getClass().getName(), this.getPath().toString()));
            }
        } else {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
        }
        ((ISemanticContentProviderREST)((Object)effectiveProvider)).addFileFromRemoteByURI(this, name, uri, monitor);
    }

    @Override
    public void addFolderFromRemoteByURI(String name, URI uri, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (effectiveProvider instanceof ISemanticContentProviderREST) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddFileRemoteURI_XMSG, name, uri.toString(), effectiveProvider.getClass().getName(), this.getPath().toString()));
            }
        } else {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
        }
        ((ISemanticContentProviderREST)((Object)effectiveProvider)).addFolderFromRemoteByURI(this, name, uri, monitor);
    }

    @Override
    public void addFolderFromRemote(String name, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddFolderRemote_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        effectiveProvider.addResource(this, name, ISemanticFileStore.ResourceType.FOLDER_TYPE, monitor);
    }

    @Override
    public ISemanticFileStoreInternal addResourceFromRemote(String name, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddResourceRemote_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        effectiveProvider.addResource(this, name, ISemanticFileStore.ResourceType.UNKNOWN_TYPE, monitor);
        return this.findChild(name);
    }

    @Override
    public void addResource(String name, boolean asFolder, String contentProviderID, Map<QualifiedName, String> properties, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (!(effectiveProvider instanceof ISemanticContentProviderFederation)) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderFederation.class.getName()));
        }
        ((ISemanticContentProviderFederation)((Object)effectiveProvider)).addResource(this, name, asFolder ? ISemanticFileStore.ResourceType.FOLDER_TYPE : ISemanticFileStore.ResourceType.FILE_TYPE, contentProviderID, properties);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.removeFromWorkspace(monitor);
    }

    @Override
    public void deleteRemotely(IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_DeleteResourceRemote_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        if (!(effectiveProvider instanceof ISemanticContentProviderRemote)) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
        }
        ((ISemanticContentProviderRemote)((Object)effectiveProvider)).deleteRemotely(this, monitor);
    }

    @Override
    public void removeFromWorkspace(IProgressMonitor monitor) throws CoreException {
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_RemoveResourceRemote_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        effectiveProvider.removeResource(this, monitor);
    }

    @Override
    public void synchronizeContentWithRemote(SyncDirection direction, IProgressMonitor monitor) throws CoreException {
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_SynchContent_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()));
        }
        this.checkAccessible();
        MultiStatus status = new MultiStatus("org.eclipse.core.resources.semantic", 0, NLS.bind((String)Messages.SemanticFileStore_SyncContent_XGRP, (Object)this.getPath().toString()), null);
        effectiveProvider.synchronizeContentWithRemote(this, direction, monitor, status);
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public void setRemoteURI(URI uri, IProgressMonitor monitor) throws CoreException {
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.checkAccessible();
        if (effectiveProvider instanceof ISemanticContentProviderREST) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_SettingURI_XMSG, uri.toString(), effectiveProvider.getClass().getName(), this.getPath().toString()));
            }
        } else {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
        }
        ((ISemanticContentProviderREST)((Object)effectiveProvider)).setURIString(this, uri, monitor);
    }

    @Override
    public void revertChanges(IProgressMonitor monitor) throws CoreException {
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_Revert_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        this.checkAccessible();
        effectiveProvider.revertChanges(this, monitor);
    }

    @Override
    public IStatus lockResource(IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_Locking_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        this.checkAccessible();
        if (effectiveProvider instanceof ISemanticContentProviderLocking) {
            return ((ISemanticContentProviderLocking)((Object)effectiveProvider)).lockResource(this, monitor);
        }
        return new Status(4, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderLocking.class.getName()));
    }

    @Override
    public IStatus unlockResource(IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_Unlocking_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        this.checkAccessible();
        if (effectiveProvider instanceof ISemanticContentProviderLocking) {
            return ((ISemanticContentProviderLocking)((Object)effectiveProvider)).unlockResource(this, monitor);
        }
        return new Status(4, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderLocking.class.getName()));
    }

    @Override
    public IStatus validateRemoteCreate(String name, Object shell) {
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            this.checkAccessible();
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException ce) {
            this.log.log(ce);
            return ce.getStatus();
        }
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_ValidateRemoteCreate_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        if (effectiveProvider instanceof ISemanticContentProviderRemote) {
            return ((ISemanticContentProviderRemote)((Object)effectiveProvider)).validateRemoteCreate(this, name, shell);
        }
        return new Status(4, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
    }

    @Override
    public IStatus validateRemoteDelete(Object shell) {
        boolean canBeDeleted;
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            this.checkAccessible();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        try {
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException e) {
            this.log.log(e);
            return e.getStatus();
        }
        try {
            this.fs.lockForRead();
            canBeDeleted = this.node.isExists();
        }
        finally {
            this.fs.unlockForRead();
        }
        if (canBeDeleted) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_ValidateRemoteDelete_XMSG, this.getPath().toString(), effectiveProvider.getClass().getName()));
            }
            if (effectiveProvider instanceof ISemanticContentProviderRemote) {
                return ((ISemanticContentProviderRemote)((Object)effectiveProvider)).validateRemoteDelete(this, shell);
            }
            return new Status(4, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
        }
        return new Status(8, "org.eclipse.core.resources.semantic", null);
    }

    @Override
    public IStatus validateRemove(int options, IProgressMonitor monitor) {
        boolean canBeDeleted;
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException e) {
            this.log.log(e);
            return e.getStatus();
        }
        try {
            this.fs.lockForRead();
            canBeDeleted = this.node.isExists();
        }
        finally {
            this.fs.unlockForRead();
        }
        if (canBeDeleted) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_ValidateRemove_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
            }
            try {
                return effectiveProvider.validateRemove(this, options, monitor);
            }
            catch (CoreException e) {
                this.log.log(e);
                return e.getStatus();
            }
        }
        return new Status(8, "org.eclipse.core.resources.semantic", null);
    }

    @Override
    public void addChildFolder(String name) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_AddChildFolder_XMSG, (Object)name, (Object)this.getPath().toString()));
        }
        this.checkAccessible();
        try {
            this.fs.lockForWrite();
            ResourceTreeNode child = this.checkChildExists(name);
            this.createChildNode(name, true, child, null);
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public void addChildResource(String name, boolean asFolder, String contentProviderID, Map<QualifiedName, String> properties) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            String message = asFolder ? NLS.bind((String)Messages.SemanticFileStore_AddContentProviderRootFolder_XMSG, (Object)name, (Object)this.getPath().toString()) : NLS.bind((String)Messages.SemanticFileStore_AddContentProviderRootFile_XMSG, (Object)name, (Object)this.getPath().toString());
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), message);
        }
        this.checkAccessible();
        try {
            this.fs.lockForWrite();
            ResourceTreeNode oldchild = this.checkChildExists(name);
            ResourceTreeNode child = this.createChildNode(name, asFolder, oldchild, contentProviderID);
            HashMap<String, String> propsMap = new HashMap<String, String>();
            if (properties != null && !properties.isEmpty()) {
                for (Map.Entry<QualifiedName, String> entry : properties.entrySet()) {
                    propsMap.put(Util.qualifiedNameToString(entry.getKey()), entry.getValue());
                }
                child.setPersistentProperties(propsMap);
            } else {
                child.setPersistentProperties(null);
            }
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public void addChildFile(String name) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_AddChildFile_XMSG, (Object)name, (Object)this.getPath().toString()));
        }
        this.checkAccessible();
        try {
            this.fs.lockForWrite();
            ResourceTreeNode child = this.checkChildExists(name);
            this.createChildNode(name, false, child, null);
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public void addLocalChildResource(String name, String contentProviderID) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_AddLocalChild_XMSG, (Object)name, (Object)this.getPath().toString()));
        }
        this.checkAccessible();
        try {
            this.fs.lockForWrite();
            ResourceTreeNode child = this.checkChildExists(name);
            this.createLocalChildNode(name, child, contentProviderID);
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public boolean hasResource(String name) {
        try {
            this.fs.lockForRead();
            EList<ResourceTreeNode> children = this.node.getChildren();
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.getName().equals(name)) continue;
                boolean bl = resourceTreeNode.isExists();
                return bl;
            }
            return false;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public String getContentProviderID() {
        try {
            this.fs.lockForRead();
            String string = this.node.getTemplateID();
            return string;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public String getRemoteURIString() throws CoreException {
        this.checkAccessible();
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (effectiveProvider instanceof ISemanticContentProviderREST) {
            return ((ISemanticContentProviderREST)((Object)effectiveProvider)).getURIString(this);
        }
        throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
    }

    @Override
    public boolean isExists() {
        try {
            this.fs.lockForRead();
            boolean bl = this.node.isExists();
            return bl;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public boolean isLocalOnly() {
        try {
            this.fs.lockForRead();
            boolean bl = this.node.isLocalOnly();
            return bl;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    private SemanticFileStore findChild(String name) {
        try {
            this.fs.lockForRead();
            EList<ResourceTreeNode> children = this.node.getChildren();
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.getName().equals(name)) continue;
                SemanticFileStore semanticFileStore = this.fs.getStore(resourceTreeNode);
                return semanticFileStore;
            }
        }
        finally {
            this.fs.unlockForRead();
        }
        return null;
    }

    private ResourceTreeNode createChildNode(String name, boolean isFolder, ResourceTreeNode previous, String contentProviderID) {
        ResourceTreeNode child = previous != null ? previous : SemanticResourceDBFactory.eINSTANCE.createResourceTreeNode();
        child.setName(name);
        child.setTemplateID(contentProviderID);
        if (isFolder) {
            child.setType(TreeNodeType.FOLDER);
            child.setLocalOnly(true);
        } else {
            child.setType(TreeNodeType.FILE);
            child.setLocalOnly(false);
        }
        child.setExists(true);
        child.setParent(this.node);
        return child;
    }

    private ResourceTreeNode createLocalChildNode(String name, ResourceTreeNode previous, String contentProviderID) {
        ResourceTreeNode child = previous != null ? previous : SemanticResourceDBFactory.eINSTANCE.createResourceTreeNode();
        child.setName(name);
        child.setTemplateID(contentProviderID);
        child.setType(TreeNodeType.UNKNOWN);
        child.setExists(false);
        child.setParent(this.node);
        child.setLocalOnly(true);
        return child;
    }

    private ResourceTreeNode checkChildExists(String name) throws CoreException {
        EList<ResourceTreeNode> children = this.node.getChildren();
        for (ResourceTreeNode resourceTreeNode : children) {
            if (!resourceTreeNode.getName().equals(name)) continue;
            if (resourceTreeNode.isExists()) {
                IPath newPath = this.getPath().append(name);
                throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_ALREADY_EXISTS, newPath, NLS.bind((String)Messages.SemanticFileStore_ResourceWithPathExists_XMSG, (Object)newPath.toString()));
            }
            return resourceTreeNode;
        }
        return null;
    }

    private void removeChild(String name) throws CoreException {
        try {
            this.fs.lockForWrite();
            EList<ResourceTreeNode> children = this.node.getChildren();
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.getName().equals(name)) continue;
                children.remove((Object)resourceTreeNode);
                this.cleanupNode(resourceTreeNode);
                this.fs.requestURILocatorRebuild();
                break;
            }
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    private void cleanupNode(ResourceTreeNode resourceTreeNode) throws CoreException {
        resourceTreeNode.setExists(false);
        resourceTreeNode.setPersistentProperties(null);
        resourceTreeNode.setSessionProperties(null);
        boolean checkChildren = false;
        if (checkChildren) {
            EList<ResourceTreeNode> children = resourceTreeNode.getChildren();
            for (ResourceTreeNode resourceTreeNode2 : children) {
                if (!resourceTreeNode2.isExists()) continue;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic", "children not empty"));
            }
        }
    }

    @Override
    public IStatus validateEdit(Object shell) {
        boolean canBeEdited;
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException e) {
            this.log.log(e);
            return e.getStatus();
        }
        try {
            this.fs.lockForRead();
            canBeEdited = this.node.isExists() && this.node.getType().equals((Object)TreeNodeType.FILE);
        }
        finally {
            this.fs.unlockForRead();
        }
        if (canBeEdited) {
            boolean readOnly;
            try {
                readOnly = effectiveProvider.fetchResourceInfo(this, 16, null).isReadOnly();
            }
            catch (CoreException e) {
                this.log.log(e);
                return e.getStatus();
            }
            if (readOnly) {
                if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_ValidateEdit_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()));
                }
                return effectiveProvider.validateEdit(new ISemanticFileStore[]{this}, shell);
            }
            return new Status(0, "org.eclipse.core.resources.semantic", null);
        }
        return new Status(8, "org.eclipse.core.resources.semantic", null);
    }

    @Override
    public IStatus validateSave() {
        boolean canBeSaved;
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException e) {
            this.log.log(e);
            return e.getStatus();
        }
        try {
            this.fs.lockForRead();
            canBeSaved = this.node.isExists() && this.node.getType().equals((Object)TreeNodeType.FILE);
        }
        finally {
            this.fs.unlockForRead();
        }
        if (canBeSaved) {
            boolean readOnly;
            try {
                readOnly = effectiveProvider.fetchResourceInfo(this, 16, null).isReadOnly();
            }
            catch (CoreException e) {
                this.log.log(e);
                return e.getStatus();
            }
            if (!readOnly) {
                if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_ValidateSave_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()));
                }
                return effectiveProvider.validateSave(this);
            }
            return new Status(8, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_NotWritable_XMSG, (Object)this.getPath().toString()));
        }
        return new Status(8, "org.eclipse.core.resources.semantic", null);
    }

    @Override
    public IPath getPath() {
        try {
            this.fs.lockForRead();
            if (this.node.getPath() != null) {
                Path path = new Path(this.node.getPath());
                return path;
            }
            StringBuilder sb = new StringBuilder(50);
            sb.append('/');
            sb.append(this.node.getName());
            ResourceTreeNode parent = this.node.getParent();
            while (parent != null) {
                sb.insert(0, parent.getName());
                sb.insert(0, '/');
                parent = parent.getParent();
            }
            Path path = new Path(sb.toString());
            return path;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public void remove(IProgressMonitor monitor) throws CoreException {
        IFileStore parent;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_RemovingResource_XMSG, (Object)this.getPath().toString()));
        }
        if ((parent = this.getParent()) != null) {
            if (parent instanceof SemanticFileStore) {
                try {
                    this.fs.lockForWrite();
                    this.node.setPath(this.getPath().toString());
                }
                finally {
                    this.fs.unlockForWrite();
                }
                SemanticFileStore sparent = (SemanticFileStore)parent;
                sparent.removeChild(this.getName());
            }
        } else {
            try {
                this.fs.lockForWrite();
                this.node.getChildren().clear();
                this.cleanupNode(this.node);
                this.fs.requestFlush(false);
                this.fs.requestURILocatorRebuild();
            }
            finally {
                this.fs.unlockForWrite();
            }
        }
    }

    @Override
    public ISemanticResourceInfo fetchResourceInfo(int options, IProgressMonitor monitor) throws CoreException {
        ISemanticSpiResourceInfo providerInfo = this.getEffectiveContentProvider().fetchResourceInfo(this, options, monitor);
        return new SemanticResourceInfo(options, providerInfo, this.isLocalOnly());
    }

    @Override
    public int getType() {
        try {
            this.fs.lockForRead();
            int n = this.node.getType().getValue();
            return n;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public ISemanticFileStoreInternal getChildResource(String name) {
        return this.findChild(name);
    }

    public void setProvider(ISemanticContentProvider contentProvider) {
        this.provider = contentProvider;
    }

    @Override
    protected void notifyPersistentPropertySet(String keyString, String oldValue, String newValue) throws CoreException {
        if (keyString.equals(ATTRIBUTE_URI_STRING) && this.fs.getURILocator() != null && (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue))) {
            IPath path = this.getPath();
            if (oldValue != null) {
                this.fs.getURILocator().removeURI(path, oldValue);
            }
            if (newValue != null) {
                this.fs.getURILocator().addURI(path, newValue);
            }
        }
    }

    @Override
    public IPath[] findURI(URI uri, IProgressMonitor monitor) throws CoreException {
        return this.fs.getURILocatorService(monitor).locateURI(uri, this.getPath());
    }
}

