/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.operations.PlannerResolutionJob;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.IProfileChangeJob;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;

public abstract class ProfileChangeOperation
implements IProfileChangeJob {
    ProvisioningSession session;
    String profileId;
    ProvisioningContext context;
    MultiStatus noChangeRequest;
    PlannerResolutionJob job;
    ProfileChangeRequest request;

    protected ProfileChangeOperation(ProvisioningSession session) {
        this.session = session;
        this.profileId = "_SELF_";
        this.context = new ProvisioningContext(session.getProvisioningAgent());
    }

    public final IStatus resolveModal(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.prepareToResolve();
        this.makeResolveJob(monitor);
        if (this.job != null) {
            this.job.runModal(monitor);
        }
        return this.getResolutionResult();
    }

    public void setProfileId(String id) {
        this.profileId = id;
    }

    public final ProvisioningJob getResolveJob(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProfileChangeOperation_ResolveTaskName, (int)1000);
        this.prepareToResolve();
        this.makeResolveJob((IProgressMonitor)mon.newChild(100));
        this.job.setAdditionalProgressMonitor((IProgressMonitor)mon.newChild(900));
        return this.job;
    }

    protected void prepareToResolve() {
    }

    private void makeResolveJob(IProgressMonitor monitor) {
        this.noChangeRequest = PlanAnalyzer.getProfileChangeAlteredStatus();
        if (this.session.hasScheduledOperationsFor(this.profileId)) {
            this.noChangeRequest.add(PlanAnalyzer.getStatus(10052, null));
        } else {
            this.computeProfileChangeRequest(this.noChangeRequest, monitor);
        }
        if (this.request == null) {
            if (this.noChangeRequest.getChildren().length == 0) {
                this.noChangeRequest = new MultiStatus("org.eclipse.equinox.p2.operations", 10050, new IStatus[]{PlanAnalyzer.getStatus(10050, null)}, Messages.ProfileChangeOperation_NoProfileChangeRequest, null);
            }
            return;
        }
        this.createPlannerResolutionJob();
    }

    protected abstract void computeProfileChangeRequest(MultiStatus var1, IProgressMonitor var2);

    private void createPlannerResolutionJob() {
        this.job = new PlannerResolutionJob(this.getResolveJobName(), this.session, this.profileId, this.request, this.context, this.noChangeRequest);
    }

    protected abstract String getResolveJobName();

    protected abstract String getProvisioningJobName();

    public IStatus getResolutionResult() {
        if (this.job != null && this.job.getResolutionResult() != null) {
            return this.job.getResolutionResult().getSummaryStatus();
        }
        if (this.request == null && this.noChangeRequest != null) {
            if (this.noChangeRequest.getChildren().length == 1) {
                return this.noChangeRequest.getChildren()[0];
            }
            return this.noChangeRequest;
        }
        return null;
    }

    public String getResolutionDetails() {
        if (this.job != null && this.job.getResolutionResult() != null) {
            return this.job.getResolutionResult().getSummaryReport();
        }
        IStatus result = this.getResolutionResult();
        if (result != null) {
            return result.getMessage();
        }
        return null;
    }

    public String getResolutionDetails(IInstallableUnit iu) {
        if (this.job != null && this.job.getResolutionResult() != null) {
            return this.job.getResolutionResult().getDetailedReport(new IInstallableUnit[]{iu});
        }
        return null;
    }

    public IProvisioningPlan getProvisioningPlan() {
        if (this.job != null) {
            return this.job.getProvisioningPlan();
        }
        return null;
    }

    public ProfileChangeRequest getProfileChangeRequest() {
        if (this.job != null) {
            return this.job.getProfileChangeRequest();
        }
        return null;
    }

    public ProvisioningJob getProvisioningJob(IProgressMonitor monitor) {
        IStatus status = this.getResolutionResult();
        if (status.getSeverity() != 8 && status.getSeverity() != 4 && this.job.getProvisioningPlan() != null) {
            ProfileModificationJob pJob = new ProfileModificationJob(this.getProvisioningJobName(), this.session, this.profileId, this.job.getProvisioningPlan(), this.context);
            pJob.setAdditionalProgressMonitor(monitor);
            return pJob;
        }
        return null;
    }

    public void setProvisioningContext(ProvisioningContext context) {
        this.context = context;
        if (this.job != null) {
            this.job.setProvisioningContext(context);
        }
    }

    public ProvisioningContext getProvisioningContext() {
        return this.context;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public boolean hasResolved() {
        return this.getResolutionResult() != null;
    }
}

