/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractJavaEditorTextHover {
    private List fTextHoverSpecifications;
    private List fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart editor) {
        this();
        this.setEditor(editor);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList(2);
        this.fInstantiatedTextHovers = new ArrayList(2);
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (!"org.eclipse.jdt.ui.BestMatchHover".equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
            }
            ++i;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications == null) {
            return;
        }
        boolean done = true;
        int i = -1;
        Iterator iterator = this.fTextHoverSpecifications.iterator();
        while (iterator.hasNext()) {
            ++i;
            JavaEditorTextHoverDescriptor spec = (JavaEditorTextHoverDescriptor)iterator.next();
            if (spec == null) continue;
            done = false;
            IJavaEditorTextHover hover = spec.createTextHover();
            if (hover != null) {
                hover.setEditor(this.getEditor());
                this.fTextHoverSpecifications.set(i, null);
            }
            if (i == this.fInstantiatedTextHovers.size()) {
                this.fInstantiatedTextHovers.add(i, hover);
                continue;
            }
            this.fInstantiatedTextHovers.set(i, hover);
        }
        if (done) {
            this.fTextHoverSpecifications = null;
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        Iterator iterator = this.fInstantiatedTextHovers.iterator();
        while (iterator.hasNext()) {
            String s;
            ITextHover hover = (ITextHover)iterator.next();
            if (hover == null || (s = hover.getHoverInfo(textViewer, hoverRegion)) == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        Iterator iterator = this.fInstantiatedTextHovers.iterator();
        while (iterator.hasNext()) {
            ITextHover hover = (ITextHover)iterator.next();
            if (hover == null) continue;
            if (hover instanceof ITextHoverExtension2) {
                Object info = ((ITextHoverExtension2)hover).getHoverInfo2(textViewer, hoverRegion);
                if (info == null) continue;
                this.fBestHover = hover;
                return info;
            }
            String s = hover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

