/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.debug.internal.ui.viewers.model.ChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.HasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProviderTarget;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

public class TreeModelContentProvider
extends ModelContentProvider
implements ITreeModelContentProvider {
    protected void refilterChildren(TreePath path) {
        int[] filteredChildren;
        if (this.getViewer() != null && (filteredChildren = this.getFilteredChildren(path)) != null) {
            int i = 0;
            while (i < filteredChildren.length) {
                this.doUpdateElement(path, filteredChildren[i]);
                ++i;
            }
        }
    }

    protected synchronized void doUpdateChildCount(TreePath path) {
        Object element = this.getElement(path);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(element);
        if (contentAdapter != null) {
            ChildrenCountUpdate request = new ChildrenCountUpdate(this, this.getViewer().getInput(), path, element, contentAdapter, this.getPresentationContext());
            this.schedule(request);
        }
    }

    protected synchronized void doUpdateElement(TreePath parentPath, int modelIndex) {
        Object parent = this.getElement(parentPath);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(parent);
        if (contentAdapter != null) {
            ChildrenUpdate request = new ChildrenUpdate(this, this.getViewer().getInput(), parentPath, parent, modelIndex, contentAdapter, this.getPresentationContext());
            this.schedule(request);
        }
    }

    protected synchronized void doUpdateHasChildren(TreePath path) {
        Object element = this.getElement(path);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(element);
        if (contentAdapter != null) {
            HasChildrenUpdate request = new HasChildrenUpdate(this, this.getViewer().getInput(), path, element, contentAdapter, this.getPresentationContext());
            this.schedule(request);
        }
    }

    protected IPresentationContext getPresentationContext() {
        ITreeModelContentProviderTarget viewer = this.getViewer();
        if (viewer != null) {
            return viewer.getPresentationContext();
        }
        return null;
    }

    protected void handleAdd(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        TreePath parentPath = this.getViewerTreePath(parentDelta);
        Object element = delta.getElement();
        int count = parentDelta.getChildCount();
        if (count > 0) {
            this.setModelChildCount(parentPath, count);
            int modelIndex = count - 1;
            if (delta.getIndex() != -1) {
                modelIndex = delta.getIndex();
            }
            if (this.shouldFilter(parentPath, element)) {
                this.addFilteredIndex(parentPath, modelIndex, element);
                if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("[filtered] handleAdd(" + delta.getElement() + ") > modelIndex: " + modelIndex);
                }
            } else {
                if (this.isFiltered(parentPath, modelIndex)) {
                    this.clearFilteredChild(parentPath, modelIndex);
                }
                int viewIndex = this.modelToViewIndex(parentPath, modelIndex);
                int viewCount = this.modelToViewChildCount(parentPath, count);
                if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("handleAdd(" + delta.getElement() + ") viewIndex: " + viewIndex + " modelIndex: " + modelIndex + " viewCount: " + viewCount + " modelCount: " + count);
                }
                this.getViewer().setChildCount(parentPath, viewCount);
                this.getViewer().autoExpand(parentPath);
                this.getViewer().replace(parentPath, viewIndex, element);
                TreePath childPath = parentPath.createChildPath(element);
                this.updateHasChildren(childPath);
                this.restorePendingStateOnUpdate(childPath, modelIndex, false, false, false);
            }
        } else {
            if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("handleAdd(" + delta.getElement() + ")");
            }
            this.doUpdateChildCount(this.getViewerTreePath(delta.getParentDelta()));
        }
    }

    protected void handleContent(IModelDelta delta) {
        if (delta.getParentDelta() == null && delta.getChildCount() == 0 && !delta.getElement().equals(this.getViewer().getInput())) {
            return;
        }
        TreePath treePath = this.getViewerTreePath(delta);
        this.cancelSubtreeUpdates(treePath);
        this.appendToPendingStateDelta(treePath);
        this.getViewer().refresh(this.getElement(treePath));
    }

    protected void handleCollapse(IModelDelta delta) {
        TreePath elementPath = this.getViewerTreePath(delta);
        this.getViewer().setExpandedState(elementPath, false);
        this.cancelRestore(elementPath, 0x100000);
    }

    protected void handleExpand(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta != null) {
            if ((parentDelta.getFlags() & 0x100000) == 0) {
                this.handleExpand(parentDelta);
            }
            this.expand(delta);
        } else {
            int childCount = delta.getChildCount();
            TreePath elementPath = this.getViewerTreePath(delta);
            if (childCount > 0) {
                int viewCount = this.modelToViewChildCount(elementPath, childCount);
                if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("[expand] setChildCount(" + delta.getElement() + ", (model) " + childCount + " (view) " + viewCount);
                }
                this.getViewer().setChildCount(elementPath, viewCount);
            }
        }
    }

    protected void expand(IModelDelta delta) {
        int childCount = delta.getChildCount();
        int modelIndex = delta.getIndex();
        ITreeModelContentProviderTarget treeViewer = this.getViewer();
        TreePath elementPath = this.getViewerTreePath(delta);
        if (modelIndex >= 0) {
            int viewIndex;
            TreePath parentPath = elementPath.getParentPath();
            if (parentPath == null) {
                parentPath = TreePath.EMPTY;
            }
            if ((viewIndex = this.modelToViewIndex(parentPath, modelIndex)) >= 0) {
                if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("[expand] replace(" + delta.getParentDelta().getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
                }
                treeViewer.replace(parentPath, viewIndex, delta.getElement());
            } else {
                viewIndex = this.unfilterElement(parentPath, delta.getElement(), modelIndex);
                if (viewIndex < 0) {
                    return;
                }
            }
        }
        if (childCount > 0) {
            int viewCount = this.modelToViewChildCount(elementPath, childCount);
            if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("[expand] setChildCount(" + delta.getElement() + ", (model) " + childCount + " (view) " + viewCount);
            }
            treeViewer.setChildCount(elementPath, viewCount);
            if (!treeViewer.getExpandedState(elementPath)) {
                treeViewer.expandToLevel(elementPath, 1);
                this.cancelRestore(elementPath, 0x2000000);
            }
        }
    }

    protected int unfilterElement(TreePath parentPath, Object element, int modelIndex) {
        if (this.shouldFilter(parentPath, element)) {
            if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("[unfilter] abort unfilter element: " + element + ", (model) " + modelIndex);
            }
            return -1;
        }
        this.clearFilteredChild(parentPath, modelIndex);
        int viewIndex = this.modelToViewIndex(parentPath, modelIndex);
        if (viewIndex >= 0) {
            if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("[unfilter] insert(" + parentPath.getLastSegment() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + element);
            }
            this.getViewer().insert(parentPath, element, viewIndex);
            return viewIndex;
        }
        return -1;
    }

    protected void handleInsert(IModelDelta delta) {
        this.getViewer().insert(this.getViewerTreePath(delta.getParentDelta()), delta.getElement(), delta.getIndex());
    }

    protected void handleRemove(IModelDelta delta) {
        Object element;
        if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("handleRemove(" + delta.getElement() + ")");
        }
        IModelDelta parentDelta = delta.getParentDelta();
        ITreeModelContentProviderTarget treeViewer = this.getViewer();
        TreePath parentPath = this.getViewerTreePath(parentDelta);
        if (this.removeElementFromFilters(parentPath, element = delta.getElement())) {
            return;
        }
        int viewIndex = -1;
        int modelIndex = delta.getIndex();
        int unmappedIndex = -1;
        int itemCount = -1;
        if (modelIndex < 0) {
            itemCount = treeViewer.getChildCount(parentPath);
            if (itemCount == -1) {
                this.clearFilters(parentPath);
            }
            if ((viewIndex = treeViewer.findElementIndex(parentPath, element)) >= 0) {
                modelIndex = this.viewToModelIndex(parentPath, viewIndex);
            } else {
                unmappedIndex = treeViewer.findElementIndex(parentPath, null);
            }
        } else {
            viewIndex = this.modelToViewIndex(parentPath, modelIndex);
        }
        if (modelIndex >= 0) {
            if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println(" - (found) remove(" + parentPath.getLastSegment() + ", viewIndex: " + viewIndex + " modelIndex: " + modelIndex);
            }
            this.rescheduleUpdates(parentPath, modelIndex);
            this.getViewer().remove(parentPath, viewIndex);
            this.removeElementFromFilters(parentPath, modelIndex);
            return;
        }
        if (unmappedIndex >= 0) {
            if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println(" - (not found) remove(" + parentPath.getLastSegment() + ", viewIndex: " + viewIndex + " modelIndex: " + modelIndex + " unmapped index: " + unmappedIndex);
            }
            modelIndex = this.viewToModelIndex(parentPath, unmappedIndex);
            this.rescheduleUpdates(parentPath, modelIndex);
            this.getViewer().remove(parentPath, unmappedIndex);
            this.removeElementFromFilters(parentPath, modelIndex);
            return;
        }
        int modelCount = parentDelta.getChildCount();
        if (itemCount >= 0 && modelCount >= 0 && this.modelToViewChildCount(parentPath, modelCount) == itemCount) {
            return;
        }
        if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println(" - (not found) remove/refresh(" + delta.getElement());
        }
        this.getViewer().remove(this.getViewerTreePath(delta));
        this.clearFilters(parentPath);
        this.getViewer().refresh(parentDelta.getElement());
    }

    protected void handleReplace(IModelDelta delta) {
        TreePath parentPath = this.getViewerTreePath(delta.getParentDelta());
        this.getViewer().replace(parentPath, delta.getIndex(), delta.getElement());
    }

    protected void handleSelect(IModelDelta delta) {
        TreePath selectionPath;
        IModelDelta parentDelta;
        TreePath parentPath;
        int viewIndex;
        int modelIndex = delta.getIndex();
        ITreeModelContentProviderTarget treeViewer = this.getViewer();
        if (modelIndex >= 0 && (viewIndex = this.modelToViewIndex(parentPath = this.getViewerTreePath(parentDelta = delta.getParentDelta()), modelIndex)) >= 0) {
            int modelCount = parentDelta.getChildCount();
            if (modelCount > 0) {
                int viewCount = this.modelToViewChildCount(parentPath, modelCount);
                if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("[select] setChildCount(" + parentDelta.getElement() + ", (model) " + parentDelta.getChildCount() + " (view) " + viewCount);
                }
                treeViewer.setChildCount(parentPath, viewCount);
            }
            if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("[select] replace(" + parentDelta.getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
            }
            treeViewer.replace(parentPath, viewIndex, delta.getElement());
        }
        if (treeViewer.trySelection((ISelection)new TreeSelection(selectionPath = this.getViewerTreePath(delta)), false, (delta.getFlags() & 0x4000000) != 0)) {
            this.cancelRestore(selectionPath, 0x200000);
        }
    }

    protected void handleState(IModelDelta delta) {
        this.getViewer().update(delta.getElement());
    }

    protected void handleReveal(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta != null) {
            this.handleExpand(parentDelta);
            this.reveal(delta);
            this.cancelRestore(this.getViewerTreePath(delta), 0x1000000);
        }
    }

    protected void reveal(IModelDelta delta) {
        int modelIndex = delta.getIndex();
        ITreeModelContentProviderTarget treeViewer = this.getViewer();
        TreePath elementPath = this.getViewerTreePath(delta);
        if (modelIndex >= 0) {
            int viewIndex;
            TreePath parentPath = elementPath.getParentPath();
            if (parentPath == null) {
                parentPath = TreePath.EMPTY;
            }
            if ((viewIndex = this.modelToViewIndex(parentPath, modelIndex)) >= 0) {
                if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("[reveal] replace(" + delta.getParentDelta().getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
                }
                treeViewer.replace(parentPath, viewIndex, delta.getElement());
            } else {
                viewIndex = this.unfilterElement(parentPath, delta.getElement(), modelIndex);
                if (viewIndex < 0) {
                    return;
                }
            }
            if ((delta.getFlags() & 0x4000000) != 0 || treeViewer.overrideSelection(treeViewer.getSelection(), (ISelection)new TreeSelection(elementPath))) {
                treeViewer.reveal(parentPath, viewIndex);
            }
        }
    }

    protected void buildViewerState(ModelDelta delta) {
        TreePath topElementPath;
        ITreeModelContentProviderTarget viewer = this.getViewer();
        viewer.saveElementState(EMPTY_TREE_PATH, delta, 0x300000);
        if (viewer.getInput() != null && (topElementPath = viewer.getTopElementPath()) != null) {
            ModelDelta parentDelta = delta;
            TreePath parentPath = EMPTY_TREE_PATH;
            int i = 0;
            while (i < topElementPath.getSegmentCount()) {
                Object element = topElementPath.getSegment(i);
                int index = viewer.findElementIndex(parentPath, element);
                ModelDelta childDelta = parentDelta.getChildDelta(element);
                parentDelta = childDelta == null ? parentDelta.addNode(element, index, 0) : childDelta;
                parentPath = parentPath.createChildPath(element);
                ++i;
            }
            parentDelta.setFlags(parentDelta.getFlags() | 0x1000000);
        }
    }

    protected void doInitialRestore(ModelDelta delta) {
        this.markRevealDelta(delta);
        int count = this.getViewer().getChildCount(TreePath.EMPTY);
        int i = 0;
        while (i < count) {
            Object data = this.getViewer().getChildElement(TreePath.EMPTY, i);
            if (data != null) {
                this.restorePendingStateOnUpdate(new TreePath(new Object[]{data}), i, false, false, false);
            }
            ++i;
        }
    }

    private ModelDelta markRevealDelta(ModelDelta rootDelta) {
        final ModelDelta[] revealDelta = new ModelDelta[1];
        IModelDeltaVisitor visitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                if ((delta.getFlags() & 0x1000000) != 0) {
                    revealDelta[0] = (ModelDelta)delta;
                }
                return revealDelta[0] == null;
            }
        };
        rootDelta.accept(visitor);
        if (revealDelta[0] != null) {
            ModelDelta parentDelta = (ModelDelta)revealDelta[0].getParentDelta();
            while (parentDelta.getParentDelta() != null) {
                revealDelta[0] = parentDelta;
                revealDelta[0].setFlags(revealDelta[0].getFlags() | 0x1000000);
                parentDelta = (ModelDelta)parentDelta.getParentDelta();
            }
        }
        return revealDelta[0];
    }

    public TreePath[] getParents(Object element) {
        return null;
    }

    public synchronized void updateChildCount(TreePath treePath, int currentChildCount) {
        if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("updateChildCount(" + this.getElement(treePath) + ", " + currentChildCount + ")");
        }
        this.refilterChildren(treePath);
        this.doUpdateChildCount(treePath);
    }

    public synchronized void updateElement(TreePath parentPath, int viewIndex) {
        int modelIndex = this.viewToModelIndex(parentPath, viewIndex);
        if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("updateElement(" + this.getElement(parentPath) + ", " + viewIndex + ") > modelIndex = " + modelIndex);
        }
        this.doUpdateElement(parentPath, modelIndex);
    }

    public synchronized void updateHasChildren(TreePath path) {
        if (DEBUG_CONTENT_PROVIDER && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("updateHasChildren(" + this.getElement(path));
        }
        this.doUpdateHasChildren(path);
    }

    void restorePendingStateNode(ModelDelta delta, boolean knowsHasChildren, boolean knowsChildCount, boolean checkChildrenRealized) {
        int childCount;
        int modelIndex;
        IModelDelta[] childDeltas;
        TreePath treePath = this.getViewerTreePath(delta);
        ITreeModelContentProviderTarget viewer = this.getViewer();
        if (knowsHasChildren) {
            if ((delta.getFlags() & 0x100000) != 0) {
                if (DEBUG_STATE_SAVE_RESTORE && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("\tRESTORE EXPAND: " + treePath.getLastSegment());
                }
                viewer.expandToLevel(treePath, 1);
                delta.setFlags(delta.getFlags() & 0xFFEFFFFF);
            }
            if ((delta.getFlags() & 0x2000000) != 0) {
                if (DEBUG_STATE_SAVE_RESTORE && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("\tRESTORE COLLAPSE: " + treePath.getLastSegment());
                }
                this.getViewer().setExpandedState(treePath, false);
                delta.setFlags(delta.getFlags() & 0xFDFFFFFF);
            }
        }
        if ((delta.getFlags() & 0x200000) != 0) {
            ITreeSelection currentSelection;
            delta.setFlags(delta.getFlags() & 0xFFDFFFFF);
            if (DEBUG_STATE_SAVE_RESTORE && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("\tRESTORE SELECT: " + treePath.getLastSegment());
            }
            if ((currentSelection = (ITreeSelection)viewer.getSelection()) == null || currentSelection.isEmpty()) {
                viewer.setSelection((ISelection)new TreeSelection(treePath), false, false);
            } else {
                TreePath[] currentPaths = currentSelection.getPaths();
                boolean pathInSelection = false;
                int i = 0;
                while (i < currentPaths.length) {
                    if (currentPaths[i].equals((Object)treePath)) {
                        pathInSelection = true;
                        break;
                    }
                    ++i;
                }
                if (!pathInSelection) {
                    TreePath[] newPaths = new TreePath[currentPaths.length + 1];
                    System.arraycopy(currentPaths, 0, newPaths, 0, currentPaths.length);
                    newPaths[newPaths.length - 1] = treePath;
                    viewer.setSelection((ISelection)new TreeSelection(newPaths), false, false);
                }
            }
        }
        if ((delta.getFlags() & 0x1000000) != 0) {
            TreePath parentPath;
            int index;
            delta.setFlags(delta.getFlags() & 0xFEFFFFFF);
            boolean setTopItem = true;
            childDeltas = delta.getChildDeltas();
            int i = 0;
            while (i < childDeltas.length) {
                IModelDelta childDelta = childDeltas[i];
                modelIndex = childDelta.getIndex();
                if (modelIndex >= 0 && (childDelta.getFlags() & 0x1000000) != 0) {
                    setTopItem = false;
                }
                ++i;
            }
            if (setTopItem && (index = viewer.findElementIndex(parentPath = treePath.getParentPath(), treePath.getLastSegment())) >= 0) {
                if (DEBUG_STATE_SAVE_RESTORE && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("\tRESTORE REVEAL: " + treePath.getLastSegment());
                }
                viewer.reveal(parentPath, index);
            }
        }
        if (knowsChildCount && (childCount = viewer.getChildCount(treePath)) >= 0) {
            childDeltas = (ModelDelta[])delta.getChildDeltas();
            int i = 0;
            while (i < childDeltas.length) {
                IModelDelta childDelta = childDeltas[i];
                modelIndex = ((ModelDelta)childDelta).getIndex();
                if (modelIndex >= 0 && (((ModelDelta)childDelta).getFlags() & 0x1000000) != 0) {
                    if (modelIndex < childCount) {
                        this.doUpdateElement(treePath, modelIndex);
                    } else {
                        ((ModelDelta)childDelta).setFlags(((ModelDelta)childDelta).getFlags() & 0xFEFFFFFF);
                    }
                }
                ++i;
            }
        }
        if (checkChildrenRealized && this.getElementChildrenRealized(treePath) || knowsHasChildren && !viewer.getHasChildren(treePath)) {
            if (DEBUG_STATE_SAVE_RESTORE && TreeModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("\tRESTORE CONTENT: " + treePath.getLastSegment());
            }
            delta.setFlags(delta.getFlags() & 0xFFFFFBFF);
        }
    }
}

