/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;

public class MembersOrderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_ID = "org.eclipse.wst.jsdt.ui.preferences.MembersOrderPreferencePage";
    private static final String ALL_SORTMEMBER_ENTRIES = "T,F,C,M";
    private static final String ALL_VISIBILITY_ENTRIES = "B,V,R,D";
    private static final String PREF_OUTLINE_SORT_OPTION = "outlinesortoption";
    private static final String PREF_VISIBILITY_SORT_OPTION = "org.eclipse.wst.jsdt.ui.visibility.order";
    private static final String PREF_USE_VISIBILITY_SORT_OPTION = "org.eclipse.wst.jsdt.ui.enable.visibility.order";
    public static final String CONSTRUCTORS = "C";
    public static final String VARS = "F";
    public static final String METHODS = "M";
    public static final String INIT = "I";
    public static final String TYPES = "T";
    public static final String PUBLIC = "B";
    public static final String PRIVATE = "V";
    public static final String PROTECTED = "R";
    public static final String DEFAULT = "D";
    private boolean fUseVisibilitySort;
    private ListDialogField fSortOrderList;
    private ListDialogField fVisibilityOrderList;
    private SelectionButtonDialogField fUseVisibilitySortField;

    private static boolean isValidEntries(List entries, String entryString) {
        StringTokenizer tokenizer = new StringTokenizer(entryString, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!entries.contains(token)) {
                return false;
            }
            ++i;
        }
        return i == entries.size();
    }

    public MembersOrderPreferencePage() {
        this.setPreferenceStore(JavaScriptPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.MembersOrderPreferencePage_label_description);
        String memberSortString = ALL_SORTMEMBER_ENTRIES;
        String upLabel = PreferencesMessages.MembersOrderPreferencePage_category_button_up;
        String downLabel = PreferencesMessages.MembersOrderPreferencePage_category_button_down;
        this.fSortOrderList = new ListDialogField(null, new String[]{upLabel, downLabel}, (ILabelProvider)new MemberSortLabelProvider());
        this.fSortOrderList.setDownButtonIndex(1);
        this.fSortOrderList.setUpButtonIndex(0);
        List entries = MembersOrderPreferencePage.parseList(memberSortString);
        if (!MembersOrderPreferencePage.isValidEntries(entries, ALL_SORTMEMBER_ENTRIES)) {
            memberSortString = this.getPreferenceStore().getDefaultString(PREF_OUTLINE_SORT_OPTION);
            entries = MembersOrderPreferencePage.parseList(memberSortString);
        }
        this.fSortOrderList.setElements(entries);
        this.fUseVisibilitySort = this.getPreferenceStore().getBoolean(PREF_USE_VISIBILITY_SORT_OPTION);
        String visibilitySortString = this.getPreferenceStore().getString(PREF_VISIBILITY_SORT_OPTION);
        upLabel = PreferencesMessages.MembersOrderPreferencePage_visibility_button_up;
        downLabel = PreferencesMessages.MembersOrderPreferencePage_visibility_button_down;
        this.fVisibilityOrderList = new ListDialogField(null, new String[]{upLabel, downLabel}, (ILabelProvider)new VisibilitySortLabelProvider());
        this.fVisibilityOrderList.setDownButtonIndex(1);
        this.fVisibilityOrderList.setUpButtonIndex(0);
        entries = MembersOrderPreferencePage.parseList(visibilitySortString);
        if (!MembersOrderPreferencePage.isValidEntries(entries, ALL_VISIBILITY_ENTRIES)) {
            visibilitySortString = this.getPreferenceStore().getDefaultString(PREF_VISIBILITY_SORT_OPTION);
            entries = MembersOrderPreferencePage.parseList(visibilitySortString);
        }
        this.fVisibilityOrderList.setElements(entries);
    }

    private static List parseList(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        ArrayList<String> entries = new ArrayList<String>();
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            entries.add(token);
            ++i;
        }
        return entries;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.sort_order_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        Composite sortComposite = new Composite(parent, 0);
        sortComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        sortComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 768;
        sortComposite.setLayoutData((Object)gd);
        this.createListDialogField(sortComposite, this.fSortOrderList);
        this.fUseVisibilitySortField = new SelectionButtonDialogField(32);
        this.fUseVisibilitySortField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                MembersOrderPreferencePage.this.fVisibilityOrderList.setEnabled(MembersOrderPreferencePage.this.fUseVisibilitySortField.isSelected());
            }
        });
        this.fUseVisibilitySortField.setLabelText(PreferencesMessages.MembersOrderPreferencePage_usevisibilitysort_label);
        this.fUseVisibilitySortField.doFillIntoGrid(sortComposite, 2);
        this.fUseVisibilitySortField.setSelection(this.fUseVisibilitySort);
        this.createListDialogField(sortComposite, this.fVisibilityOrderList);
        this.fVisibilityOrderList.setEnabled(this.fUseVisibilitySortField.isSelected());
        Dialog.applyDialogFont((Control)sortComposite);
        this.fUseVisibilitySortField.setEnabled(false);
        this.fVisibilityOrderList.setEnabled(false);
        return sortComposite;
    }

    private void createListDialogField(Composite composite, ListDialogField dialogField) {
        Control list = dialogField.getListControl(composite);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        list.setLayoutData((Object)gd);
        Composite buttons = dialogField.getButtonBox(composite);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        buttons.setLayoutData((Object)gd);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore prefs = JavaScriptPlugin.getDefault().getPreferenceStore();
        String str = prefs.getDefaultString(PREF_OUTLINE_SORT_OPTION);
        if (str != null) {
            this.fSortOrderList.setElements(MembersOrderPreferencePage.parseList(str));
        } else {
            this.fSortOrderList.setElements(MembersOrderPreferencePage.parseList(ALL_SORTMEMBER_ENTRIES));
        }
        str = prefs.getDefaultString(PREF_VISIBILITY_SORT_OPTION);
        if (str != null) {
            this.fVisibilityOrderList.setElements(MembersOrderPreferencePage.parseList(str));
        } else {
            this.fVisibilityOrderList.setElements(MembersOrderPreferencePage.parseList(ALL_VISIBILITY_ENTRIES));
        }
        this.fUseVisibilitySortField.setSelection(prefs.getDefaultBoolean(PREF_USE_VISIBILITY_SORT_OPTION));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        this.updateList(store, this.fSortOrderList, PREF_OUTLINE_SORT_OPTION);
        this.updateList(store, this.fVisibilityOrderList, PREF_VISIBILITY_SORT_OPTION);
        store.setValue(PREF_USE_VISIBILITY_SORT_OPTION, this.fUseVisibilitySortField.isSelected());
        JavaScriptPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void updateList(IPreferenceStore store, ListDialogField list, String str) {
        StringBuffer buf = new StringBuffer();
        List curr = list.getElements();
        Iterator iter = curr.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            buf.append(s);
            buf.append(',');
        }
        store.setValue(str, buf.toString());
    }

    private class MemberSortLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            ImageDescriptorRegistry registry = JavaScriptPlugin.getImageDescriptorRegistry();
            Object descriptor = null;
            if (element instanceof String) {
                int visibility = 1;
                String s = (String)element;
                if (s.equals(MembersOrderPreferencePage.VARS)) {
                    descriptor = JavaElementImageProvider.getFieldImageDescriptor(false, visibility);
                } else if (s.equals(MembersOrderPreferencePage.CONSTRUCTORS)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, visibility);
                    descriptor = new JavaScriptElementImageDescriptor((ImageDescriptor)descriptor, 512, JavaElementImageProvider.SMALL_SIZE);
                } else {
                    descriptor = s.equals(MembersOrderPreferencePage.METHODS) ? JavaElementImageProvider.getMethodImageDescriptor(false, visibility) : (s.equals(MembersOrderPreferencePage.INIT) ? JavaElementImageProvider.getMethodImageDescriptor(false, visibility) : (s.equals(MembersOrderPreferencePage.TYPES) ? JavaElementImageProvider.getTypeImageDescriptor(true, false, 1, false) : JavaElementImageProvider.getMethodImageDescriptor(false, 1)));
                }
                return registry.get((ImageDescriptor)descriptor);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                String s = (String)element;
                if (s.equals(MembersOrderPreferencePage.VARS)) {
                    return PreferencesMessages.MembersOrderPreferencePage_vars_label;
                }
                if (s.equals(MembersOrderPreferencePage.METHODS)) {
                    return PreferencesMessages.MembersOrderPreferencePage_methods_label;
                }
                if (s.equals(MembersOrderPreferencePage.CONSTRUCTORS)) {
                    return PreferencesMessages.MembersOrderPreferencePage_constructors_label;
                }
                if (s.equals(MembersOrderPreferencePage.INIT)) {
                    return PreferencesMessages.MembersOrderPreferencePage_initialisers_label;
                }
                if (s.equals(MembersOrderPreferencePage.TYPES)) {
                    return PreferencesMessages.MembersOrderPreferencePage_types_label;
                }
            }
            return "";
        }
    }

    private class VisibilitySortLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            ImageDescriptorRegistry registry = JavaScriptPlugin.getImageDescriptorRegistry();
            ImageDescriptor descriptor = null;
            if (element instanceof String) {
                String s = (String)element;
                if (s.equals(MembersOrderPreferencePage.PUBLIC)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, 1);
                } else if (s.equals(MembersOrderPreferencePage.PROTECTED)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, 4);
                } else if (s.equals(MembersOrderPreferencePage.PRIVATE)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, 2);
                } else if (s.equals(MembersOrderPreferencePage.DEFAULT)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, 0);
                }
                return registry.get(descriptor);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                String s = (String)element;
                if (s.equals(MembersOrderPreferencePage.PUBLIC)) {
                    return PreferencesMessages.MembersOrderPreferencePage_public_label;
                }
                if (s.equals(MembersOrderPreferencePage.PRIVATE)) {
                    return PreferencesMessages.MembersOrderPreferencePage_private_label;
                }
                if (s.equals(MembersOrderPreferencePage.PROTECTED)) {
                    return PreferencesMessages.MembersOrderPreferencePage_protected_label;
                }
                if (s.equals(MembersOrderPreferencePage.DEFAULT)) {
                    return PreferencesMessages.MembersOrderPreferencePage_default_label;
                }
            }
            return "";
        }
    }
}

