/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.xwt.javabean.metadata.properties.EventProperty;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.tools.ui.designer.properties.PropertyContext;
import org.eclipse.e4.xwt.tools.ui.designer.properties.StylePropertyHelper;
import org.eclipse.e4.xwt.tools.ui.designer.properties.XWTPropertyDescriptor;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTModelUtil;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class XWTPropertySource
implements IPropertySource {
    private PropertyContext fContext;
    private IPropertyDescriptor[] descriptors;
    private StylePropertyHelper styleHelper;

    public XWTPropertySource(PropertyContext propertyContext) {
        Assert.isNotNull((Object)propertyContext);
        this.fContext = propertyContext;
    }

    public Object getEditableValue() {
        return this.fContext.getComponent();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.createPropertyDescriptors();
        }
        return this.descriptors;
    }

    private IPropertyDescriptor[] createPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        IMetaclass metaclass = this.fContext.getMetaclass();
        if (metaclass == null) {
            return new IPropertyDescriptor[0];
        }
        IProperty[] properties = metaclass.getProperties();
        ArrayList<String> done = new ArrayList<String>();
        int i = properties.length - 1;
        while (i >= 0) {
            IProperty property = properties[i];
            if (this.canEditable(metaclass, property)) {
                done.add(property.getName());
                IPropertyDescriptor descriptor = this.createDescriptor(property);
                result.add(descriptor);
            }
            --i;
        }
        if (!done.contains("style")) {
            Object editableValue = this.getEditableValue();
            if (editableValue instanceof Widget) {
                this.styleHelper = new StylePropertyHelper(this.fContext.getNode());
                this.styleHelper.setEditDomain(this.fContext.getEditDomain());
            }
            if (this.styleHelper != null) {
                result.addAll(this.styleHelper.createPropertyDescriptors());
            }
        }
        return result.toArray(new IPropertyDescriptor[0]);
    }

    protected IPropertyDescriptor createDescriptor(IProperty property) {
        XWTPropertyDescriptor descriptor = new XWTPropertyDescriptor(this.fContext, property);
        descriptor.setCategory(this.fContext.getCategory());
        return descriptor;
    }

    protected boolean canEditable(IMetaclass metaclass, IProperty property) {
        if (property instanceof EventProperty) {
            return false;
        }
        Class classType = metaclass.getType();
        Class propertyType = property.getType();
        String name = property.getName();
        if (TableViewer.class.isAssignableFrom(classType) && "table".equals(name) && Table.class.isAssignableFrom(propertyType) || TreeViewer.class.isAssignableFrom(classType) && "tree".equals(name) && Tree.class.isAssignableFrom(propertyType) || ListViewer.class.isAssignableFrom(classType) && "list".equals(name) && List.class.isAssignableFrom(propertyType) || ComboViewer.class.isAssignableFrom(classType) && "combo".equals(name) && Combo.class.isAssignableFrom(propertyType)) {
            return true;
        }
        try {
            String setMethodName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Method setMethod = classType.getMethod(setMethodName, propertyType);
            if (setMethod != null && (setMethod.getModifiers() & 1) != 0) {
                return true;
            }
        }
        catch (Exception exception) {}
        try {
            Field field = classType.getField(name);
            if (field != null && (field.getModifiers() & 1) != 0) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public Object getPropertyValue(Object id) {
        Object value;
        block21: {
            value = null;
            if (id instanceof IProperty) {
                IProperty p = (IProperty)id;
                try {
                    Class type = p.getType();
                    XamlAttribute attribute = XWTModelUtil.getAdaptableAttribute(this.fContext.getNode(), p.getName(), "http://www.eclipse.org/xwt/presentation");
                    Object component = this.fContext.getComponent();
                    if (this.fContext.isDirectEditType(type)) {
                        value = attribute != null && attribute.getValue() != null ? attribute.getValue() : p.getValue(component);
                    } else if (type.isArray()) {
                        value = p.getValue(component);
                    } else {
                        Object childSource;
                        boolean isAtrrNew = false;
                        if (attribute == null) {
                            attribute = XamlFactory.eINSTANCE.createAttribute(p.getName(), "http://www.eclipse.org/xwt/presentation");
                            isAtrrNew = true;
                        }
                        if ((childSource = p.getValue(component)) != null) {
                            String childName;
                            Class<?> childSourceType = childSource.getClass();
                            XamlAttribute child = null;
                            if (Widget.class.isAssignableFrom(childSourceType)) {
                                child = attribute;
                            } else if (!childSourceType.isArray() && (child = attribute.getChild(childName = childSource.getClass().getSimpleName(), "http://www.eclipse.org/xwt/presentation")) == null) {
                                child = XamlFactory.eINSTANCE.createElement(childName, "http://www.eclipse.org/xwt/presentation");
                                if (isAtrrNew) {
                                    attribute.getChildNodes().add((Object)((XamlElement)child));
                                }
                            }
                            if (child != null && childSource != null) {
                                value = new PropertyContext((XamlNode)child, this.fContext);
                            }
                        }
                    }
                    if (value != null) break block21;
                    if (Boolean.class == type || Boolean.TYPE == type) {
                        value = false;
                    } else if (String.class == type) {
                        value = "";
                    } else if (Integer.class == type || Integer.TYPE == type) {
                        value = 0;
                    }
                }
                catch (Exception exception) {}
            } else if (this.styleHelper != null) {
                value = this.styleHelper.getPropertyValue(id);
            }
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        if (id instanceof IProperty) {
            return this.fContext.getNode().getAttribute(((IProperty)id).getName()) != null;
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (id instanceof IProperty) {
            this.fContext.setPropertyValue(id, value);
        } else if (this.styleHelper != null) {
            this.styleHelper.setPropertyValue(id, value);
        }
    }
}

