/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.breakpoints;

import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpointParticipant;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptPrimitiveValue;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptThread;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;
import org.eclipse.wst.jsdt.debug.internal.rhino.RhinoDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.RhinoPreferencesManager;

public class RhinoBreakpointParticipant
implements IJavaScriptBreakpointParticipant {
    public int breakpointHit(IJavaScriptThread thread, IJavaScriptBreakpoint breakpoint) {
        block5: {
            IJavaScriptValue value;
            block7: {
                IJavaScriptLineBreakpoint lbp;
                String condition;
                block6: {
                    try {
                        if (!(breakpoint instanceof IJavaScriptLineBreakpoint) || (condition = (lbp = (IJavaScriptLineBreakpoint)breakpoint).getCondition()) == null) break block5;
                        if (thread.getFrameCount() >= 1) break block6;
                        return 2;
                    }
                    catch (CoreException coreException) {}
                }
                value = thread.evaluate(condition);
                if (!lbp.isConditionSuspendOnTrue() || !this.suspendForValue(value)) break block7;
                return 1;
            }
            if (!this.suspendForValue(value)) {
                return 1;
            }
        }
        return 2;
    }

    public int scriptLoaded(IJavaScriptThread thread, ScriptReference script, IJavaScriptBreakpoint breakpoint) {
        block4: {
            if (!URIUtil.lastSegment((URI)script.sourceURI()).equals("stdin") || RhinoPreferencesManager.suspendOnStdinLoad()) break block4;
            return 2;
        }
        try {
            Path path = new Path(breakpoint.getScriptPath());
            if (path.isEmpty() || path.lastSegment().equals(URIUtil.lastSegment((URI)script.sourceURI())) || path.toString().equals(script.sourceURI().getPath())) {
                return 1;
            }
        }
        catch (CoreException ce) {
            RhinoDebugPlugin.log(ce);
        }
        return 2;
    }

    private boolean suspendForValue(IJavaScriptValue value) {
        if (value instanceof IJavaScriptPrimitiveValue) {
            return ((IJavaScriptPrimitiveValue)value).booleanValue();
        }
        return false;
    }
}

