/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.StackFrame;
import org.eclipse.wst.jsdt.debug.core.jsdi.Value;
import org.eclipse.wst.jsdt.debug.core.jsdi.Variable;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ArrayReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.BooleanValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.FunctionReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.LocationImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.MirrorImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.NumberValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ObjectReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ScriptReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.StringValueImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VariableImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;
import org.eclipse.wst.jsdt.debug.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.rhino.transport.TimeoutException;

public class StackFrameImpl
extends MirrorImpl
implements StackFrame {
    private final Number frameId;
    private final Number threadId;
    private final Number contextId;
    private final Number ref;
    private final Location location;
    private List variables;
    private VariableImpl thisVariable;
    private HashMap cache = new HashMap();

    public StackFrameImpl(VirtualMachineImpl vm, Map jsonFrame) {
        super(vm);
        Number line;
        Location lineLocation;
        this.threadId = (Number)jsonFrame.get("threadId");
        this.frameId = (Number)jsonFrame.get("frameId");
        this.contextId = (Number)jsonFrame.get("contextId");
        this.ref = (Number)jsonFrame.get("ref");
        Long scriptId = new Long(((Number)jsonFrame.get("scriptId")).longValue());
        ScriptReferenceImpl script = vm.getScript(scriptId);
        String function = (String)jsonFrame.get("function");
        this.location = function != null ? script.functionLocation(function) : ((lineLocation = script.lineLocation((line = (Number)jsonFrame.get("line")).intValue())) != null ? lineLocation : new LocationImpl(vm, function, line.intValue(), script));
    }

    public Value evaluate(String expression) {
        Request request = new Request("evaluate");
        request.getArguments().put("threadId", this.threadId);
        request.getArguments().put("frameId", this.frameId);
        request.getArguments().put("expression", expression);
        try {
            Response response = this.vm.sendRequest(request, 30000);
            return this.createValue(response.getBody(), true);
        }
        catch (DisconnectedException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Value lookupValue(Number ref) {
        Value value = (Value)this.cache.get(ref);
        if (value == null) {
            Request request = new Request("lookup");
            request.getArguments().put("threadId", this.threadId);
            request.getArguments().put("frameId", this.frameId);
            request.getArguments().put("handle", ref);
            try {
                Response response = this.vm.sendRequest(request, 30000);
                value = this.createValue(response.getBody(), false);
                this.cache.put(ref, value);
                return value;
            }
            catch (DisconnectedException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private Value createValue(Map body, boolean iseval) throws IllegalStateException {
        Map value = (Map)body.get(iseval ? "evaluate" : "lookup");
        if (value == null) {
            return this.vm.nullValue;
        }
        String type = (String)value.get("type");
        if (type == null) {
            return this.vm.nullValue;
        }
        if (type.equals("undefined")) {
            return this.vm.undefinedValue;
        }
        if (type.equals("null")) {
            return this.vm.nullValue;
        }
        if (type.equals("boolean")) {
            return new BooleanValueImpl(this.vm, value);
        }
        if (type.equals("number")) {
            return new NumberValueImpl(this.vm, value);
        }
        if (type.equals("string")) {
            return new StringValueImpl(this.vm, value);
        }
        if (type.equals("object")) {
            return new ObjectReferenceImpl(this.vm, value, this);
        }
        if (type.equals("function")) {
            return new FunctionReferenceImpl(this.vm, value, this);
        }
        if (type.equals("array")) {
            return new ArrayReferenceImpl(this.vm, value, this);
        }
        throw new IllegalStateException();
    }

    public Location location() {
        return this.location;
    }

    public synchronized Variable thisObject() {
        this.initializeVariables();
        return this.thisVariable;
    }

    public synchronized List variables() {
        this.initializeVariables();
        return this.variables;
    }

    private void initializeVariables() {
        if (this.variables != null) {
            return;
        }
        Request request = new Request("lookup");
        request.getArguments().put("threadId", this.threadId);
        request.getArguments().put("frameId", this.frameId);
        request.getArguments().put("handle", this.ref);
        try {
            Response response = this.vm.sendRequest(request, 30000);
            Map lookup = (Map)response.getBody().get("lookup");
            List properties = (List)lookup.get("properties");
            this.variables = new ArrayList();
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                Map property = (Map)iterator.next();
                String name = (String)property.get("name");
                Number ref = (Number)property.get("ref");
                VariableImpl variable = new VariableImpl(this.vm, this, name, ref);
                if (name.equals("this")) {
                    this.thisVariable = variable;
                    continue;
                }
                this.variables.add(variable);
            }
        }
        catch (DisconnectedException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean isVisible(VariableImpl variable) {
        return this.variables != null && (this.thisVariable == variable || this.variables.contains(variable));
    }

    public Number getContextId() {
        return this.contextId;
    }
}

