/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Computation {
    Map<IEclipseContext, Set<String>> dependencies = new HashMap<IEclipseContext, Set<String>>();

    Computation() {
    }

    void addDependency(IEclipseContext context, String name) {
        Set<String> properties = this.dependencies.get(context);
        if (properties == null) {
            properties = new HashSet<String>(4);
            this.dependencies.put(context, properties);
        }
        properties.add(name);
    }

    final void clear(IEclipseContext context, String name) {
        this.doClear();
        this.stopListening(context, name);
    }

    protected void doClear() {
    }

    protected void doHandleInvalid(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduled) {
    }

    public abstract boolean equals(Object var1);

    final void handleInvalid(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduled) {
        IEclipseContext context = event.getContext();
        String name = event.getName();
        Set<String> names = this.dependencies.get(context);
        if (name == null && event.getEventType() == 3) {
            this.clear(context, null);
            this.doHandleInvalid(event, scheduled);
        } else if (names != null && names.contains(name)) {
            this.clear(context, name);
            this.doHandleInvalid(event, scheduled);
        }
    }

    final void handleUninjected(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduled) {
        this.doHandleInvalid(event, scheduled);
    }

    public abstract int hashCode();

    private String mapToString(Map<IEclipseContext, Set<String>> map) {
        StringBuffer result = new StringBuffer(123);
        Iterator<Map.Entry<IEclipseContext, Set<String>>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IEclipseContext, Set<String>> entry = it.next();
            result.append(entry.getKey());
            result.append("->(");
            Set<String> set = entry.getValue();
            Iterator<String> it2 = set.iterator();
            while (it2.hasNext()) {
                String name = it2.next();
                result.append(name);
                if (!it2.hasNext()) continue;
                result.append(',');
            }
            result.append(')');
            if (!it.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }

    protected void removeAll(EclipseContext originatingContext) {
        Iterator<IEclipseContext> it = this.dependencies.keySet().iterator();
        while (it.hasNext()) {
            ((EclipseContext)it.next()).listeners.remove(this);
        }
        this.dependencies.clear();
        originatingContext.listeners.remove(this);
    }

    void startListening(EclipseContext originatingContext) {
        if (EclipseContext.DEBUG) {
            System.out.println(String.valueOf(this.toString()) + " now listening to: " + this.mapToString(this.dependencies));
        }
        for (EclipseContext eclipseContext : this.dependencies.keySet()) {
            Computation existingComputation = eclipseContext.listeners.get(this);
            if (existingComputation != null) {
                if (this == existingComputation) continue;
                Set<String> existingDependencies = existingComputation.dependencies.get(eclipseContext);
                if (existingDependencies != null) {
                    existingDependencies.addAll((Collection<String>)this.dependencies.get(eclipseContext));
                    continue;
                }
                existingComputation.dependencies.put(eclipseContext, this.dependencies.get(eclipseContext));
                continue;
            }
            eclipseContext.listeners.put(this, this);
        }
        if (!this.dependencies.containsKey(originatingContext)) {
            originatingContext.listeners.remove(this);
        }
    }

    protected void stopListening(IEclipseContext context, String name) {
        if (name == null) {
            if (EclipseContext.DEBUG) {
                System.out.println(String.valueOf(this.toString()) + " no longer listening to " + context);
            }
            this.dependencies.remove(context);
            return;
        }
        Set<String> properties = this.dependencies.get(context);
        if (properties != null) {
            if (EclipseContext.DEBUG) {
                System.out.println(String.valueOf(this.toString()) + " no longer listening to " + context + ',' + name);
            }
            properties.remove(name);
            if (properties.isEmpty()) {
                this.dependencies.remove(context);
            }
        }
    }

    public Set<String> dependsOnNames(IEclipseContext context) {
        return this.dependencies.get(context);
    }
}

