/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashRenderer
extends SWTPartRenderer {
    private ControlListener resizeListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            Control ctrl = (Control)e.widget;
            if (ctrl.isDisposed() || !(ctrl.getParent() instanceof SashForm)) {
                return;
            }
            SashForm sf = (SashForm)ctrl.getParent();
            if (this.weightsChanged(sf)) {
                SashRenderer.this.weightsMap.put(sf, sf.getWeights());
                SashRenderer.this.addSashToUpdate(sf);
            }
        }

        private boolean weightsChanged(SashForm sf) {
            int[] oldW = (int[])SashRenderer.this.weightsMap.get(sf);
            int[] newW = sf.getWeights();
            if (oldW == null || oldW.length != newW.length) {
                return true;
            }
            int j = 0;
            while (j < oldW.length) {
                if (oldW[j] != newW[j]) {
                    return true;
                }
                ++j;
            }
            return false;
        }
    };
    @Inject
    private IEventBroker eventBroker;
    private static final int UNDEFINED_WEIGHT = -1;
    private static final int DEFAULT_WEIGHT = 100;
    private Map weightsMap = new HashMap();
    private EventHandler sashOrientationHandler;
    private EventHandler sashWeightHandler;
    ModelUpdateJob modelUpdateJob;
    SashUpdateJob sashUpdateJob;
    protected boolean ignoreWeightUpdates = false;

    private void addSashToUpdate(SashForm sf) {
        MElementContainer psc = (MElementContainer)sf.getData("modelElement");
        if (this.modelUpdateJob != null && this.modelUpdateJob.sashModelsToUpdate.contains(psc)) {
            return;
        }
        if (this.sashUpdateJob == null) {
            this.sashUpdateJob = new SashUpdateJob();
            this.sashUpdateJob.sashesToUpdate.add(sf);
            sf.getDisplay().asyncExec((Runnable)this.sashUpdateJob);
        } else if (!this.sashUpdateJob.sashesToUpdate.contains(sf)) {
            this.sashUpdateJob.sashesToUpdate.add(sf);
        }
    }

    private void addModelToUpdate(MElementContainer<MUIElement> pscModel) {
        Control sf = (Control)pscModel.getWidget();
        if (sf == null || sf.isDisposed()) {
            return;
        }
        if (this.modelUpdateJob == null) {
            this.modelUpdateJob = new ModelUpdateJob();
            this.modelUpdateJob.sashModelsToUpdate.add(pscModel);
            sf.getDisplay().asyncExec((Runnable)this.modelUpdateJob);
        } else if (!this.modelUpdateJob.sashModelsToUpdate.contains(pscModel)) {
            this.modelUpdateJob.sashModelsToUpdate.add(pscModel);
        }
    }

    void clearModelUpdate() {
        this.modelUpdateJob = null;
    }

    void clearSashUpdate() {
        this.sashUpdateJob = null;
    }

    @PostConstruct
    void postConstruct() {
        this.sashOrientationHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element = event.getProperty("ChangedElement");
                if (!(element instanceof MPartSashContainer)) {
                    return;
                }
                if ("horizontal".equals(event.getProperty("AttName"))) {
                    Boolean horizontal = (Boolean)event.getProperty("NewValue");
                    MPartSashContainer container = (MPartSashContainer)element;
                    SashForm sashForm = (SashForm)container.getWidget();
                    sashForm.setOrientation(horizontal != false ? 256 : 512);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/GenericTile", (String)"horizontal"), this.sashOrientationHandler);
        this.sashWeightHandler = new EventHandler(){

            public void handleEvent(Event event) {
                if (SashRenderer.this.ignoreWeightUpdates) {
                    return;
                }
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                MElementContainer parent = element.getParent();
                if (!(parent instanceof MPartSashContainer) || parent.getRenderer() != SashRenderer.this) {
                    return;
                }
                MElementContainer pscModel = parent;
                if ("containerData".equals(event.getProperty("AttName"))) {
                    SashRenderer.this.addModelToUpdate((MElementContainer<MUIElement>)pscModel);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/UIElement", (String)"containerData"), this.sashWeightHandler);
    }

    @PreDestroy
    void preDestroy() {
        this.eventBroker.unsubscribe(this.sashOrientationHandler);
        this.eventBroker.unsubscribe(this.sashWeightHandler);
    }

    public Widget createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPartSashContainer) || !(parent instanceof Composite)) {
            return null;
        }
        Widget parentWidget = (Widget)parent;
        MPartSashContainer psc = (MPartSashContainer)element;
        int orientation = psc.isHorizontal() ? 256 : 512;
        SashForm newSash = new SashForm((Composite)parentWidget, 0x10000 | orientation);
        this.bindWidget(element, newSash);
        newSash.setVisible(true);
        return newSash;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (!(parentElement.getWidget() instanceof SashForm)) {
            return;
        }
        int weight = SashRenderer.getWeight(element);
        if (weight == -1) {
            element.setContainerData(Integer.toString(100));
        }
        MElementContainer<MUIElement> psc = parentElement;
        for (MUIElement part : psc.getChildren()) {
            Control partCtrl = (Control)part.getWidget();
            if (partCtrl == null) continue;
            partCtrl.moveBelow(null);
        }
        Control newCtrl = (Control)element.getWidget();
        newCtrl.addControlListener(this.resizeListener);
        newCtrl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ((Control)e.widget).removeControlListener(SashRenderer.this.resizeListener);
            }
        });
        this.addModelToUpdate(psc);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        ((Control)child.getWidget()).removeControlListener(this.resizeListener);
        this.addModelToUpdate(parentElement);
    }

    public void postProcess(MUIElement element) {
        if (!(element instanceof MPartSashContainer)) {
            return;
        }
        MElementContainer psc = (MElementContainer)element;
        SashForm sashForm = (SashForm)psc.getWidget();
        this.synchSashToModel((MElementContainer<MUIElement>)psc);
        sashForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SashRenderer.this.weightsMap.remove(e.widget);
            }
        });
    }

    private static int getWeight(MUIElement element) {
        String info = element.getContainerData();
        if (info == null || info.length() == 0) {
            element.setContainerData(Integer.toString(100));
            info = element.getContainerData();
        }
        try {
            int value = Integer.parseInt(info);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static int[] getModelWeights(MElementContainer<MUIElement> psc) {
        int count = 0;
        for (MUIElement element : psc.getChildren()) {
            if (element.getWidget() == null) continue;
            ++count;
        }
        int[] modelWeights = new int[count];
        int index = 0;
        for (MUIElement element : psc.getChildren()) {
            if (element.getWidget() == null) continue;
            modelWeights[index++] = SashRenderer.getWeight(element);
        }
        return modelWeights;
    }

    private static MUIElement[] getModelElements(SashForm sf) {
        Object me = sf.getData("modelElement");
        if (!(me instanceof MPartSashContainer)) {
            return null;
        }
        MPartSashContainer psc = (MPartSashContainer)me;
        ArrayList<MUIElement> modelElements = new ArrayList<MUIElement>();
        for (MUIElement element : psc.getChildren()) {
            if (element.getWidget() == null) continue;
            modelElements.add(element);
        }
        return modelElements.toArray(new MUIElement[modelElements.size()]);
    }

    private void synchSashToModel(MElementContainer<MUIElement> psc) {
        if (!(psc.getWidget() instanceof SashForm)) {
            return;
        }
        SashForm sf = (SashForm)psc.getWidget();
        if (sf.isDisposed()) {
            return;
        }
        int[] curWeights = sf.getWeights();
        assert (curWeights.length > 0);
        int[] newWeights = SashRenderer.getModelWeights(psc);
        this.weightsMap.put(sf, newWeights);
        sf.layout();
        if (newWeights.length > 0) {
            sf.setWeights(newWeights);
        }
    }

    private void synchModelToSash(SashForm sf) {
        int[] w = sf.getWeights();
        MUIElement[] elements = SashRenderer.getModelElements(sf);
        int i = 0;
        while (i < w.length) {
            elements[i].setContainerData(Integer.toString(w[i]));
            ++i;
        }
    }

    private class ModelUpdateJob
    implements Runnable {
        public List<MElementContainer<MUIElement>> sashModelsToUpdate = new ArrayList<MElementContainer<MUIElement>>();

        private ModelUpdateJob() {
        }

        public void run() {
            SashRenderer.this.clearModelUpdate();
            while (!this.sashModelsToUpdate.isEmpty()) {
                MElementContainer<MUIElement> psc = this.sashModelsToUpdate.remove(0);
                SashRenderer.this.ignoreWeightUpdates = true;
                SashRenderer.this.synchSashToModel((MElementContainer<MUIElement>)psc);
                SashRenderer.this.ignoreWeightUpdates = false;
            }
        }
    }

    private class SashUpdateJob
    implements Runnable {
        public List<SashForm> sashesToUpdate = new ArrayList<SashForm>();

        private SashUpdateJob() {
        }

        public void run() {
            SashRenderer.this.clearSashUpdate();
            while (!this.sashesToUpdate.isEmpty()) {
                SashForm sf = this.sashesToUpdate.remove(0);
                if (sf.isDisposed()) continue;
                SashRenderer.this.ignoreWeightUpdates = true;
                SashRenderer.this.synchModelToSash(sf);
                SashRenderer.this.ignoreWeightUpdates = false;
            }
        }
    }
}

