/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.editor.BaseHyperlinkDetector;
import org.eclipse.wst.xsd.ui.internal.editor.XSDHyperlink;
import org.eclipse.wst.xsd.ui.internal.editor.XSDHyperlinkTargetLocator;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class XSDHyperlinkDetector
extends BaseHyperlinkDetector {
    static /* synthetic */ Class class$0;

    protected boolean isLinkableAttribute(String name) {
        boolean isLinkable = name.equals("type") || name.equals("refer") || name.equals("ref") || name.equals("base") || name.equals("schemaLocation") || name.equals("substitutionGroup") || name.equals("itemType") || name.equals("memberTypes");
        return isLinkable;
    }

    protected IHyperlink createHyperlink(IDocument document, IDOMNode node, IRegion region) {
        XSDSchema xsdSchema = this.getXSDSchema(document);
        if (xsdSchema == null) {
            return null;
        }
        XSDConcreteComponent targetComponent = this.getTargetXSDComponent(xsdSchema, node);
        if (targetComponent != null) {
            IRegion nodeRegion = this.getHyperlinkRegion(node);
            return new XSDHyperlink(nodeRegion, targetComponent);
        }
        return null;
    }

    private XSDConcreteComponent getTargetXSDComponent(XSDSchema xsdSchema, IDOMNode node) {
        XSDConcreteComponent xsdComponent = xsdSchema.getCorrespondingComponent((Node)node);
        String attributeName = null;
        if (node instanceof Attr) {
            Attr attribute = (Attr)node;
            attributeName = attribute.getName();
        }
        XSDHyperlinkTargetLocator xsdHyperlinkTargetLocator = new XSDHyperlinkTargetLocator();
        XSDConcreteComponent component = xsdHyperlinkTargetLocator.locate(xsdComponent, attributeName);
        return component;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XSDSchema getXSDSchema(IDocument document) {
        XSDSchema schema = null;
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        if (model == null) return schema;
        try {
            IDOMDocument domDoc;
            if (model instanceof IDOMModel && (domDoc = ((IDOMModel)model).getDocument()) != null) {
                XSDModelAdapter modelAdapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                if ((modelAdapter = (XSDModelAdapter)domDoc.getExistingAdapter((Object)clazz)) != null) {
                    schema = modelAdapter.getSchema();
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            model.releaseFromRead();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        model.releaseFromRead();
        return schema;
    }
}

