/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui;

import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaRepeatable;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.util.SharedLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class PDELabelProvider
extends SharedLabelProvider {
    private static final String SYSTEM_BUNDLE = "system.bundle";

    public String getText(Object obj) {
        if (obj instanceof IPluginModelBase) {
            return this.getObjectText(((IPluginModelBase)obj).getPluginBase());
        }
        if (obj instanceof IPluginBase) {
            return this.getObjectText((IPluginBase)obj);
        }
        if (obj instanceof ImportObject) {
            return this.getObjectText((ImportObject)obj);
        }
        if (obj instanceof IProductPlugin) {
            return this.getObjectText((IProductPlugin)obj);
        }
        if (obj instanceof BundleDescription) {
            return this.getObjectText((BundleDescription)obj);
        }
        if (obj instanceof IPluginImport) {
            return this.getObjectText((IPluginImport)obj);
        }
        if (obj instanceof IPluginLibrary) {
            return this.getObjectText((IPluginLibrary)obj);
        }
        if (obj instanceof IPluginExtension) {
            return this.getObjectText((IPluginExtension)obj);
        }
        if (obj instanceof IPluginExtensionPoint) {
            return this.getObjectText((IPluginExtensionPoint)obj);
        }
        if (obj instanceof NamedElement) {
            return ((NamedElement)obj).getLabel();
        }
        if (obj instanceof ISchemaObject) {
            return this.getObjectText((ISchemaObject)obj);
        }
        if (obj instanceof FeaturePlugin) {
            return this.getObjectText((FeaturePlugin)obj);
        }
        if (obj instanceof FeatureImport) {
            return this.getObjectText((FeatureImport)obj);
        }
        if (obj instanceof IFeatureModel) {
            return this.getObjectText((IFeatureModel)obj);
        }
        if (obj instanceof FeatureChild) {
            return this.getObjectText((FeatureChild)obj);
        }
        if (obj instanceof IProductFeature) {
            return this.getObjectText((IProductFeature)obj);
        }
        if (obj instanceof ISiteFeature) {
            return this.getObjectText((ISiteFeature)obj);
        }
        if (obj instanceof ISiteArchive) {
            return this.getObjectText((ISiteArchive)obj);
        }
        if (obj instanceof ISiteCategoryDefinition) {
            return this.getObjectText((ISiteCategoryDefinition)obj);
        }
        if (obj instanceof ISiteCategory) {
            return this.getObjectText((ISiteCategory)obj);
        }
        if (obj instanceof IBuildEntry) {
            return this.getObjectText((IBuildEntry)obj);
        }
        if (obj instanceof PackageObject) {
            return this.getObjectText((PackageObject)obj);
        }
        if (obj instanceof ExecutionEnvironment) {
            return this.getObjectText((ExecutionEnvironment)obj);
        }
        if (obj instanceof Locale) {
            return this.getObjectText((Locale)obj);
        }
        return super.getText(obj);
    }

    private String getObjectText(ExecutionEnvironment environment) {
        return this.preventNull(environment.getName());
    }

    public String getObjectText(IPluginBase pluginBase) {
        String name = this.isFullNameModeEnabled() ? pluginBase.getTranslatedName() : pluginBase.getId();
        name = this.preventNull(name);
        String version = pluginBase.getVersion();
        String text = version != null && version.length() > 0 ? String.valueOf(name) + ' ' + PDELabelProvider.formatVersion(pluginBase.getVersion()) : name;
        if (SYSTEM_BUNDLE.equals(pluginBase.getId())) {
            text = String.valueOf(text) + this.getSystemBundleInfo();
        }
        if (pluginBase.getModel() != null && !pluginBase.getModel().isInSync()) {
            text = String.valueOf(text) + " " + PDEUIMessages.PluginModelManager_outOfSync;
        }
        return text;
    }

    private String getSystemBundleInfo() {
        IPluginBase systemBundle = PluginRegistry.findModel((String)SYSTEM_BUNDLE).getPluginBase();
        return NLS.bind((String)" [{0}]", (Object)systemBundle.getId());
    }

    private String preventNull(String text) {
        return text != null ? text : "";
    }

    public String getObjectText(IPluginExtension extension) {
        return this.preventNull(this.isFullNameModeEnabled() ? extension.getTranslatedName() : extension.getPoint());
    }

    public String getObjectText(IPluginExtensionPoint point) {
        return this.preventNull(this.isFullNameModeEnabled() ? point.getTranslatedName() : point.getId());
    }

    public String getObjectText(ImportObject obj) {
        String text;
        String version = obj.getImport().getVersion();
        if (version != null && version.length() > 0) {
            version = PDELabelProvider.formatVersion(version);
        }
        String string = text = this.isFullNameModeEnabled() ? obj.toString() : this.preventNull(obj.getId());
        if (SYSTEM_BUNDLE.equals(obj.getId())) {
            return String.valueOf(text) + this.getSystemBundleInfo();
        }
        return version == null || version.length() == 0 ? text : String.valueOf(text) + " " + version;
    }

    public String getObjectText(IProductPlugin obj) {
        String name = obj.getId();
        String version = obj.getVersion();
        String text = version != null && version.length() > 0 ? String.valueOf(name) + ' ' + PDELabelProvider.formatVersion(obj.getVersion()) : name;
        return this.preventNull(text);
    }

    public String getObjectText(BundleDescription bundle) {
        String id = bundle.getSymbolicName();
        if (this.isFullNameModeEnabled()) {
            IPluginModelBase model = PluginRegistry.findModel((BundleDescription)bundle);
            if (model != null) {
                return model.getPluginBase().getTranslatedName();
            }
            return id != null ? id : "?";
        }
        return this.preventNull(id);
    }

    public String getObjectText(IPluginImport obj) {
        if (this.isFullNameModeEnabled()) {
            String id = obj.getId();
            IPluginModelBase model = PluginRegistry.findModel((String)obj.getId());
            if (model != null) {
                return model.getPluginBase().getTranslatedName();
            }
            return id != null ? id : "?";
        }
        return this.preventNull(obj.getId());
    }

    public String getObjectText(IBuildEntry obj) {
        return obj.getName();
    }

    public String getObjectText(IPluginLibrary obj) {
        return this.preventNull(obj.getName());
    }

    public String getObjectText(ISchemaObject obj) {
        StringBuffer text = new StringBuffer(obj.getName());
        if (obj instanceof ISchemaRepeatable) {
            ISchemaRepeatable rso = (ISchemaRepeatable)obj;
            boolean unbounded = rso.getMaxOccurs() == Integer.MAX_VALUE;
            int maxOccurs = rso.getMaxOccurs();
            int minOccurs = rso.getMinOccurs();
            if (maxOccurs != 1 || minOccurs != 1) {
                if (PDELabelProvider.isRTL() && BidiUtil.isBidiPlatform()) {
                    text.append('\u200f');
                }
                text.append(" (");
                text.append(minOccurs);
                text.append(" - ");
                if (unbounded) {
                    text.append('*');
                } else {
                    text.append(maxOccurs);
                }
                text.append(')');
            }
        }
        return text.toString();
    }

    private String getObjectText(Locale obj) {
        String country = " (" + obj.getDisplayCountry() + ")";
        return String.valueOf(obj.getDisplayLanguage()) + (" ()".equals(country) ? "" : country);
    }

    public String getObjectText(FeaturePlugin obj) {
        String name = this.isFullNameModeEnabled() ? obj.getLabel() : obj.getId();
        String version = obj.getVersion();
        String text = version != null && version.length() > 0 ? String.valueOf(name) + ' ' + PDELabelProvider.formatVersion(version) : name;
        return this.preventNull(text);
    }

    public String getObjectText(FeatureImport obj) {
        IFeature feature;
        int type = obj.getType();
        if (type == 0) {
            IPlugin plugin = obj.getPlugin();
            if (plugin != null && this.isFullNameModeEnabled()) {
                return this.preventNull(plugin.getTranslatedName());
            }
        } else if (type == 1 && (feature = obj.getFeature()) != null && this.isFullNameModeEnabled()) {
            return this.preventNull(feature.getTranslatableLabel());
        }
        return this.preventNull(obj.getId());
    }

    public String getObjectText(IFeatureModel obj, boolean showVersion) {
        String name;
        IFeature feature = obj.getFeature();
        String string = name = this.isFullNameModeEnabled() ? feature.getTranslatableLabel() : feature.getId();
        if (!showVersion) {
            return this.preventNull(name);
        }
        return String.valueOf(this.preventNull(name)) + ' ' + PDELabelProvider.formatVersion(feature.getVersion());
    }

    public String getObjectText(IFeatureModel obj) {
        return this.getObjectText(obj, true);
    }

    public String getObjectText(FeatureChild obj) {
        return String.valueOf(this.preventNull(obj.getId())) + ' ' + PDELabelProvider.formatVersion(obj.getVersion());
    }

    public String getObjectText(IProductFeature obj) {
        String name = this.preventNull(obj.getId());
        if (VersionUtil.isEmptyVersion((String)obj.getVersion())) {
            return name;
        }
        return String.valueOf(name) + ' ' + PDELabelProvider.formatVersion(obj.getVersion());
    }

    public String getObjectText(ISiteFeature obj) {
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModel(obj.getId(), obj.getVersion() != null ? obj.getVersion() : "0.0.0");
        if (model != null) {
            return this.getObjectText(model);
        }
        return this.preventNull(obj.getURL());
    }

    public String getObjectText(ISiteArchive obj) {
        return this.preventNull(obj.getPath());
    }

    public String getObjectText(ISiteCategoryDefinition obj) {
        return this.preventNull(obj.getLabel());
    }

    public String getObjectText(PackageObject obj) {
        StringBuffer buffer = new StringBuffer(obj.getName());
        String version = obj.getVersion();
        if (version != null && !version.equals(Version.emptyVersion.toString())) {
            version = PDELabelProvider.formatVersion(version);
            buffer.append(' ').append(version);
        }
        return buffer.toString();
    }

    public String getObjectText(ISiteCategory obj) {
        ISiteCategoryDefinition def = obj.getDefinition();
        if (def != null) {
            return this.preventNull(def.getLabel());
        }
        return this.preventNull(obj.getName());
    }

    public Image getImage(Object obj) {
        if (obj instanceof IPlugin) {
            return this.getObjectImage((IPlugin)obj);
        }
        if (obj instanceof IFragment) {
            return this.getObjectImage((IFragment)obj);
        }
        if (obj instanceof IPluginModel) {
            return this.getObjectImage(((IPluginModel)obj).getPlugin());
        }
        if (obj instanceof IFragmentModel) {
            return this.getObjectImage(((IFragmentModel)obj).getFragment());
        }
        if (obj instanceof ImportObject) {
            return this.getObjectImage((ImportObject)obj);
        }
        if (obj instanceof IPluginImport) {
            return this.getObjectImage((IPluginImport)obj);
        }
        if (obj instanceof IProductPlugin) {
            return this.getObjectImage((IProductPlugin)obj);
        }
        if (obj instanceof BundleDescription) {
            return this.getObjectImage((BundleDescription)obj);
        }
        if (obj instanceof IPluginLibrary) {
            return this.getObjectImage((IPluginLibrary)obj);
        }
        if (obj instanceof IPluginExtension) {
            return this.getObjectImage((IPluginExtension)obj);
        }
        if (obj instanceof IPluginExtensionPoint) {
            return this.getObjectImage((IPluginExtensionPoint)obj);
        }
        if (obj instanceof NamedElement) {
            return ((NamedElement)obj).getImage();
        }
        if (obj instanceof ISchemaElement) {
            return this.getObjectImage((ISchemaElement)obj);
        }
        if (obj instanceof ISchemaAttribute) {
            return this.getObjectImage((ISchemaAttribute)obj);
        }
        if (obj instanceof ISchemaInclude) {
            ISchema schema = ((ISchemaInclude)obj).getIncludedSchema();
            return this.get(PDEPluginImages.DESC_PAGE_OBJ, schema == null || !schema.isValid() ? 1 : 0);
        }
        if (obj instanceof IDocumentSection || obj instanceof ISchema) {
            return this.get(PDEPluginImages.DESC_DOC_SECTION_OBJ);
        }
        if (obj instanceof ISchemaCompositor) {
            return this.getObjectImage((ISchemaCompositor)obj);
        }
        if (obj instanceof IFeatureURLElement) {
            return this.getObjectImage((IFeatureURLElement)obj);
        }
        if (obj instanceof IFeatureModel) {
            int flags = 0;
            if (((IFeatureModel)obj).getUnderlyingResource() == null) {
                flags |= 0x20;
            }
            return this.get(PDEPluginImages.DESC_FEATURE_OBJ, flags);
        }
        if (obj instanceof IFeatureChild) {
            return this.getObjectImage((IFeatureChild)obj);
        }
        if (obj instanceof IProductFeature) {
            return this.getObjectImage((IProductFeature)obj);
        }
        if (obj instanceof IFeaturePlugin) {
            return this.getObjectImage((IFeaturePlugin)obj);
        }
        if (obj instanceof IFeatureData) {
            return this.getObjectImage((IFeatureData)obj);
        }
        if (obj instanceof IFeatureImport) {
            return this.getObjectImage((IFeatureImport)obj);
        }
        if (obj instanceof IFeatureInfo) {
            return this.getObjectImage((IFeatureInfo)obj);
        }
        if (obj instanceof IBuildEntry) {
            return this.get(PDEPluginImages.DESC_BUILD_VAR_OBJ);
        }
        if (obj instanceof ISiteFeature) {
            return this.getObjectImage((ISiteFeature)obj);
        }
        if (obj instanceof ISiteArchive) {
            return this.getObjectImage((ISiteArchive)obj);
        }
        if (obj instanceof ISiteCategoryDefinition) {
            return this.getObjectImage((ISiteCategoryDefinition)obj);
        }
        if (obj instanceof ISiteCategory) {
            return this.getObjectImage((ISiteCategory)obj);
        }
        if (obj instanceof ExportPackageObject) {
            return this.getObjectImage((ExportPackageObject)obj);
        }
        if (obj instanceof PackageObject) {
            return this.getObjectImage((PackageObject)obj);
        }
        if (obj instanceof ExecutionEnvironment) {
            return this.getObjectImage((ExecutionEnvironment)obj);
        }
        if (obj instanceof ResolverError) {
            return this.getObjectImage((ResolverError)obj);
        }
        if (obj instanceof Locale) {
            return this.get(PDEPluginImages.DESC_DISCOVERY);
        }
        return super.getImage(obj);
    }

    private Image getObjectImage(ResolverError obj) {
        int type = obj.getType();
        switch (type) {
            case 1: 
            case 32: 
            case 128: 
            case 256: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
            }
            case 16384: {
                return this.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
            }
            case 2: 
            case 4: 
            case 64: 
            case 512: 
            case 1024: 
            case 2048: {
                return this.get(PDEPluginImages.DESC_PLUGIN_OBJ);
            }
        }
        return null;
    }

    private Image getObjectImage(ExecutionEnvironment environment) {
        return this.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
    }

    private Image getObjectImage(IPlugin plugin) {
        return this.getObjectImage(plugin, false, false);
    }

    private Image getObjectImage(BundleDescription bundle) {
        return bundle.getHost() == null ? this.get(PDEPluginImages.DESC_PLUGIN_OBJ) : this.get(PDEPluginImages.DESC_FRAGMENT_OBJ);
    }

    public Image getObjectImage(IPlugin plugin, boolean checkEnabled, boolean javaSearch) {
        IPluginModelBase model = plugin.getPluginModel();
        int flags = this.getModelFlags(model);
        if (javaSearch) {
            flags |= 0x40;
        }
        ImageDescriptor desc = PDEPluginImages.DESC_PLUGIN_OBJ;
        if (checkEnabled && !model.isEnabled()) {
            desc = PDEPluginImages.DESC_EXT_PLUGIN_OBJ;
        }
        return this.get(desc, flags);
    }

    private int getModelFlags(IPluginModelBase model) {
        IResource resource;
        int flags = 0;
        if (!model.isLoaded() || !model.isInSync()) {
            flags = 1;
        }
        if ((resource = model.getUnderlyingResource()) == null) {
            flags |= 0x20;
        } else {
            IProject project = resource.getProject();
            try {
                String property;
                if (WorkspaceModelManager.isBinaryProject((IProject)project) && (property = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY)) != null) {
                    flags |= 0x10;
                }
            }
            catch (CoreException coreException) {}
        }
        return flags;
    }

    private Image getObjectImage(IFragment fragment) {
        return this.getObjectImage(fragment, false, false);
    }

    public Image getObjectImage(IFragment fragment, boolean checkEnabled, boolean javaSearch) {
        IPluginModelBase model = fragment.getPluginModel();
        int flags = this.getModelFlags(model);
        if (javaSearch) {
            flags |= 0x40;
        }
        ImageDescriptor desc = PDEPluginImages.DESC_FRAGMENT_OBJ;
        if (checkEnabled && !model.isEnabled()) {
            desc = PDEPluginImages.DESC_EXT_FRAGMENT_OBJ;
        }
        return this.get(desc, flags);
    }

    private Image getObjectImage(ImportObject iobj) {
        IPlugin plugin;
        int flags = 0;
        IPluginImport iimport = iobj.getImport();
        if (!iobj.isResolved()) {
            flags = iimport.isOptional() ? 2 : 1;
        } else if (iimport.isReexported()) {
            flags = 4;
        }
        if (iimport.isOptional()) {
            flags |= 0x200;
        }
        if ((plugin = iobj.getPlugin()) != null) {
            IPluginModelBase model = plugin.getPluginModel();
            flags |= this.getModelFlags(model);
        }
        return this.get(this.getRequiredPluginImageDescriptor(iimport), flags);
    }

    protected ImageDescriptor getRequiredPluginImageDescriptor(IPluginImport iobj) {
        return PDEPluginImages.DESC_REQ_PLUGIN_OBJ;
    }

    private Image getObjectImage(IPluginImport obj) {
        int flags = 0;
        if (obj.isReexported()) {
            flags |= 4;
        }
        return this.get(this.getRequiredPluginImageDescriptor(obj), flags);
    }

    private Image getObjectImage(IProductPlugin obj) {
        Version version = obj.getVersion() != null && obj.getVersion().length() > 0 && !obj.getVersion().equals("0.0.0") ? Version.parseVersion((String)obj.getVersion()) : null;
        BundleDescription desc = TargetPlatformHelper.getState().getBundle(obj.getId(), version);
        if (desc != null) {
            return desc.getHost() == null ? this.get(PDEPluginImages.DESC_PLUGIN_OBJ) : this.get(PDEPluginImages.DESC_FRAGMENT_OBJ);
        }
        return this.get(PDEPluginImages.DESC_PLUGIN_OBJ, 1);
    }

    private Image getObjectImage(IPluginLibrary library) {
        return this.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
    }

    private Image getObjectImage(IPluginExtension point) {
        return this.get(PDEPluginImages.DESC_EXTENSION_OBJ);
    }

    private Image getObjectImage(IPluginExtensionPoint point) {
        return this.get(PDEPluginImages.DESC_EXT_POINT_OBJ);
    }

    private Image getObjectImage(ISchemaElement element) {
        int flags = 0;
        if (element instanceof ISchemaObjectReference && ((ISchemaObjectReference)element).getReferencedObject() == null) {
            flags |= 1;
        }
        ImageDescriptor desc = element instanceof ISchemaObjectReference ? PDEPluginImages.DESC_XML_ELEMENT_REF_OBJ : PDEPluginImages.DESC_GEL_SC_OBJ;
        return this.get(desc, flags);
    }

    private Image getObjectImage(ISchemaAttribute att) {
        int kind = att.getKind();
        String type = att.getType().getName();
        int use = att.getUse();
        int flags = 0;
        if (use == 0) {
            flags = 0;
        }
        if (kind == 1) {
            return this.get(PDEPluginImages.DESC_ATT_CLASS_OBJ, flags);
        }
        if (kind == 2) {
            return this.get(PDEPluginImages.DESC_ATT_FILE_OBJ, flags);
        }
        if (kind == 3) {
            return this.get(PDEPluginImages.DESC_ATT_ID_OBJ, flags);
        }
        if (type.equals(ISchemaAttribute.TYPES[0])) {
            return this.get(PDEPluginImages.DESC_ATT_BOOLEAN_OBJ, flags);
        }
        return this.get(PDEPluginImages.DESC_ATT_STRING_OBJ);
    }

    private Image getObjectImage(ISchemaCompositor compositor) {
        switch (compositor.getKind()) {
            case 0: {
                return this.get(PDEPluginImages.DESC_ALL_SC_OBJ);
            }
            case 1: {
                return this.get(PDEPluginImages.DESC_CHOICE_SC_OBJ);
            }
            case 2: {
                return this.get(PDEPluginImages.DESC_SEQ_SC_OBJ);
            }
            case 3: {
                return this.get(PDEPluginImages.DESC_GROUP_SC_OBJ);
            }
        }
        return null;
    }

    private Image getObjectImage(IFeatureURLElement url) {
        return this.get(PDEPluginImages.DESC_LINK_OBJ);
    }

    private Image getObjectImage(IFeaturePlugin plugin) {
        int flags = 0;
        if (((FeaturePlugin)plugin).getPluginBase() == null) {
            int cflag = CompilerFlags.getFlag(null, (String)"compilers.f.unresolved-plugins");
            if (cflag == 0) {
                flags = 1;
            } else if (cflag == 1) {
                flags = 2;
            }
        }
        if (plugin.isFragment()) {
            return this.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
        }
        return this.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
    }

    private Image getObjectImage(IFeatureChild feature) {
        int flags = 0;
        if (((FeatureChild)feature).getReferencedFeature() == null) {
            int cflag = CompilerFlags.getFlag(null, (String)"compilers.f.unresolved-features");
            if (cflag == 0) {
                flags = 1;
            } else if (cflag == 1) {
                flags = 2;
            }
        }
        return this.get(PDEPluginImages.DESC_FEATURE_OBJ, flags);
    }

    private Image getObjectImage(IProductFeature feature) {
        int flags = 0;
        String version = feature.getVersion().length() > 0 ? feature.getVersion() : "0.0.0";
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModel(feature.getId(), version);
        if (model == null) {
            flags = 1;
        }
        return this.get(PDEPluginImages.DESC_FEATURE_OBJ, flags);
    }

    private Image getObjectImage(IFeatureData data) {
        int flags = 0;
        if (!data.exists()) {
            flags = 1;
        }
        ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(data.getId());
        return this.get(desc, flags);
    }

    private Image getObjectImage(IFeatureImport obj) {
        ImageDescriptor base;
        FeatureImport iimport = (FeatureImport)obj;
        int type = iimport.getType();
        int flags = 0;
        if (type == 1) {
            base = PDEPluginImages.DESC_FEATURE_OBJ;
            IFeature feature = iimport.getFeature();
            if (feature == null) {
                flags = 1;
            }
        } else {
            base = PDEPluginImages.DESC_REQ_PLUGIN_OBJ;
            IPlugin plugin = iimport.getPlugin();
            if (plugin == null) {
                flags = 1;
            }
        }
        return this.get(base, flags);
    }

    private Image getObjectImage(IFeatureInfo info) {
        int flags = 0;
        String text = info.getDescription();
        if (text != null) {
            text = text.trim();
        }
        if (text != null && text.length() > 0) {
            flags = 8;
        }
        return this.get(PDEPluginImages.DESC_DOC_SECTION_OBJ, flags);
    }

    public Image getObjectImage(ISiteFeature obj) {
        int flags = 0;
        if (obj.getArchiveFile() != null) {
            flags = 16;
        }
        return this.get(PDEPluginImages.DESC_JAVA_LIB_OBJ, flags);
    }

    public Image getObjectImage(ISiteArchive obj) {
        return this.get(PDEPluginImages.DESC_JAVA_LIB_OBJ, 0);
    }

    public Image getObjectImage(ISiteCategoryDefinition obj) {
        return this.get(PDEPluginImages.DESC_CATEGORY_OBJ);
    }

    public Image getObjectImage(ISiteCategory obj) {
        int flags = obj.getDefinition() == null ? 1 : 0;
        return this.get(PDEPluginImages.DESC_CATEGORY_OBJ, flags);
    }

    public Image getObjectImage(ExportPackageObject obj) {
        int flags = 0;
        if (obj.isInternal()) {
            flags = 1024;
            if (obj.getFriends().length > 0) {
                flags = 2048;
            }
        }
        ImageDescriptor desc = JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.package_obj.gif");
        return this.get(desc, flags);
    }

    public Image getObjectImage(PackageObject obj) {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
    }

    public boolean isFullNameModeEnabled() {
        return PDEPlugin.isFullNameModeEnabled();
    }

    private static boolean isRTL() {
        Locale locale = Locale.getDefault();
        String localeString = locale.toString();
        return localeString.startsWith("ar") || localeString.startsWith("he");
    }

    public static String formatVersion(String versionRange) {
        int index;
        boolean isBasicVersion;
        boolean bl = isBasicVersion = versionRange == null || versionRange.length() == 0 || Character.isDigit(versionRange.charAt(0));
        if (isBasicVersion) {
            if (BidiUtil.isBidiPlatform()) {
                return "\u200f(\u200e" + versionRange + ")";
            }
            return "(" + versionRange + ')';
        }
        if (PDELabelProvider.isRTL() && BidiUtil.isBidiPlatform() && (index = versionRange.indexOf(44)) > 0) {
            StringBuffer buffer = new StringBuffer("\u200f\u202e");
            buffer.append(versionRange.charAt(0));
            buffer.append('\u202d');
            buffer.append(versionRange.substring(1, index));
            buffer.append("\u202c, \u202d");
            buffer.append(versionRange.substring(index + 1, versionRange.length() - 1));
            buffer.append('\u202c');
            buffer.append(versionRange.charAt(versionRange.length() - 1));
            return buffer.toString();
        }
        return versionRange;
    }
}

