/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.core.IJavaProject;

public class AptProject {
    private final IJavaProject _javaProject;
    private final GeneratedFileManager _gfm;
    private final GeneratedSourceFolderManager _gsfm;

    public AptProject(IJavaProject javaProject) {
        this._javaProject = javaProject;
        this._gsfm = new GeneratedSourceFolderManager(this);
        this._gfm = new GeneratedFileManager(this, this._gsfm);
    }

    public IJavaProject getJavaProject() {
        return this._javaProject;
    }

    public GeneratedFileManager getGeneratedFileManager() {
        return this._gfm;
    }

    public GeneratedSourceFolderManager getGeneratedSourceFolderManager() {
        return this._gsfm;
    }

    public void compilationStarted() {
        this._gfm.compilationStarted();
    }

    public void preferenceChanged(String key) {
        if ("org.eclipse.jdt.apt.genSrcDir".equals(key)) {
            this._gsfm.folderNamePreferenceChanged();
        } else if ("org.eclipse.jdt.apt.aptEnabled".equals(key)) {
            this._gsfm.enabledPreferenceChanged();
        }
    }

    public void projectClean(boolean deleteFiles) {
        IFolder f;
        this._gfm.projectCleaned();
        if (deleteFiles && (f = this._gsfm.getFolder()) != null && f.exists()) {
            try {
                IResource[] members = f.members();
                int i = 0;
                while (i < members.length) {
                    FileSystemUtil.deleteDerivedResources(members[i]);
                    ++i;
                }
            }
            catch (CoreException ce) {
                AptPlugin.log(ce, "Could not delete generated files");
            }
        }
    }

    public void projectClosed() {
        this._gfm.projectClosed();
    }

    public void projectDeleted() {
        if (AptPlugin.DEBUG) {
            AptPlugin.trace("AptProject.projectDeleted cleaning state for project " + this._javaProject.getElementName());
        }
        this._gfm.projectDeleted();
    }
}

