/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.IVirtualComponentLabelProvider;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.eclipse.wst.common.componentcore.ui.propertypage.IDependencyPageProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class DependencyPageExtensionManager {
    private static DependencyPageExtensionManager manager = null;
    private HashMap<String, IDependencyPageProvider> providers = null;

    public static DependencyPageExtensionManager getManager() {
        if (manager == null) {
            manager = new DependencyPageExtensionManager();
        }
        return manager;
    }

    public IDependencyPageProvider getProvider(IFacetedProject project) {
        if (this.providers == null) {
            this.loadProviders();
        }
        for (IDependencyPageProvider temp : this.providers.values()) {
            if (!temp.canHandle(project)) continue;
            return temp;
        }
        return null;
    }

    private void loadProviders() {
        HashMap<String, IDependencyPageProvider> temp = new HashMap<String, IDependencyPageProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "moduleDependencyPropertyPage");
        int i = 0;
        while (i < cf.length) {
            try {
                temp.put(cf[i].getAttribute("id"), (IDependencyPageProvider)cf[i].createExecutableExtension("class"));
            }
            catch (CoreException coreException) {}
            ++i;
        }
        this.providers = temp;
    }

    public WizardFragment[] loadAllReferenceWizardFragments() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "referenceWizardFragment");
        ArrayList<WizardFragment> list = new ArrayList<WizardFragment>();
        int i = 0;
        while (i < cf.length) {
            try {
                list.add((WizardFragment)cf[i].createExecutableExtension("class"));
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return list.toArray(new WizardFragment[list.size()]);
    }

    public WizardFragment loadReferenceWizardFragment(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "referenceWizardFragment");
        int i = 0;
        while (i < cf.length) {
            if (cf[i].getAttribute("id").equals(id)) {
                try {
                    return (WizardFragment)cf[i].createExecutableExtension("class");
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return null;
    }

    public ReferenceExtension[] getExposedReferenceExtensions() {
        ArrayList<ReferenceExtension> list = new ArrayList<ReferenceExtension>();
        list.addAll(Arrays.asList(this.getAllReferenceExtensions()));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (!((ReferenceExtension)i.next()).isHidden()) continue;
            i.remove();
        }
        return list.toArray(new ReferenceExtension[list.size()]);
    }

    public ReferenceExtension[] getAllReferenceExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "referenceWizardFragment");
        ArrayList<ReferenceExtension> list = new ArrayList<ReferenceExtension>();
        int i = 0;
        while (i < cf.length) {
            list.add(new ReferenceExtension(cf[i]));
            ++i;
        }
        return list.toArray(new ReferenceExtension[list.size()]);
    }

    public ReferenceExtension findReferenceExtension(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "referenceWizardFragment");
        new ArrayList();
        int i = 0;
        while (i < cf.length) {
            if (cf[i].getAttribute("id").equals(id)) {
                return new ReferenceExtension(cf[i]);
            }
            ++i;
        }
        return null;
    }

    public static IVirtualComponentLabelProvider[] loadDelegates() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "virtualComponentLabelProvider");
        List<IConfigurationElement> list = Arrays.asList(cf);
        Comparator<IConfigurationElement> c = new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                String o1String = o1.getAttribute("weight");
                o2.getAttribute("weight");
                int o1int = Integer.parseInt(o1String);
                int o2int = Integer.parseInt(o1String);
                return o1int - o2int;
            }
        };
        Collections.sort(list, c);
        ArrayList<IVirtualComponentLabelProvider> retList = new ArrayList<IVirtualComponentLabelProvider>();
        Iterator<IConfigurationElement> i = list.iterator();
        while (i.hasNext()) {
            try {
                retList.add((IVirtualComponentLabelProvider)i.next().createExecutableExtension("class"));
            }
            catch (CoreException coreException) {}
        }
        return retList.toArray(new IVirtualComponentLabelProvider[retList.size()]);
    }

    public class ReferenceExtension {
        private IConfigurationElement element;
        private String id;
        private String name;
        private String imageLoc;
        private Image image;
        private boolean hidden;

        public ReferenceExtension(IConfigurationElement element) {
            this.element = element;
            this.id = element.getAttribute("id");
            this.name = element.getAttribute("name");
            this.imageLoc = element.getAttribute("icon");
            this.hidden = Boolean.parseBoolean(element.getAttribute("hidden"));
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public Image getImage() {
            if (this.image == null && this.imageLoc != null && this.element.getContributor().getName() != null) {
                ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.element.getContributor().getName(), (String)this.imageLoc);
                this.image = desc.createImage();
            }
            return this.image;
        }

        public void disposeImage() {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
        }
    }
}

