/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.ctxhelp.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.text.DocumentObject;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ua.core.ctxhelp.ICtxHelpConstants;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpModel;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpRoot;

public abstract class CtxHelpObject
extends DocumentObject
implements ICtxHelpConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$0;

    public CtxHelpObject(CtxHelpModel model, String tagName) {
        super((IModel)model, tagName);
    }

    public List getChildren() {
        ArrayList<IDocumentElementNode> list = new ArrayList<IDocumentElementNode>();
        IDocumentElementNode[] childNodes = this.getChildNodes();
        if (childNodes.length > 0) {
            int i = 0;
            while (i < childNodes.length) {
                if (childNodes[i] instanceof CtxHelpObject) {
                    list.add(childNodes[i]);
                }
                ++i;
            }
        }
        return list;
    }

    protected String getAttributeIndent() {
        return " ";
    }

    protected String getContentIndent() {
        return "";
    }

    public boolean isLeafNode() {
        return !this.canBeParent();
    }

    public abstract boolean canBeParent();

    public abstract boolean canAddChild(int var1);

    public abstract boolean canAddSibling(int var1);

    public void addChild(CtxHelpObject newObject, CtxHelpObject targetSibling, boolean insertBefore) {
        if (this.canAddChild(newObject.getType())) {
            int currentIndex = this.indexOf((IDocumentElementNode)targetSibling);
            if (!insertBefore) {
                ++currentIndex;
            }
            this.addChildNode((IDocumentElementNode)newObject, currentIndex, true);
        }
    }

    public void addChild(CtxHelpObject newObject) {
        if (this.canAddChild(newObject.getType())) {
            this.addChildNode((IDocumentElementNode)newObject, true);
        }
    }

    public CtxHelpModel getModel() {
        IModel sharedModel = this.getSharedModel();
        if (sharedModel instanceof CtxHelpModel) {
            return (CtxHelpModel)sharedModel;
        }
        return null;
    }

    public CtxHelpRoot getRoot() {
        CtxHelpModel model = this.getModel();
        if (model != null) {
            return model.getCtxHelpRoot();
        }
        return null;
    }

    public abstract String getName();

    public abstract int getType();

    public CtxHelpObject getParent() {
        IDocumentElementNode parent = this.getParentNode();
        return parent instanceof CtxHelpObject ? (CtxHelpObject)parent : null;
    }

    public boolean descendsFrom(CtxHelpObject obj) {
        if (this.equals(obj)) {
            return true;
        }
        if (this.getParent() != null && obj.canBeParent()) {
            return this.getParent().descendsFrom(obj);
        }
        return false;
    }

    public CtxHelpObject getPreviousSibling(CtxHelpObject ctxHelpObject) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (CtxHelpObject)this.getPreviousSibling((IDocumentElementNode)ctxHelpObject, clazz);
    }

    public CtxHelpObject getNextSibling(CtxHelpObject ctxHelpObject) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (CtxHelpObject)this.getNextSibling((IDocumentElementNode)ctxHelpObject, clazz);
    }

    public boolean canBeRemoved() {
        return this.getType() != 0;
    }

    public void removeChild(CtxHelpObject object) {
        if (object.canBeRemoved()) {
            this.removeChildNode((IDocumentElementNode)object, true);
        }
    }

    public void moveChild(CtxHelpObject object, int newRelativeIndex) {
        this.moveChildNode((IDocumentElementNode)object, newRelativeIndex, true);
    }
}

