/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.QueryableArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.RepositoryLocationQuery;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.model.Updates;
import org.eclipse.equinox.internal.p2.ui.query.ArtifactKeyWrapper;
import org.eclipse.equinox.internal.p2.ui.query.ArtifactRepositoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.AvailableIUWrapper;
import org.eclipse.equinox.internal.p2.ui.query.CategoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.query.InstalledIUElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.MetadataRepositoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.ProfileElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.QueryableUpdates;
import org.eclipse.equinox.internal.p2.ui.query.RequiredIUsQuery;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class QueryProvider {
    private ProvisioningUI ui;
    public static final int METADATA_REPOS = 1;
    public static final int ARTIFACT_REPOS = 2;
    public static final int PROFILES = 3;
    public static final int AVAILABLE_IUS = 4;
    public static final int AVAILABLE_UPDATES = 5;
    public static final int INSTALLED_IUS = 6;
    public static final int AVAILABLE_ARTIFACTS = 7;

    public QueryProvider(ProvisioningUI ui) {
        this.ui = ui;
    }

    public ElementQueryDescriptor getQueryDescriptor(QueriedElement element) {
        Policy policy = this.ui.getPolicy();
        IQueryable<URI> queryable = element.getQueryable();
        int queryType = element.getQueryType();
        IUViewQueryContext context = element.getQueryContext();
        if (context == null) {
            context = ProvUI.getQueryContext(policy);
        }
        switch (queryType) {
            case 2: {
                queryable = new QueryableArtifactRepositoryManager(this.ui, false).locationsQueriable();
                return new ElementQueryDescriptor(queryable, (IQuery<?>)new RepositoryLocationQuery(), (Collector<?>)new Collector(), new ArtifactRepositoryElementWrapper(null, (Object)element));
            }
            case 4: {
                boolean showLatest = context.getShowLatestVersionsOnly();
                boolean hideInstalled = context.getHideAlreadyInstalled();
                IProfile targetProfile = null;
                String profileId = context.getInstalledProfileId();
                if (profileId != null) {
                    targetProfile = ProvUI.getProfileRegistry(this.ui.getSession()).getProfile(profileId);
                }
                IQuery topLevelQuery = policy.getVisibleAvailableIUQuery();
                IQuery categoryQuery = QueryUtil.createIUCategoryQuery();
                if (element instanceof MetadataRepositories || element instanceof MetadataRepositoryElement) {
                    if (context.getViewType() == 3 || !context.getUseCategories()) {
                        AvailableIUWrapper wrapper = new AvailableIUWrapper(queryable, element, false, context.getShowAvailableChildren());
                        if (showLatest) {
                            topLevelQuery = QueryUtil.createLatestQuery(topLevelQuery);
                        }
                        if (targetProfile != null) {
                            wrapper.markInstalledIUs(targetProfile, hideInstalled);
                        }
                        return new ElementQueryDescriptor(queryable, topLevelQuery, new Collector(), wrapper);
                    }
                    return new ElementQueryDescriptor(queryable, categoryQuery, new Collector(), new CategoryElementWrapper(queryable, element));
                }
                if (element instanceof CategoryElement || element instanceof IIUElement && ((IIUElement)((Object)element)).shouldShowChildren()) {
                    boolean drillDownTheChildren = element instanceof CategoryElement ? context.getShowAvailableChildren() : true;
                    IQuery memberOfCategoryQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)((IIUElement)((Object)element)).getIU());
                    AvailableIUWrapper availableIUWrapper = new AvailableIUWrapper(queryable, element, true, drillDownTheChildren);
                    if (targetProfile != null) {
                        availableIUWrapper.markInstalledIUs(targetProfile, hideInstalled);
                    }
                    if (element instanceof CategoryElement) {
                        if (showLatest) {
                            memberOfCategoryQuery = QueryUtil.createLatestQuery((IQuery)memberOfCategoryQuery);
                        }
                        return new ElementQueryDescriptor(queryable, memberOfCategoryQuery, new Collector(), availableIUWrapper);
                    }
                    IQuery query = QueryUtil.createCompoundQuery((IQuery)topLevelQuery, (IQuery)new RequiredIUsQuery(((IIUElement)((Object)element)).getIU()), (boolean)true);
                    if (showLatest) {
                        query = QueryUtil.createLatestQuery((IQuery)query);
                    }
                    return new ElementQueryDescriptor(queryable, query, new Collector(), availableIUWrapper);
                }
                return null;
            }
            case 5: {
                IProfile profile;
                IInstallableUnit[] toUpdate = null;
                if (element instanceof Updates) {
                    profile = ProvUI.getProfileRegistry(this.ui.getSession()).getProfile(((Updates)element).getProfileId());
                    toUpdate = ((Updates)element).getIUs();
                } else {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    profile = (IProfile)ProvUI.getAdapter(element, clazz);
                }
                if (profile == null) {
                    return null;
                }
                if (toUpdate == null) {
                    Class<?> clazz;
                    IQueryResult queryResult = profile.query(policy.getVisibleInstalledIUQuery(), null);
                    try {
                        clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    toUpdate = (IInstallableUnit[])queryResult.toArray(clazz);
                }
                QueryableUpdates updateQueryable = new QueryableUpdates(this.ui, toUpdate);
                return new ElementQueryDescriptor(updateQueryable, context.getShowLatestVersionsOnly() ? QueryUtil.createLatestIUQuery() : QueryUtil.createIUAnyQuery(), new Collector());
            }
            case 6: {
                Class<?> clazz;
                if (element instanceof IIUElement && context.getShowInstallChildren()) {
                    Collection<IRequirement> reqs = ((IIUElement)((Object)element)).getRequirements();
                    IExpression[] requirementExpressions = new IExpression[reqs.size()];
                    int i = 0;
                    Iterator<IRequirement> iterator = reqs.iterator();
                    while (iterator.hasNext()) {
                        IRequirement req = iterator.next();
                        requirementExpressions[i++] = req.getMatches();
                    }
                    IExpressionFactory factory = ExpressionUtil.getFactory();
                    IQuery meetsAnyRequirementQuery = QueryUtil.createMatchQuery((IExpression)factory.or(requirementExpressions), (Object[])new Object[0]);
                    IQuery<IInstallableUnit> visibleAsAvailableQuery = policy.getVisibleAvailableIUQuery();
                    IQuery createCompoundQuery = QueryUtil.createCompoundQuery(visibleAsAvailableQuery, (IQuery)meetsAnyRequirementQuery, (boolean)true);
                    return new ElementQueryDescriptor(queryable, createCompoundQuery, new Collector(), new InstalledIUElementWrapper(queryable, element));
                }
                try {
                    clazz = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IProfile profile = (IProfile)ProvUI.getAdapter(element, clazz);
                if (profile == null) {
                    return null;
                }
                return new ElementQueryDescriptor((IQueryable<?>)profile, policy.getVisibleInstalledIUQuery(), (Collector<?>)new Collector(), new InstalledIUElementWrapper((IQueryable<?>)profile, element));
            }
            case 1: {
                if (element instanceof MetadataRepositories) {
                    if (queryable == null) {
                        queryable = new QueryableMetadataRepositoryManager(this.ui, ((MetadataRepositories)element).getIncludeDisabledRepositories()).locationsQueriable();
                        element.setQueryable(queryable);
                    }
                    return new ElementQueryDescriptor(element.getQueryable(), (IQuery<?>)new RepositoryLocationQuery(), (Collector<?>)new Collector(), new MetadataRepositoryElementWrapper(null, (Object)element));
                }
                return null;
            }
            case 3: {
                Class<?> clazz;
                queryable = new IQueryable<URI>(this.ui);
                try {
                    clazz = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return new ElementQueryDescriptor(queryable, QueryUtil.createMatchQuery(clazz, (IExpression)ExpressionUtil.TRUE_EXPRESSION, (Object[])new Object[0]), new Collector(), new ProfileElementWrapper(null, (Object)element));
            }
            case 7: {
                if (!(queryable instanceof IArtifactRepository)) {
                    return null;
                }
                return new ElementQueryDescriptor(queryable, (IQuery<?>)ArtifactKeyQuery.ALL_KEYS, (Collector<?>)new Collector(), new ArtifactKeyWrapper((IArtifactRepository)queryable, (Object)element));
            }
        }
        return null;
    }
}

