/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.test;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.e4.internal.languages.javascript.JSBundleData;
import org.eclipse.e4.internal.languages.javascript.JSBundleImpl;
import org.eclipse.e4.internal.languages.javascript.JSExportPackage;
import org.eclipse.e4.internal.languages.javascript.JSFrameworkImpl;
import org.eclipse.e4.languages.javascript.JSBundle;
import org.eclipse.e4.languages.javascript.JSBundleException;
import org.osgi.framework.Version;

public class JSExportTest
extends TestCase {
    public JSExportTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testBothNull() {
        try {
            new JSExportPackage(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSExportTest.fail();
    }

    public void testNullHeader() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        try {
            new JSExportPackage(null, (JSBundle)jsBundle);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSExportTest.fail();
    }

    public void testNullJSBundle() {
        try {
            new JSExportPackage("a.a", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSExportTest.fail();
    }

    public void testNameAndEmptyVersion() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        JSExportPackage jsExport = new JSExportPackage("a.a", (JSBundle)jsBundle);
        JSExportTest.assertEquals((String)"a.a", (String)jsExport.getName());
        JSExportTest.assertEquals((Object)Version.emptyVersion, (Object)jsExport.getVersion());
        JSExportTest.assertEquals((String)"test", (String)jsExport.getBundleSymbolicName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jsExport.getBundleVersion());
        JSExportTest.assertEquals((int)0, (int)jsExport.getAttributes().size());
        JSExportTest.assertEquals((int)0, (int)jsExport.getDirectives().size());
        JSExportTest.assertEquals((int)0, (int)jsExport.getMandatory().size());
    }

    public void testNameAndVersion() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        JSExportPackage jsExport = new JSExportPackage("a.a;version=1.2.1", (JSBundle)jsBundle);
        JSExportTest.assertEquals((String)"a.a", (String)jsExport.getName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.2.1"), (Object)jsExport.getVersion());
        JSExportTest.assertEquals((String)"test", (String)jsExport.getBundleSymbolicName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jsExport.getBundleVersion());
        JSExportTest.assertEquals((int)1, (int)jsExport.getAttributes().size());
        JSExportTest.assertEquals((int)0, (int)jsExport.getDirectives().size());
        JSExportTest.assertEquals((int)0, (int)jsExport.getMandatory().size());
    }

    public void testMandatory() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        JSExportPackage jsExport = new JSExportPackage("a.a;i=1;j=2;mandatory:=i,j;version=1.2.1", (JSBundle)jsBundle);
        JSExportTest.assertEquals((String)"a.a", (String)jsExport.getName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.2.1"), (Object)jsExport.getVersion());
        JSExportTest.assertEquals((String)"test", (String)jsExport.getBundleSymbolicName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jsExport.getBundleVersion());
        JSExportTest.assertEquals((int)3, (int)jsExport.getAttributes().size());
        JSExportTest.assertEquals((int)1, (int)jsExport.getDirectives().size());
        JSExportTest.assertEquals((int)2, (int)jsExport.getMandatory().size());
    }
}

